/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.server;

import com.liferay.arquillian.extension.junit.bridge.command.RunNotifierCommand;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class TestExecutorRunnable
implements Runnable {
    private static final Logger _logger = Logger.getLogger(TestExecutorRunnable.class.getName());
    private final Bundle _bundle;
    private final Map<String, List<String>> _filteredMethodNamesMap;
    private final long _passCode;
    private final String _reportServerHostName;
    private final int _reportServerPort;

    public TestExecutorRunnable(Bundle bundle, Map<String, List<String>> filteredMethodNamesMap, String reportServerHostName, int reportServerPort, long passCode) {
        this._bundle = bundle;
        this._filteredMethodNamesMap = filteredMethodNamesMap;
        this._reportServerHostName = reportServerHostName;
        this._reportServerPort = reportServerPort;
        this._passCode = passCode;
    }

    @Override
    public void run() {
        try {
            Socket socket = new Socket(this._reportServerHostName, this._reportServerPort);
            Throwable throwable = null;
            try {
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                    Throwable throwable2 = null;
                    try {
                        try {
                            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
                            Throwable throwable3 = null;
                            try {
                                try {
                                    objectOutputStream.writeLong(this._passCode);
                                    objectOutputStream.flush();
                                    while (true) {
                                        String testClass = objectInputStream.readUTF();
                                        TestExecutorRunnable._execute(this._createTestClass(testClass), objectOutputStream);
                                        objectOutputStream.writeObject(null);
                                        objectOutputStream.flush();
                                    }
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (objectInputStream != null) {
                                    if (throwable3 != null) {
                                        try {
                                            objectInputStream.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable3.addSuppressed(throwable6);
                                        }
                                    } else {
                                        objectInputStream.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable2 = throwable7;
                            throw throwable7;
                        }
                    }
                    catch (Throwable throwable8) {
                        if (objectOutputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    objectOutputStream.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable2.addSuppressed(throwable9);
                                }
                            } else {
                                objectOutputStream.close();
                            }
                        }
                        throw throwable8;
                    }
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
            }
            catch (Throwable throwable11) {
                if (socket != null) {
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                    } else {
                        socket.close();
                    }
                }
                throw throwable11;
            }
        }
        catch (EOFException socket) {
        }
        catch (Exception e) {
            try {
                this._bundle.uninstall();
            }
            catch (BundleException be) {
                e.addSuppressed(be);
            }
            _logger.log(Level.SEVERE, "Unable to report back to client. Uninstalled test bundle and abort test.", e);
        }
    }

    private static Statement _classBlock(final TestClass testClass, Description description, final ObjectOutputStream objectOutputStream) {
        Statement statement = new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                for (FrameworkMethod frameworkMethod : testClass.getAnnotatedMethods(Test.class)) {
                    Description description = Description.createTestDescription((String)testClass.getName(), (String)frameworkMethod.getName(), (Annotation[])new Annotation[0]);
                    try {
                        objectOutputStream.writeObject(RunNotifierCommand.testStarted(description));
                        objectOutputStream.flush();
                        Statement statement = TestExecutorRunnable._methodBlock(testClass, frameworkMethod.getMethod());
                        statement.evaluate();
                    }
                    catch (Throwable t) {
                        TestExecutorRunnable._processThrowable(false, t, objectOutputStream, description);
                    }
                    finally {
                        objectOutputStream.writeObject(RunNotifierCommand.testFinished(description));
                        objectOutputStream.flush();
                    }
                }
            }
        };
        statement = TestExecutorRunnable._withBefores(statement, BeforeClass.class, testClass, statement);
        statement = TestExecutorRunnable._withAfters(statement, AfterClass.class, testClass, statement);
        statement = TestExecutorRunnable._withRules(statement, ClassRule.class, testClass, null, description);
        return statement;
    }

    private static void _execute(TestClass testClass, ObjectOutputStream objectOutputStream) throws IOException {
        Description description = Description.createSuiteDescription((Class)testClass.getJavaClass());
        try {
            Statement statement = TestExecutorRunnable._classBlock(testClass, description, objectOutputStream);
            statement.evaluate();
        }
        catch (Throwable t) {
            TestExecutorRunnable._processThrowable(true, t, objectOutputStream, description);
        }
    }

    private static Throwable _findAssumptionViolatedException(Throwable throwable) {
        if (throwable instanceof AssumptionViolatedException) {
            return throwable;
        }
        int n = 0;
        Throwable[] suppressions = throwable.getSuppressed();
        Throwable[] throwableArray = suppressions;
        int n2 = throwableArray.length;
        if (n < n2) {
            Throwable suppression = throwableArray[n];
            return TestExecutorRunnable._findAssumptionViolatedException(suppression);
        }
        return null;
    }

    private static Class _getExpectedExceptionClass(Method method) {
        Test test = method.getAnnotation(Test.class);
        if (test == null) {
            return Test.None.class;
        }
        return test.expected();
    }

    private static Statement _methodBlock(TestClass testClass, final Method method) throws Throwable {
        final Class clazz = testClass.getJavaClass();
        final Object target = clazz.newInstance();
        InvokeMethod statement = new InvokeMethod(null, target){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Thread currentThread = Thread.currentThread();
                ClassLoader classLoader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(clazz.getClassLoader());
                Throwable throwable = null;
                try {
                    method.invoke(target, new Object[0]);
                }
                catch (Throwable t) {
                    throwable = t;
                }
                finally {
                    currentThread.setContextClassLoader(classLoader);
                }
                if (throwable == null) {
                    Class throwableClass = TestExecutorRunnable._getExpectedExceptionClass(method);
                    if (Test.None.class != throwableClass) {
                        throw new AssertionError((Object)("Expected test to throw " + throwableClass));
                    }
                } else {
                    if (throwable instanceof InvocationTargetException) {
                        throwable = throwable.getCause();
                    }
                    if (throwable instanceof AssumptionViolatedException) {
                        throw throwable;
                    }
                    TestExecutorRunnable._processExpectedException(throwable, method);
                }
            }
        };
        statement = TestExecutorRunnable._withTimeout(method, (Statement)statement);
        statement = TestExecutorRunnable._withBefores((Statement)statement, Before.class, testClass, target);
        statement = TestExecutorRunnable._withAfters((Statement)statement, After.class, testClass, target);
        statement = TestExecutorRunnable._withRules((Statement)statement, Rule.class, testClass, target, Description.createTestDescription((Class)clazz, (String)method.getName(), (Annotation[])method.getAnnotations()));
        return statement;
    }

    private static void _processExpectedException(Throwable throwable, Method method) throws Throwable {
        Class expectedThrown = TestExecutorRunnable._getExpectedExceptionClass(method);
        if (expectedThrown == Test.None.class) {
            throw throwable;
        }
        Class<?> clazz = throwable.getClass();
        if (!expectedThrown.isAssignableFrom(clazz)) {
            String message = "Unexpected exception, expected<" + expectedThrown.getName() + "> but was<" + clazz.getName() + ">";
            throw new Exception(message, throwable);
        }
    }

    private static void _processThrowable(boolean classLevel, Throwable throwable, ObjectOutputStream objectOutputStream, Description description) throws IOException {
        Throwable assumptionViolatedException = TestExecutorRunnable._findAssumptionViolatedException(throwable);
        if (assumptionViolatedException != null) {
            if (classLevel) {
                objectOutputStream.writeObject(RunNotifierCommand.testStarted(description));
            }
            AssumptionViolatedException ave = new AssumptionViolatedException(assumptionViolatedException.getMessage());
            ave.setStackTrace(assumptionViolatedException.getStackTrace());
            objectOutputStream.writeObject(RunNotifierCommand.assumptionFailed(description, ave));
            if (classLevel) {
                objectOutputStream.writeObject(RunNotifierCommand.testFinished(description));
            }
        } else if (throwable instanceof MultipleFailureException) {
            MultipleFailureException mfe = (MultipleFailureException)throwable;
            for (Throwable t : mfe.getFailures()) {
                TestExecutorRunnable._processThrowable(objectOutputStream, description, t);
            }
        } else {
            TestExecutorRunnable._processThrowable(objectOutputStream, description, throwable);
        }
        objectOutputStream.flush();
    }

    private static void _processThrowable(ObjectOutputStream objectOutputStream, Description description, Throwable t) throws IOException {
        try {
            objectOutputStream.writeObject(RunNotifierCommand.testFailure(description, t));
        }
        catch (NotSerializableException nse) {
            objectOutputStream.reset();
            Class<?> clazz = t.getClass();
            Exception serializableException = new Exception(clazz.getName() + ": " + t.getMessage());
            serializableException.setStackTrace(t.getStackTrace());
            nse.initCause(serializableException);
            objectOutputStream.writeObject(RunNotifierCommand.testFailure(description, nse));
        }
    }

    private static Statement _withAfters(Statement statement, Class<? extends Annotation> afterClass, TestClass junitTestClass, Object target) {
        List frameworkMethods = junitTestClass.getAnnotatedMethods(afterClass);
        if (!frameworkMethods.isEmpty()) {
            statement = new RunAfters(statement, frameworkMethods, target);
        }
        return statement;
    }

    private static Statement _withBefores(Statement statement, Class<? extends Annotation> beforeClass, TestClass junitTestClass, Object target) {
        List frameworkMethods = junitTestClass.getAnnotatedMethods(beforeClass);
        if (!frameworkMethods.isEmpty()) {
            statement = new RunBefores(statement, frameworkMethods, target);
        }
        return statement;
    }

    private static Statement _withRules(Statement statement, Class<? extends Annotation> ruleClass, TestClass junitTestClass, Object target, Description description) {
        List testRules = junitTestClass.getAnnotatedMethodValues(target, ruleClass, TestRule.class);
        testRules.addAll(junitTestClass.getAnnotatedFieldValues(target, ruleClass, TestRule.class));
        if (!testRules.isEmpty()) {
            statement = new RunRules(statement, (Iterable)testRules, description);
        }
        return statement;
    }

    private static Statement _withTimeout(Method method, Statement statement) {
        Test test = method.getAnnotation(Test.class);
        if (test == null || test.timeout() <= 0L) {
            return statement;
        }
        FailOnTimeout.Builder builder = FailOnTimeout.builder();
        builder.withTimeout(test.timeout(), TimeUnit.MILLISECONDS);
        return builder.build(statement);
    }

    private TestClass _createTestClass(String testClassName) throws ClassNotFoundException {
        return new TestClass(this._bundle.loadClass(testClassName)){

            protected void scanAnnotatedMembers(Map<Class<? extends Annotation>, List<FrameworkMethod>> frameworkMethodsMap, Map<Class<? extends Annotation>, List<FrameworkField>> frameworkFieldsMap) {
                List filteredMethodNames;
                super.scanAnnotatedMembers(frameworkMethodsMap, frameworkFieldsMap);
                List<FrameworkMethod> testFrameworkMethods = frameworkMethodsMap.get(Test.class);
                List<FrameworkMethod> ignoreFrameworkMethods = frameworkMethodsMap.get(Ignore.class);
                if (ignoreFrameworkMethods != null) {
                    testFrameworkMethods.removeAll(ignoreFrameworkMethods);
                }
                if ((filteredMethodNames = (List)TestExecutorRunnable.this._filteredMethodNamesMap.get(this.getName())) != null) {
                    testFrameworkMethods.removeIf(frameworkMethod -> filteredMethodNames.contains(frameworkMethod.getName()));
                }
                testFrameworkMethods.sort(Comparator.comparing(FrameworkMethod::getName));
            }
        };
    }
}

