/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.server;

import com.liferay.arquillian.extension.junit.bridge.server.TestExecutorRunnable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class TestBundleListener
implements BundleListener {
    private final Map<String, List<String>> _filteredMethodNamesMap;
    private final long _passCode;
    private final String _reportServerHostName;
    private final int _reportServerPort;
    private final BundleContext _systemBundleContext;
    private final Bundle _testBundle;
    private Thread _testExecutorThread;

    public TestBundleListener(BundleContext systemBundleContext, Bundle testBundle, Map<String, List<String>> filteredMethodNamesMap, String reportServerHostName, int reportServerPort, long passCode) {
        this._systemBundleContext = systemBundleContext;
        this._testBundle = testBundle;
        this._filteredMethodNamesMap = filteredMethodNamesMap;
        this._reportServerHostName = reportServerHostName;
        this._reportServerPort = reportServerPort;
        this._passCode = passCode;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        if (!this._testBundle.equals(bundle)) {
            return;
        }
        this._bundleChanged(bundle);
    }

    private synchronized void _bundleChanged(Bundle bundle) {
        if (bundle.getState() == 32) {
            this._testExecutorThread = new Thread((Runnable)new TestExecutorRunnable(this._testBundle, this._filteredMethodNamesMap, this._reportServerHostName, this._reportServerPort, this._passCode), this._testBundle.getSymbolicName() + "-executor-thread");
            this._testExecutorThread.setDaemon(true);
            this._testExecutorThread.start();
            return;
        }
        if (bundle.getState() <= 4) {
            this._systemBundleContext.removeBundleListener((BundleListener)this);
            if (this._testExecutorThread != null) {
                this._testExecutorThread.interrupt();
            }
        }
    }
}

