/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.server;

import com.liferay.arquillian.extension.junit.bridge.server.TestBundleListener;
import com.liferay.arquillian.extension.junit.bridge.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

public class TestBundleActivator
implements BundleActivator {
    public void start(BundleContext bundleContext) throws Exception {
        Bundle testBundle = bundleContext.getBundle();
        URL url = testBundle.getResource("/META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest();
        try (InputStream inputStream = url.openStream();){
            manifest.read(inputStream);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unable to read test manifest", ioe);
        }
        Attributes attributes = manifest.getMainAttributes();
        String reportServerHostName = attributes.getValue("Test-Bridge-Report-Server-Host-Name");
        int reportServerPort = Integer.parseInt(attributes.getValue("Test-Bridge-Report-Server-Port"));
        HashMap<String, List<String>> filteredMethodNamesMap = new HashMap<String, List<String>>();
        for (String filteredMethodNamesEntry : StringUtil.split(attributes.getValue("Test-Bridge-Filtered-Method-Names"), ';')) {
            int index = filteredMethodNamesEntry.indexOf(58);
            filteredMethodNamesMap.put(filteredMethodNamesEntry.substring(0, index), StringUtil.split(filteredMethodNamesEntry.substring(index + 1), ','));
        }
        long passCode = Long.parseLong(attributes.getValue("Test-Bridge-Pass-Code"));
        Bundle systemBundle = bundleContext.getBundle(0L);
        BundleContext systemBundleContext = systemBundle.getBundleContext();
        systemBundleContext.addBundleListener((BundleListener)new TestBundleListener(systemBundleContext, testBundle, filteredMethodNamesMap, reportServerHostName, reportServerPort, passCode));
    }

    public void stop(BundleContext bundleContext) {
    }
}

