/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.junit;

import com.liferay.arquillian.extension.junit.bridge.client.ClientState;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class Arquillian
extends Runner
implements Filterable {
    private static final ClientState _clientState = new ClientState();
    private final Class<?> _clazz;
    private Map<String, List<String>> _filteredMethodNamesMap;
    private final List<Method> _testMethods;

    public Arquillian(Class<?> clazz) {
        this._clazz = clazz;
        this._testMethods = Arquillian._scanTestMethods(clazz);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Arquillian._filter(this._clazz, this._testMethods, filter);
        if (this._testMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
        _clientState.filterTestClasses(this._clazz, testClass -> {
            List<Method> testMethods = Arquillian._scanTestMethods(testClass);
            List<String> filteredMethodNames = Arquillian._filter(testClass, testMethods, filter);
            if (testMethods.isEmpty()) {
                return true;
            }
            if (!filteredMethodNames.isEmpty()) {
                if (this._filteredMethodNamesMap == null) {
                    this._filteredMethodNamesMap = new HashMap<String, List<String>>();
                }
                this._filteredMethodNamesMap.put(testClass.getName(), filteredMethodNames);
            }
            return false;
        });
    }

    public Description getDescription() {
        return Description.createSuiteDescription(this._clazz);
    }

    public void run(RunNotifier runNotifier) {
        this._testMethods.removeIf(method -> {
            if (method.getAnnotation(Ignore.class) != null) {
                runNotifier.fireTestIgnored(Description.createTestDescription(this._clazz, (String)method.getName(), (Annotation[])method.getAnnotations()));
                return true;
            }
            return false;
        });
        if (this._testMethods.isEmpty()) {
            _clientState.removeTestClass(this._clazz);
            return;
        }
        try {
            Class.forName(this._clazz.getName(), true, this._clazz.getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            runNotifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)cnfe));
            return;
        }
        try (ClientState.Connection connection = _clientState.open(this._clazz, this._filteredMethodNamesMap);){
            connection.execute(this._clazz.getName(), runNotifierCommand -> runNotifierCommand.execute(runNotifier));
        }
        catch (Throwable t) {
            runNotifier.fireTestFailure(new Failure(this.getDescription(), t));
        }
    }

    private static List<String> _filter(Class<?> clazz, List<Method> testMethods, Filter filter) {
        ArrayList<String> filteredMethodNames = new ArrayList<String>();
        Iterator<Method> iterator = testMethods.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            String methodName = method.getName();
            if (filter.shouldRun(Description.createTestDescription(clazz, (String)methodName))) continue;
            filteredMethodNames.add(methodName);
            iterator.remove();
        }
        return filteredMethodNames;
    }

    private static List<Method> _scanTestMethods(Class<?> clazz) {
        ArrayList<Method> testMethods = new ArrayList<Method>();
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getAnnotation(Test.class) == null) continue;
                testMethods.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        testMethods.sort(Comparator.comparing(Method::getName));
        return testMethods;
    }
}

