/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.WriteAbortedException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketState {
    private static final int _START_PORT = 32764;
    private static final Logger _logger = Logger.getLogger(SocketState.class.getName());
    private static final InetAddress _inetAddress = InetAddress.getLoopbackAddress();
    private ObjectInputStream _objectInputStream;
    private ObjectOutputStream _objectOutputStream;
    private ServerSocket _serverSocket;
    private Socket _socket;

    public void close() throws IOException {
        this._objectInputStream.close();
        this._objectInputStream = null;
        this._objectOutputStream.close();
        this._objectOutputStream = null;
        this._socket.close();
        this._socket = null;
        this._serverSocket.close();
        this._serverSocket = null;
    }

    public void connect(long passCode) throws IOException {
        while (true) {
            this._socket = this._serverSocket.accept();
            this._objectOutputStream = new ObjectOutputStream(this._socket.getOutputStream());
            this._objectInputStream = new ObjectInputStream(this._socket.getInputStream());
            if (passCode == this._objectInputStream.readLong()) break;
            _logger.log(Level.WARNING, "Pass code mismatch, dropped connection from " + this._socket.getRemoteSocketAddress());
            this._objectInputStream.close();
            this._objectOutputStream.close();
            this._socket.close();
        }
    }

    public ServerSocket getServerSocket() throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        int port = 32764;
        while (true) {
            try {
                ServerSocket serverSocket = serverSocketChannel.socket();
                serverSocket.bind(new InetSocketAddress(_inetAddress, port));
                this._serverSocket = serverSocket;
                return serverSocket;
            }
            catch (IOException ioe) {
                ++port;
                continue;
            }
            break;
        }
    }

    public long readLong() throws IOException {
        return this._objectInputStream.readLong();
    }

    public Object readObject() throws Exception {
        try {
            return this._objectInputStream.readObject();
        }
        catch (WriteAbortedException wae) {
            return this._objectInputStream.readObject();
        }
    }

    public void writeObject(Object object) throws IOException {
        this._objectOutputStream.writeObject(object);
        this._objectOutputStream.flush();
    }

    public void writeUTF(String string) throws IOException {
        this._objectOutputStream.writeUTF(string);
        this._objectOutputStream.flush();
    }
}

