/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.client;

import com.liferay.arquillian.extension.junit.bridge.connector.FrameworkCommand;
import com.liferay.arquillian.extension.junit.bridge.connector.FrameworkResult;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FrameworkState {
    private static final int _MAX_RETRY_ATTEMPTS = 5;
    private static final int _PORT = 32763;
    private static final int _RETRY_INTERVAL = 10;
    private static final Logger _logger = Logger.getLogger(FrameworkState.class.getName());
    private static final InetAddress _inetAddress = InetAddress.getLoopbackAddress();
    private ObjectInputStream _objectInputStream;
    private ObjectOutputStream _objectOutputStream;
    private Socket _socket;

    public void close() throws IOException {
        this._objectInputStream.close();
        this._objectInputStream = null;
        this._objectOutputStream.close();
        this._objectOutputStream = null;
        this._socket.close();
        this._socket = null;
    }

    public void connect() throws Exception {
        Integer port = Integer.getInteger("liferay.arquillian.port");
        if (port == null) {
            port = 32763;
        }
        int retries = 0;
        while (true) {
            try {
                this._socket = new Socket(_inetAddress, (int)port);
            }
            catch (ConnectException ce) {
                if (retries++ < 5) {
                    _logger.log(Level.INFO, "Unable to connect at " + _inetAddress.getHostAddress() + ":" + port + ". retrying in " + 10 + "s.");
                    Thread.sleep(10000L);
                    continue;
                }
                _logger.log(Level.SEVERE, "Unable to connect after 5 attempts");
                throw ce;
            }
            break;
        }
        this._objectOutputStream = new ObjectOutputStream(this._socket.getOutputStream());
        this._objectInputStream = new ObjectInputStream(this._socket.getInputStream());
        String passcode = System.getProperty("liferay.arquillian.passcode");
        if (passcode == null) {
            passcode = "";
        }
        this._objectOutputStream.writeUTF(passcode);
        this._objectOutputStream.flush();
    }

    public long installBundle(String location, byte[] bytes) throws Throwable {
        this._objectOutputStream.writeObject(FrameworkCommand.installBundle(location, bytes));
        this._objectOutputStream.flush();
        return (Long)this._getResult();
    }

    public void startBundle(long bundleId) throws Throwable {
        this._objectOutputStream.writeObject(FrameworkCommand.startBundle(bundleId));
        this._objectOutputStream.flush();
        this._getResult();
    }

    public void uninstallBundle(long bundleId) throws Throwable {
        this._objectOutputStream.writeObject(FrameworkCommand.uninstallBundle(bundleId));
        this._objectOutputStream.flush();
        this._getResult();
    }

    private <T extends Serializable> T _getResult() throws Throwable {
        FrameworkResult frameworkResult = (FrameworkResult)this._objectInputStream.readObject();
        return frameworkResult.get();
    }
}

