/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.connector;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public interface FrameworkCommand<T extends Serializable>
extends Serializable {
    public static FrameworkCommand<Long> installBundle(String location, byte[] bytes) {
        return bundleContext -> {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                Bundle bundle = bundleContext.installBundle(location, (InputStream)inputStream);
                Long l = bundle.getBundleId();
                return l;
            }
        };
    }

    public static FrameworkCommand<?> startBundle(long bundleId) {
        return bundleContext -> {
            Bundle bundle = bundleContext.getBundle(bundleId);
            bundle.start();
            return null;
        };
    }

    public static FrameworkCommand<?> uninstallBundle(long bundleId) {
        return bundleContext -> {
            Bundle bundle = bundleContext.getBundle(bundleId);
            bundle.uninstall();
            return null;
        };
    }

    public T execute(BundleContext var1) throws Exception;
}

