/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.arquillian.extension.junit.bridge.connector;

import com.liferay.arquillian.extension.junit.bridge.connector.ArquillianConnectorThread;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Component(configurationPid={"com.liferay.arquillian.extension.junit.bridge.connector.ArquillianConnectorConfiguration"}, immediate=true, service={})
public class ArquillianConnector {
    private static final int _DEFAULT_PORT = 32763;
    private static final InetAddress _inetAddress = InetAddress.getLoopbackAddress();
    private ArquillianConnectorThread _arquillianConnectorThread;
    @Reference
    private LoggerFactory _loggerFactory;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, String> properties) {
        int port = 32763;
        String portString = properties.get("port");
        if (portString != null) {
            port = Integer.valueOf(portString);
        }
        Logger logger = this._loggerFactory.getLogger(ArquillianConnector.class);
        logger.info("Listening on port {}", (Object)port);
        try {
            this._arquillianConnectorThread = new ArquillianConnectorThread(bundleContext, _inetAddress, port, properties.get("passcode"), logger);
        }
        catch (IOException ioe) {
            logger.error("Encountered a problem while using {}:{}. Shutting down now.", new Object[]{_inetAddress.getHostAddress(), port, ioe});
            System.exit(-10);
        }
        this._arquillianConnectorThread.start();
    }

    @Deactivate
    public void deacticate() throws Exception {
        this._arquillianConnectorThread.close();
        this._arquillianConnectorThread.join();
    }
}

