/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.my.account.permissions.internal.model.listener;

import com.liferay.application.list.PanelApp;
import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.PrefsProps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    private static final Log _log = LogFactoryUtil.getLog(CompanyModelListener.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private PanelAppRegistry _panelAppRegistry;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PrefsProps _prefsProps;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    private ServiceTracker<PanelApp, PanelApp> _serviceTracker;

    public void onAfterCreate(Company company) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry);
            List panelApps = panelCategoryHelper.getAllPanelApps("user.my_account");
            ArrayList<Portlet> portlets = new ArrayList<Portlet>(panelApps.size());
            for (PanelApp panelApp : panelApps) {
                Portlet portlet = this._portletLocalService.getPortletById(panelApp.getPortletId());
                portlets.add(portlet);
            }
            this._initPermissions(company.getCompanyId(), portlets);
            return null;
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)StringBundler.concat((String[])new String[]{"(&(objectClass=", PanelApp.class.getName(), ")", "(panel.category.key=", "user.my_account", "*))"}), (ServiceTrackerCustomizer)new PanelAppServiceTrackerCustomizer(bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private Role _getUserRole(long companyId) {
        try {
            return this._roleLocalService.getRole(companyId, "User");
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get user role in company " + companyId), (Throwable)portalException);
            return null;
        }
    }

    private void _initPermissions(long companyId, List<Portlet> portlets) {
        Role userRole = this._getUserRole(companyId);
        if (userRole == null) {
            return;
        }
        for (Portlet portlet : portlets) {
            try {
                List actionIds = ResourceActionsUtil.getPortletResourceActions((String)portlet.getRootPortletId());
                this._initPermissions(companyId, portlet.getPortletId(), portlet.getRootPortletId(), userRole, actionIds);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to initialize My Account panel permissions ", "for portlet ", portlet.getPortletId(), " in company ", companyId}), (Throwable)exception);
            }
        }
    }

    private void _initPermissions(long companyId, String portletId, String rootPortletId, Role userRole, List<String> actionIds) throws Exception {
        PortletPreferences portletPreferences = this._portletPreferencesFactory.getLayoutPortletSetup(companyId, companyId, 1, 0L, portletId, "<portlet-preferences />");
        if (this._prefsProps.getBoolean(portletPreferences, "myAccountAccessInControlPanelPermissionsInitialized")) {
            return;
        }
        if (actionIds.contains("ACCESS_IN_CONTROL_PANEL")) {
            this._resourcePermissionLocalService.addResourcePermission(companyId, rootPortletId, 1, String.valueOf(companyId), userRole.getRoleId(), "ACCESS_IN_CONTROL_PANEL");
        }
        portletPreferences.setValue("myAccountAccessInControlPanelPermissionsInitialized", "true");
        portletPreferences.store();
    }

    private void _initPermissions(Portlet portlet) {
        this._companyLocalService.forEachCompany(company -> this._initPermissions(company.getCompanyId(), Arrays.asList(portlet)));
    }

    private class PanelAppServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PanelApp, PanelApp> {
        private final BundleContext _bundleContext;

        public PanelAppServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public PanelApp addingService(ServiceReference<PanelApp> serviceReference) {
            PanelApp panelApp = (PanelApp)this._bundleContext.getService(serviceReference);
            try {
                Portlet portlet = panelApp.getPortlet();
                if (portlet == null) {
                    portlet = CompanyModelListener.this._portletLocalService.getPortletById(panelApp.getPortletId());
                }
                if (portlet == null) {
                    Class<?> panelAppClass = panelApp.getClass();
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to get portlet ", panelApp.getPortletId(), " for panel app ", panelAppClass.getName()}));
                    return panelApp;
                }
                CompanyModelListener.this._initPermissions(portlet);
                return panelApp;
            }
            catch (Throwable throwable) {
                this._bundleContext.ungetService(serviceReference);
                throw throwable;
            }
        }

        public void modifiedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
        }

        public void removedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
            this._bundleContext.ungetService(serviceReference);
        }
    }
}

