/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.my.account.permissions.internal;

import com.liferay.application.list.PanelApp;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.PrefsProps;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={PanelAppMyAccountPermissions.class})
public class PanelAppMyAccountPermissions {
    private static final Log _log = LogFactoryUtil.getLog(PanelAppMyAccountPermissions.class);
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PrefsProps _prefsProps;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    private ServiceTracker<PanelApp, PanelApp> _serviceTracker;

    public void initPermissions(List<Company> companies, Portlet portlet) {
        for (Company company : companies) {
            this.initPermissions(company.getCompanyId(), Arrays.asList(portlet));
        }
    }

    public void initPermissions(long companyId, List<Portlet> portlets) {
        Role userRole = this._getUserRole(companyId);
        if (userRole == null) {
            return;
        }
        for (Portlet portlet : portlets) {
            try {
                List actionIds = ResourceActionsUtil.getPortletResourceActions((String)portlet.getRootPortletId());
                this._initPermissions(companyId, portlet.getPortletId(), portlet.getRootPortletId(), userRole, actionIds);
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to initialize My Account panel permissions ", "for portlet ", portlet.getPortletId(), " in company ", companyId}), (Throwable)exception);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        String filter = StringBundler.concat((String[])new String[]{"(&(objectClass=", PanelApp.class.getName(), ")", "(panel.category.key=", "user.my_account", "*))"});
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)filter, (ServiceTrackerCustomizer)new PanelAppServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private Role _getUserRole(long companyId) {
        try {
            return this._roleLocalService.getRole(companyId, "User");
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get user role in company " + companyId), (Throwable)portalException);
            return null;
        }
    }

    private void _initPermissions(long companyId, String portletId, String rootPortletId, Role userRole, List<String> actionIds) throws Exception {
        PortletPreferences portletPreferences = this._portletPreferencesFactory.getLayoutPortletSetup(companyId, companyId, 1, 0L, portletId, "<portlet-preferences />");
        if (this._prefsProps.getBoolean(portletPreferences, "myAccountAccessInControlPanelPermissionsInitialized")) {
            return;
        }
        if (actionIds.contains("ACCESS_IN_CONTROL_PANEL")) {
            this._resourcePermissionLocalService.addResourcePermission(companyId, rootPortletId, 1, String.valueOf(companyId), userRole.getRoleId(), "ACCESS_IN_CONTROL_PANEL");
        }
        portletPreferences.setValue("myAccountAccessInControlPanelPermissionsInitialized", "true");
        portletPreferences.store();
    }

    private class PanelAppServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PanelApp, PanelApp> {
        private PanelAppServiceTrackerCustomizer() {
        }

        public PanelApp addingService(ServiceReference<PanelApp> reference) {
            PanelApp panelApp = (PanelApp)PanelAppMyAccountPermissions.this._bundleContext.getService(reference);
            try {
                Portlet portlet = panelApp.getPortlet();
                if (portlet == null) {
                    portlet = PanelAppMyAccountPermissions.this._portletLocalService.getPortletById(panelApp.getPortletId());
                }
                if (portlet == null) {
                    Class<?> panelAppClass = panelApp.getClass();
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to get portlet ", panelApp.getPortletId(), " for panel app ", panelAppClass.getName()}));
                    return panelApp;
                }
                PanelAppMyAccountPermissions.this.initPermissions(PanelAppMyAccountPermissions.this._companyLocalService.getCompanies(), portlet);
                return panelApp;
            }
            catch (Throwable t) {
                PanelAppMyAccountPermissions.this._bundleContext.ungetService(reference);
                throw t;
            }
        }

        public void modifiedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
            this.removedService(serviceReference, panelApp);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
            PanelAppMyAccountPermissions.this._bundleContext.ungetService(serviceReference);
        }
    }
}

