/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.display.context.logic;

import com.liferay.application.list.PanelApp;
import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.PanelCategory;
import com.liferay.application.list.PanelCategoryRegistry;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import java.util.ArrayList;
import java.util.List;

public class PanelCategoryHelper {
    private final PanelAppRegistry _panelAppRegistry;
    private final PanelCategoryRegistry _panelCategoryRegistry;

    public PanelCategoryHelper(PanelAppRegistry panelAppRegistry, PanelCategoryRegistry panelCategoryRegistry) {
        this._panelAppRegistry = panelAppRegistry;
        this._panelCategoryRegistry = panelCategoryRegistry;
    }

    public boolean containsPortlet(String portletId, String panelCategoryKey) {
        for (PanelCategory curPanelCategory : this._panelCategoryRegistry.getChildPanelCategories(panelCategoryKey)) {
            if (this.hasPortlet(portletId, curPanelCategory.getKey())) {
                return true;
            }
            if (!this.containsPortlet(portletId, curPanelCategory.getKey())) continue;
            return true;
        }
        return this.hasPortlet(portletId, panelCategoryKey);
    }

    public boolean containsPortlet(String portletId, String panelCategoryKey, PermissionChecker permissionChecker, Group group) {
        for (PanelCategory curPanelCategory : this._panelCategoryRegistry.getChildPanelCategories(panelCategoryKey, permissionChecker, group)) {
            if (this.hasPortlet(portletId, curPanelCategory.getKey(), permissionChecker, group)) {
                return true;
            }
            if (!this.containsPortlet(portletId, curPanelCategory.getKey(), permissionChecker, group)) continue;
            return true;
        }
        return this.hasPortlet(portletId, panelCategoryKey, permissionChecker, group);
    }

    public List<PanelApp> getAllPanelApps(String panelCategoryKey) {
        ArrayList<PanelApp> panelApps = new ArrayList<PanelApp>();
        panelApps.addAll(this._panelAppRegistry.getPanelApps(panelCategoryKey));
        for (PanelCategory childPanelCategory : this._panelCategoryRegistry.getChildPanelCategories(panelCategoryKey)) {
            panelApps.addAll(this.getAllPanelApps(childPanelCategory.getKey()));
        }
        return panelApps;
    }

    public String getFirstPortletId(String panelCategoryKey, PermissionChecker permissionChecker, Group group) {
        PanelApp panelApp = this._panelAppRegistry.getFirstPanelApp(panelCategoryKey, permissionChecker, group);
        if (panelApp != null) {
            return panelApp.getPortletId();
        }
        List<PanelCategory> panelCategories = this._panelCategoryRegistry.getChildPanelCategories(panelCategoryKey, permissionChecker, group);
        if (panelCategories.isEmpty()) {
            return null;
        }
        for (PanelCategory panelCategory : panelCategories) {
            panelApp = this._panelAppRegistry.getFirstPanelApp(panelCategory.getKey(), permissionChecker, group);
            if (panelApp == null) continue;
            return panelApp.getPortletId();
        }
        return null;
    }

    public int getNotificationsCount(String panelCategoryKey, PermissionChecker permissionChecker, Group group, User user) {
        int count = this._panelCategoryRegistry.getChildPanelCategoriesNotificationsCount(this, panelCategoryKey, permissionChecker, group, user);
        return count += this._panelAppRegistry.getPanelAppsNotificationsCount(panelCategoryKey, permissionChecker, group, user);
    }

    public boolean hasPanelApp(String portletId) {
        return this.containsPortlet(portletId, "applications_menu") || this.containsPortlet(portletId, "root");
    }

    public boolean isApplicationsMenuApp(String portletId) {
        return this.containsPortlet(portletId, "applications_menu");
    }

    public boolean isControlPanelApp(String portletId) {
        return this.containsPortlet(portletId, "control_panel");
    }

    protected boolean hasPortlet(String portletId, String panelCategoryKey) {
        List<PanelApp> panelApps = this._panelAppRegistry.getPanelApps(panelCategoryKey);
        for (PanelApp panelApp : panelApps) {
            if (!portletId.equals(panelApp.getPortletId())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasPortlet(String portletId, String panelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelApp> panelApps = this._panelAppRegistry.getPanelApps(panelCategoryKey, permissionChecker, group);
        for (PanelApp panelApp : panelApps) {
            if (!portletId.equals(panelApp.getPortletId())) continue;
            return true;
        }
        return false;
    }
}

