/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.adapter;

import com.liferay.application.list.PanelApp;
import com.liferay.application.list.adapter.PortletPanelAppAdapter;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortletCategoryUtil;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PortletPanelAppAdapterServiceTrackerCustomizer
implements ServiceTrackerCustomizer<Portlet, PanelApp> {
    private final BundleContext _bundleContext;
    private final Map<ServiceReference<Portlet>, ServiceRegistration<PanelApp>> _serviceRegistrations;

    public PortletPanelAppAdapterServiceTrackerCustomizer(BundleContext bundleContext, Map<ServiceReference<Portlet>, ServiceRegistration<PanelApp>> serviceRegistrations) {
        this._bundleContext = bundleContext;
        this._serviceRegistrations = serviceRegistrations;
    }

    public PanelApp addingService(ServiceReference<Portlet> serviceReference) {
        String portletId = (String)serviceReference.getProperty("javax.portlet.name");
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        String controlPanelCategory = (String)serviceReference.getProperty("com.liferay.portlet.control-panel-entry-category");
        if (Validator.isNull((String)controlPanelCategory)) {
            return null;
        }
        PortletPanelAppAdapter portletPanelAppAdapter = new PortletPanelAppAdapter(portletId);
        HashMapDictionary panelAppProperties = new HashMapDictionary();
        panelAppProperties.put("panel.category.key", PortletCategoryUtil.getPortletCategoryKey((String)controlPanelCategory));
        Integer serviceRanking = this.getServiceRanking(serviceReference);
        if (serviceRanking != null) {
            panelAppProperties.put("service.ranking", serviceRanking);
        }
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(PanelApp.class, (Object)portletPanelAppAdapter, (Dictionary)panelAppProperties);
        this._serviceRegistrations.put(serviceReference, (ServiceRegistration<PanelApp>)serviceRegistration);
        return portletPanelAppAdapter;
    }

    public void modifiedService(ServiceReference<Portlet> serviceReference, PanelApp panelApp) {
        this.removedService(serviceReference, panelApp);
        this.addingService((ServiceReference)serviceReference);
    }

    public void removedService(ServiceReference<Portlet> serviceReference, PanelApp panelApp) {
        ServiceRegistration<PanelApp> serviceRegistration = this._serviceRegistrations.remove(serviceReference);
        serviceRegistration.unregister();
    }

    protected Integer getServiceRanking(ServiceReference<Portlet> serviceReference) {
        String controlPanelEntryWeight = (String)serviceReference.getProperty("com.liferay.portlet.control-panel-entry-weight");
        if (Validator.isNotNull((String)controlPanelEntryWeight)) {
            return (int)Math.ceil(GetterUtil.getDouble((String)controlPanelEntryWeight) * 100.0);
        }
        return null;
    }
}

