/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list;

import com.liferay.application.list.GroupProvider;
import com.liferay.application.list.PanelApp;
import com.liferay.application.list.PanelCategory;
import com.liferay.application.list.util.PanelCategoryServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.PrefsProps;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PanelAppRegistry.class})
public class PanelAppRegistry {
    protected GroupProvider groupProvider;
    protected PortletLocalService portletLocalService;
    private static final Log _log = LogFactoryUtil.getLog(PanelAppRegistry.class);
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PrefsProps _prefsProps;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    private ServiceTrackerMap<String, List<PanelApp>> _serviceTrackerMap;

    public PanelApp getFirstPanelApp(String parentPanelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelApp> panelApps = this.getPanelApps(parentPanelCategoryKey);
        for (PanelApp panelApp : panelApps) {
            try {
                if (!panelApp.isShow(permissionChecker, group)) continue;
                return panelApp;
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return null;
    }

    public List<PanelApp> getPanelApps(PanelCategory parentPanelCategory) {
        return this.getPanelApps(parentPanelCategory.getKey());
    }

    public List<PanelApp> getPanelApps(PanelCategory parentPanelCategory, PermissionChecker permissionChecker, Group group) {
        return this.getPanelApps(parentPanelCategory.getKey(), permissionChecker, group);
    }

    public List<PanelApp> getPanelApps(String parentPanelCategoryKey) {
        List panelApps = (List)this._serviceTrackerMap.getService((Object)parentPanelCategoryKey);
        if (panelApps == null) {
            return Collections.emptyList();
        }
        return panelApps;
    }

    public List<PanelApp> getPanelApps(String parentPanelCategoryKey, final PermissionChecker permissionChecker, final Group group) {
        List<PanelApp> panelApps = this.getPanelApps(parentPanelCategoryKey);
        if (panelApps.isEmpty()) {
            return panelApps;
        }
        return ListUtil.filter(panelApps, (PredicateFilter)new PredicateFilter<PanelApp>(){

            public boolean filter(PanelApp panelApp) {
                try {
                    return panelApp.isShow(permissionChecker, group);
                }
                catch (PortalException pe) {
                    _log.error((Object)pe, (Throwable)pe);
                    return false;
                }
            }
        });
    }

    public int getPanelAppsNotificationsCount(String parentPanelCategoryKey, PermissionChecker permissionChecker, Group group, User user) {
        int count = 0;
        for (PanelApp panelApp : this.getPanelApps(parentPanelCategoryKey)) {
            int notificationsCount = panelApp.getNotificationsCount(user);
            try {
                if (notificationsCount <= 0 || !panelApp.isShow(permissionChecker, group)) continue;
                count += notificationsCount;
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return count;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, PanelApp.class, (String)"(panel.category.key=*)", (ServiceReferenceMapper)new PanelCategoryServiceReferenceMapper(), (Comparator)new PanelAppOrderComparator(), (ServiceTrackerMapListener)new PanelAppsServiceTrackerMapListener());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    @Reference(unbind="-")
    protected void setGroupProvider(GroupProvider groupProvider) {
        this.groupProvider = groupProvider;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this.portletLocalService = portletLocalService;
    }

    private class PanelAppsServiceTrackerMapListener
    implements ServiceTrackerMapListener<String, PanelApp, List<PanelApp>> {
        private PanelAppsServiceTrackerMapListener() {
        }

        public void keyEmitted(ServiceTrackerMap<String, List<PanelApp>> serviceTrackerMap, String panelCategoryKey, PanelApp panelApp, List<PanelApp> panelApps) {
            panelApp.setGroupProvider(PanelAppRegistry.this.groupProvider);
            Portlet portlet = PanelAppRegistry.this.portletLocalService.getPortletById(panelApp.getPortletId());
            if (portlet != null) {
                portlet.setControlPanelEntryCategory(panelCategoryKey);
                panelApp.setPortlet(portlet);
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get portlet " + panelApp.getPortletId()));
            }
        }

        public void keyRemoved(ServiceTrackerMap<String, List<PanelApp>> serviceTrackerMap, String panelCategoryKey, PanelApp panelApp, List<PanelApp> panelApps) {
        }
    }

    private class PanelAppOrderComparator
    implements Comparator<ServiceReference<PanelApp>>,
    Serializable {
        private PanelAppOrderComparator() {
        }

        @Override
        public int compare(ServiceReference serviceReference1, ServiceReference serviceReference2) {
            if (serviceReference1 == null) {
                if (serviceReference2 == null) {
                    return 0;
                }
                return 1;
            }
            if (serviceReference2 == null) {
                return -1;
            }
            Object propertyValue1 = serviceReference1.getProperty("panel.app.order");
            Object propertyValue2 = serviceReference2.getProperty("panel.app.order");
            if (propertyValue1 == null) {
                if (propertyValue2 == null) {
                    return 0;
                }
                return 1;
            }
            if (propertyValue2 == null) {
                return -1;
            }
            if (!(propertyValue2 instanceof Comparable)) {
                return -serviceReference2.compareTo((Object)serviceReference1);
            }
            Comparable propertyValueComparable2 = (Comparable)propertyValue2;
            return -propertyValueComparable2.compareTo(propertyValue1);
        }
    }
}

