/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list;

import com.liferay.application.list.GroupProvider;
import com.liferay.application.list.PanelApp;
import com.liferay.application.list.PanelCategory;
import com.liferay.application.list.util.PanelCategoryServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PanelAppRegistry.class})
public class PanelAppRegistry {
    protected GroupProvider groupProvider;
    protected PortletLocalService portletLocalService;
    private static final Log _log = LogFactoryUtil.getLog(PanelAppRegistry.class);
    private ServiceTrackerMap<String, List<PanelApp>> _serviceTrackerMap;

    public PanelApp getFirstPanelApp(String parentPanelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelApp> panelApps = this.getPanelApps(parentPanelCategoryKey);
        for (PanelApp panelApp : panelApps) {
            try {
                if (!panelApp.isShow(permissionChecker, group)) continue;
                return panelApp;
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return null;
    }

    public List<PanelApp> getPanelApps(PanelCategory parentPanelCategory) {
        return this.getPanelApps(parentPanelCategory.getKey());
    }

    public List<PanelApp> getPanelApps(PanelCategory parentPanelCategory, PermissionChecker permissionChecker, Group group) {
        return this.getPanelApps(parentPanelCategory.getKey(), permissionChecker, group);
    }

    public List<PanelApp> getPanelApps(String parentPanelCategoryKey) {
        List panelApps = (List)this._serviceTrackerMap.getService((Object)parentPanelCategoryKey);
        if (panelApps == null) {
            return Collections.emptyList();
        }
        return panelApps;
    }

    public List<PanelApp> getPanelApps(String parentPanelCategoryKey, final PermissionChecker permissionChecker, final Group group) {
        List<PanelApp> panelApps = this.getPanelApps(parentPanelCategoryKey);
        if (panelApps.isEmpty()) {
            return panelApps;
        }
        return ListUtil.filter(panelApps, (PredicateFilter)new PredicateFilter<PanelApp>(){

            public boolean filter(PanelApp panelApp) {
                try {
                    return panelApp.isShow(permissionChecker, group);
                }
                catch (PortalException pe) {
                    _log.error((Object)pe, (Throwable)pe);
                    return false;
                }
            }
        });
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, PanelApp.class, (String)"(panel.category.key=*)", (ServiceReferenceMapper)new PanelCategoryServiceReferenceMapper(), Collections.reverseOrder(new PropertyServiceReferenceComparator("panel.app.order")), (ServiceTrackerMapListener)new PanelAppsServiceTrackerMapListener());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    @Reference(unbind="-")
    protected void setGroupProvider(GroupProvider groupProvider) {
        this.groupProvider = groupProvider;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this.portletLocalService = portletLocalService;
    }

    private class PanelAppsServiceTrackerMapListener
    implements ServiceTrackerMapListener<String, PanelApp, List<PanelApp>> {
        private PanelAppsServiceTrackerMapListener() {
        }

        public void keyEmitted(ServiceTrackerMap<String, List<PanelApp>> serviceTrackerMap, String panelCategoryKey, PanelApp panelApp, List<PanelApp> panelApps) {
            panelApp.setGroupProvider(PanelAppRegistry.this.groupProvider);
            Portlet portlet = PanelAppRegistry.this.portletLocalService.getPortletById(panelApp.getPortletId());
            if (portlet != null) {
                portlet.setControlPanelEntryCategory(panelCategoryKey);
                panelApp.setPortlet(portlet);
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get portlet " + panelApp.getPortletId()));
            }
        }

        public void keyRemoved(ServiceTrackerMap<String, List<PanelApp>> serviceTrackerMap, String panelCategoryKey, PanelApp panelApp, List<PanelApp> panelApps) {
        }
    }
}

