/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.test.util.writer;

import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.operation.DeleteOperation;
import com.liferay.apio.architect.internal.request.RequestInfo;
import com.liferay.apio.architect.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.test.util.identifier.FirstEmbeddedId;
import com.liferay.apio.architect.test.util.identifier.SecondEmbeddedId;
import com.liferay.apio.architect.test.util.identifier.ThirdEmbeddedId;
import com.liferay.apio.architect.test.util.model.FirstEmbeddedModel;
import com.liferay.apio.architect.test.util.model.SecondEmbeddedModel;
import com.liferay.apio.architect.test.util.model.ThirdEmbeddedModel;
import com.liferay.apio.architect.test.util.representor.MockRepresentorCreator;
import com.liferay.apio.architect.uri.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;

public class MockWriterUtil {
    public static String getIdentifierName(Class<? extends Identifier<?>> identifierClass) {
        if (identifierClass.equals(FirstEmbeddedId.class)) {
            return "first";
        }
        if (identifierClass.equals(SecondEmbeddedId.class)) {
            return "second";
        }
        if (identifierClass.equals(ThirdEmbeddedId.class)) {
            return "third";
        }
        return null;
    }

    public static Optional<Representor<?>> getRepresentorOptional(String resourceName) {
        if ("root".equals(resourceName)) {
            return Optional.of(MockRepresentorCreator.createRootModelRepresentor(false));
        }
        if ("first".equals(resourceName)) {
            return Optional.of(MockRepresentorCreator.createFirstEmbeddedModelRepresentor());
        }
        if ("second".equals(resourceName)) {
            return Optional.of(MockRepresentorCreator.createSecondEmbeddedModelRepresentor());
        }
        return Optional.of(MockRepresentorCreator.createThirdEmbeddedModelRepresentor());
    }

    public static RequestInfo getRequestInfo() {
        return RequestInfo.create(builder -> builder.httpServletRequest(null).serverURL(() -> "localhost").applicationURL(() -> "localhost/o/api").embedded(Arrays.asList("embedded1", "embedded1.embedded")::contains).fields(__ -> string -> true).language(Locale::getDefault).build());
    }

    public static Optional<SingleModel> getSingleModel(Object identifier, Class<? extends Identifier> identifierClass) {
        if (!(identifier instanceof String)) {
            return Optional.empty();
        }
        if (identifierClass.equals(FirstEmbeddedId.class)) {
            List<Operation> operations = Collections.singletonList(new DeleteOperation("resource"));
            return Optional.of(new SingleModelImpl<FirstEmbeddedModel>(() -> (String)identifier, "first", operations));
        }
        if (identifierClass.equals(SecondEmbeddedId.class)) {
            return Optional.of(new SingleModelImpl<SecondEmbeddedModel>(() -> (String)identifier, "second", Collections.emptyList()));
        }
        if (identifierClass.equals(ThirdEmbeddedId.class)) {
            return Optional.of(new SingleModelImpl<ThirdEmbeddedModel>(() -> (String)identifier, "third", Collections.emptyList()));
        }
        return Optional.empty();
    }

    public static Optional<Path> identifierToPath(String resourceName, Object identifier) {
        if (!(identifier instanceof String)) {
            return Optional.empty();
        }
        String string = (String)identifier;
        Function<String, Optional> function = name -> Optional.of(new Path(name, string));
        if ("root".equals(resourceName)) {
            return function.apply("model");
        }
        if ("first".equals(resourceName)) {
            return function.apply("first-inner-model");
        }
        if ("second".equals(resourceName)) {
            return function.apply("second-inner-model");
        }
        return function.apply("third-inner-model");
    }

    private MockWriterUtil() {
        throw new UnsupportedOperationException();
    }
}

