/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.test.util.json;

import com.liferay.apio.architect.error.APIError;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.message.json.BatchResultMessageMapper;
import com.liferay.apio.architect.internal.message.json.DocumentationMessageMapper;
import com.liferay.apio.architect.internal.message.json.EntryPointMessageMapper;
import com.liferay.apio.architect.internal.message.json.ErrorMessageMapper;
import com.liferay.apio.architect.internal.message.json.FormMessageMapper;
import com.liferay.apio.architect.internal.message.json.MessageMapper;
import com.liferay.apio.architect.internal.message.json.PageMessageMapper;
import com.liferay.apio.architect.internal.message.json.SingleModelMessageMapper;
import com.liferay.apio.architect.internal.writer.ErrorWriter;
import com.liferay.apio.architect.test.util.internal.writer.MockBatchResultWriter;
import com.liferay.apio.architect.test.util.internal.writer.MockDocumentationWriter;
import com.liferay.apio.architect.test.util.internal.writer.MockEntryPointWriter;
import com.liferay.apio.architect.test.util.internal.writer.MockFormWriter;
import com.liferay.apio.architect.test.util.internal.writer.MockPageWriter;
import com.liferay.apio.architect.test.util.internal.writer.MockSingleModelWriter;
import com.liferay.apio.architect.test.util.model.RootModel;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;

public class MessageMapperTesterBuilder {
    public static MediaTypeStep path(Path path) {
        return new MediaTypeStep(path);
    }

    public static class MessageMapperStep {
        private static final APIError _MOCK_API_ERROR = new APIError((Exception)new IllegalArgumentException(), "A title", "A description", "A type", 404);
        private final String _mediaType;
        private final Path _path;

        public MessageMapperStep validateBatchResultMessageMapper(BatchResultMessageMapper<String> batchResultMessageMapper) {
            String result = MockBatchResultWriter.write(batchResultMessageMapper);
            this._validateMessageMapper(batchResultMessageMapper, result, "batch");
            return this;
        }

        public MessageMapperStep validateDocumentationMessageMapper(DocumentationMessageMapper documentationMessageMapper) {
            String result = MockDocumentationWriter.write(documentationMessageMapper);
            this._validateMessageMapper(documentationMessageMapper, result, "documentation");
            return this;
        }

        public MessageMapperStep validateEntryPointMessageMapper(EntryPointMessageMapper entryPointMessageMapper) {
            String actual = MockEntryPointWriter.write(entryPointMessageMapper);
            this._validateMessageMapper(entryPointMessageMapper, actual, "entrypoint");
            return this;
        }

        public MessageMapperStep validateErrorMessageMapper(ErrorMessageMapper errorMessageMapper) {
            String actual = ErrorWriter.writeError(errorMessageMapper, _MOCK_API_ERROR);
            this._validateMessageMapper(errorMessageMapper, actual, "error");
            return this;
        }

        public MessageMapperStep validateFormMessageMapper(FormMessageMapper formMessageMapper) {
            String result = MockFormWriter.write(formMessageMapper);
            this._validateMessageMapper(formMessageMapper, result, "form");
            return this;
        }

        public MessageMapperStep validatePageMessageMapper(PageMessageMapper<RootModel> pageMessageMapper) {
            String result = MockPageWriter.write(pageMessageMapper);
            this._validateMessageMapper(pageMessageMapper, result, "page");
            return this;
        }

        public MessageMapperStep validateSingleModelMessageMapper(SingleModelMessageMapper<RootModel> singleModelMessageMapper) {
            String result = MockSingleModelWriter.write(singleModelMessageMapper);
            this._validateMessageMapper(singleModelMessageMapper, result, "single_model");
            return this;
        }

        private MessageMapperStep(Path path, String mediaType) {
            this._path = path;
            this._mediaType = mediaType;
        }

        private void _validateMessageMapper(MessageMapper messageMapper, String actual, String fileName) {
            MatcherAssert.assertThat((Object)messageMapper.getMediaType(), (Matcher)Is.is((Object)this._mediaType));
            String file = fileName + ".json";
            String stringPath = this._path.toString();
            String folder = stringPath.substring(stringPath.lastIndexOf(File.separator) + 1);
            String expected = (String)Try.success((Object)stringPath).map(path -> Paths.get(path, file)).map(Files::readAllBytes).recoverWith(__ -> Try.fromFallible(this::getClass).map(Class::getClassLoader).map(classLoader -> classLoader.getResource(folder + File.separator + file)).map(URL::getPath).map(File::new).map(File::toPath).map(Files::readAllBytes)).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).orElseThrow(() -> new AssertionError((Object)("Unable to found the file: " + file)));
            try {
                JSONAssert.assertEquals((String)expected, (String)actual, (boolean)true);
            }
            catch (JSONException jsone) {
                throw new AssertionError((Object)jsone.getMessage());
            }
        }
    }

    public static class MediaTypeStep {
        private final Path _path;

        public MessageMapperStep mediaType(String mediaType) {
            return new MessageMapperStep(this._path, mediaType);
        }

        private MediaTypeStep(Path path) {
            this._path = path;
        }
    }
}

