/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.test.util.internal.list;

import com.liferay.apio.architect.internal.list.FunctionalList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsAFunctionalList<E>
extends TypeSafeDiagnosingMatcher<FunctionalList<E>> {
    private final Matcher<Iterable<? extends E>> _matcher;

    public IsAFunctionalList(Matcher<Iterable<? extends E>> matcher) {
        this._matcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("a functional list that conforms with an ").appendDescriptionOf(this._matcher);
    }

    protected boolean matchesSafely(FunctionalList<E> functionalList, Description description) {
        E head = functionalList.head();
        List list = Stream.concat(Stream.of(head), functionalList.tailStream()).collect(Collectors.toList());
        if (this._matcher.matches(list)) {
            return true;
        }
        description.appendText("was a functional list whose ");
        this._matcher.describeMismatch(list, description);
        return false;
    }
}

