/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.test.util.form;

import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.date.DateTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.text.IsEmptyString;

public class FormConditions<T>
extends TypeSafeDiagnosingMatcher<Form<T>> {
    private final Body _body;
    private final List<Matcher<T>> _matchers;

    public void describeTo(Description description) {
        description.appendText("a Form...\n").appendText("\t...that should have a non empty title\n").appendText("\t...that should have a non empty description\n");
        this._matchers.forEach(matcher -> description.appendText("\t...that ").appendDescriptionOf((SelfDescribing)matcher).appendText("\n"));
    }

    protected boolean matchesSafely(Form<T> form, Description description) {
        Stream stream;
        List<Matcher> matchers;
        Object t = form.get(this._body);
        String title = form.getTitle(Locale::getDefault);
        boolean result = true;
        if (IsEmptyString.emptyOrNullString().matches((Object)title)) {
            description.appendText("was a Form...\n").appendText("\t...whose title was ").appendDescriptionOf((SelfDescribing)IsEmptyString.emptyOrNullString()).appendText("\n");
            result = false;
        }
        String formDescription = form.getDescription(Locale::getDefault);
        if (IsEmptyString.emptyOrNullString().matches((Object)formDescription)) {
            if (result) {
                description.appendText("was a Form...\n");
            }
            description.appendText("\t...whose description was ").appendDescriptionOf((SelfDescribing)IsEmptyString.emptyOrNullString()).appendText("\n");
            result = false;
        }
        if (!(matchers = (stream = this._matchers.stream()).filter(matcher -> !matcher.matches(t)).collect(Collectors.toList())).isEmpty()) {
            if (result) {
                description.appendText("was a Form...\n");
            }
            matchers.forEach(matcher -> {
                description.appendText("\t...that ");
                matcher.describeMismatch(t, description);
                description.appendText("\n");
            });
            result = false;
        }
        return result;
    }

    private FormConditions(Body body, List<Matcher<T>> matchers) {
        this._body = body;
        this._matchers = matchers;
    }

    public static class Builder<T> {
        private final Map<String, List<String>> _listMap = new HashMap<String, List<String>>();
        private final Map<String, String> _map = new HashMap<String, String>();
        private final List<Matcher<T>> _matchers = new ArrayList<Matcher<T>>();

        public FormConditions<T> build() {
            Body body = Body.create(key -> Optional.ofNullable(this._map.get(key)), key -> Optional.ofNullable(this._listMap.get(key)));
            return new FormConditions(body, this._matchers);
        }

        public Builder<T> whereBoolean(String key, Function<Object, Matcher<T>> function) {
            this._add(key, function, "true", true);
            return this;
        }

        public Builder<T> whereDate(String key, Function<Object, Matcher<T>> function) {
            String dateString = "2016-06-15T09:00Z";
            Try<Date> dateTry = DateTransformer.asDate(dateString);
            Date date = (Date)dateTry.orElseThrow(AssertionError::new);
            this._map.put(key, dateString);
            this._matchers.add(function.apply(date));
            return this;
        }

        public Builder<T> whereDouble(String key, Function<Object, Matcher<T>> function) {
            this._add(key, function, "21.2", 21.2);
            return this;
        }

        public Builder<T> whereIdentifier(String key, Object value, Function<Object, Matcher<T>> function) {
            this._add(key, function, "", value);
            return this;
        }

        public Builder<T> whereLong(String key, Function<Object, Matcher<T>> function) {
            this._add(key, function, "42", 42L);
            return this;
        }

        public Builder<T> whereString(String key, Function<Object, Matcher<T>> function) {
            this._add(key, function, "String", "String");
            return this;
        }

        public Builder<T> whereStringList(String key, Function<Object, Matcher<T>> function) {
            this._addList(key, function, Arrays.asList("String1", "String2"), Arrays.asList("String1", "String2"));
            return this;
        }

        private void _add(String key, Function<Object, Matcher<T>> function, String value, Object transformedValue) {
            this._map.put(key, value);
            this._matchers.add(function.apply(transformedValue));
        }

        private void _addList(String key, Function<Object, Matcher<T>> function, List<String> list, List<Object> transformedList) {
            this._listMap.put(key, list);
            this._matchers.add(function.apply(transformedList));
        }
    }
}

