/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.writer;

import com.liferay.apio.architect.alias.representor.NestedListFieldFunction;
import com.liferay.apio.architect.internal.alias.BaseRepresentorFunction;
import com.liferay.apio.architect.internal.alias.PathFunction;
import com.liferay.apio.architect.internal.alias.RepresentorFunction;
import com.liferay.apio.architect.internal.alias.ResourceNameFunction;
import com.liferay.apio.architect.internal.alias.SingleModelFunction;
import com.liferay.apio.architect.internal.list.FunctionalList;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.message.json.SingleModelMessageMapper;
import com.liferay.apio.architect.internal.request.RequestInfo;
import com.liferay.apio.architect.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.internal.url.URLCreator;
import com.liferay.apio.architect.internal.writer.FieldsWriter;
import com.liferay.apio.architect.internal.writer.OperationWriter;
import com.liferay.apio.architect.internal.writer.util.WriterUtil;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.representor.BaseRepresentor;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.uri.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class SingleModelWriter<T> {
    private final JSONObjectBuilder _jsonObjectBuilder;
    private final PathFunction _pathFunction;
    private final RepresentorFunction _representorFunction;
    private final RequestInfo _requestInfo;
    private final ResourceNameFunction _resourceNameFunction;
    private final SingleModel<T> _singleModel;
    private final SingleModelFunction _singleModelFunction;
    private final SingleModelMessageMapper<T> _singleModelMessageMapper;

    public static <T> SingleModelWriter<T> create(Function<Builder<T>, SingleModelWriter<T>> function) {
        return function.apply(new Builder());
    }

    public SingleModelWriter(Builder<T> builder) {
        this._pathFunction = ((Builder)builder)._pathFunction;
        this._representorFunction = ((Builder)builder)._representorFunction;
        this._requestInfo = ((Builder)builder)._requestInfo;
        this._resourceNameFunction = ((Builder)builder)._resourceNameFunction;
        this._singleModel = ((Builder)builder)._singleModel;
        this._singleModelMessageMapper = ((Builder)builder)._singleModelMessageMapper;
        this._singleModelFunction = ((Builder)builder)._singleModelFunction;
        this._jsonObjectBuilder = new JSONObjectBuilder();
    }

    public Optional<String> write() {
        Optional<Path> pathOptional = WriterUtil.getPathOptional(this._singleModel, this._pathFunction, this._representorFunction::apply);
        if (!pathOptional.isPresent()) {
            return Optional.empty();
        }
        Optional<FieldsWriter<T>> fieldsWriterOptional = WriterUtil.getFieldsWriter(this._singleModel, null, this._requestInfo, this._representorFunction::apply, this._singleModelFunction, pathOptional.get(), this._pathFunction);
        if (!fieldsWriterOptional.isPresent()) {
            return Optional.empty();
        }
        FieldsWriter<T> fieldsWriter = fieldsWriterOptional.get();
        this._writeBasicFields(fieldsWriter, this._jsonObjectBuilder);
        fieldsWriter.writeSingleURL(url -> this._singleModelMessageMapper.mapSelfURL(this._jsonObjectBuilder, (String)url));
        List operations = this._singleModel.getOperations();
        OperationWriter operationWriter = new OperationWriter(this._singleModelMessageMapper, this._requestInfo, this._jsonObjectBuilder);
        operations.forEach(operationWriter::write);
        fieldsWriter.writeRelatedModels(this._pathFunction, (singleModel, embeddedPathElements) -> this.writeEmbeddedModelFields((SingleModel)singleModel, this._jsonObjectBuilder, (FunctionalList<String>)embeddedPathElements), (resourceURL, embeddedPathElements) -> this._singleModelMessageMapper.mapLinkedResourceURL(this._jsonObjectBuilder, (FunctionalList<String>)embeddedPathElements, (String)resourceURL), (resourceURL, embeddedPathElements) -> this._singleModelMessageMapper.mapEmbeddedResourceURL(this._jsonObjectBuilder, (FunctionalList<String>)embeddedPathElements, (String)resourceURL));
        fieldsWriter.writeRelatedCollections(this._resourceNameFunction, (url, embeddedPathElements) -> this._singleModelMessageMapper.mapLinkedResourceURL(this._jsonObjectBuilder, (FunctionalList<String>)embeddedPathElements, (String)url));
        fieldsWriter.writeNestedResources(this._representorFunction::apply, this._singleModel, null, (nestedSingleModel, nestedPathElements, nestedRepresentorFunction) -> this.writeEmbeddedModelFields((SingleModel)nestedSingleModel, this._jsonObjectBuilder, (FunctionalList<String>)nestedPathElements, (BaseRepresentorFunction)nestedRepresentorFunction));
        fieldsWriter.writeNestedLists(this._representorFunction::apply, this._singleModel, (nestedListFieldFunction, list) -> this._writeNestedList((NestedListFieldFunction)nestedListFieldFunction, (List)list, this._jsonObjectBuilder, null));
        this._singleModelMessageMapper.onFinish(this._jsonObjectBuilder, this._singleModel);
        return Optional.of(this._jsonObjectBuilder.build());
    }

    public <S> void writeEmbeddedModelFields(SingleModel<S> singleModel, JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements) {
        this.writeEmbeddedModelFields(singleModel, jsonObjectBuilder, embeddedPathElements, this._representorFunction::apply);
    }

    public <S> void writeEmbeddedModelFields(SingleModel<S> singleModel, JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, BaseRepresentorFunction baseRepresentorFunction) {
        Optional<Path> pathOptional = WriterUtil.getPathOptional(singleModel, this._pathFunction, baseRepresentorFunction, this._representorFunction, this._singleModel);
        if (!pathOptional.isPresent()) {
            return;
        }
        Optional<FieldsWriter<S>> fieldsWriterOptional = WriterUtil.getFieldsWriter(singleModel, embeddedPathElements, this._requestInfo, baseRepresentorFunction, this._singleModelFunction, pathOptional.get(), this._pathFunction);
        if (!fieldsWriterOptional.isPresent()) {
            return;
        }
        FieldsWriter<S> fieldsWriter = fieldsWriterOptional.get();
        this._writeEmbeddedBasicFields(fieldsWriter, jsonObjectBuilder, embeddedPathElements);
        List operations = singleModel.getOperations();
        operations.forEach(operation -> {
            JSONObjectBuilder operationJSONObjectBuilder = new JSONObjectBuilder();
            Optional formOptional = operation.getFormOptional();
            formOptional.ifPresent(form -> {
                String url = URLCreator.createFormURL(this._requestInfo.getApplicationURL(), form);
                this._singleModelMessageMapper.mapEmbeddedOperationFormURL(jsonObjectBuilder, operationJSONObjectBuilder, embeddedPathElements, url);
            });
            this._singleModelMessageMapper.mapEmbeddedOperationMethod(jsonObjectBuilder, operationJSONObjectBuilder, embeddedPathElements, operation.getHttpMethod());
            this._singleModelMessageMapper.onFinishEmbeddedOperation(jsonObjectBuilder, operationJSONObjectBuilder, embeddedPathElements, (Operation)operation);
        });
        fieldsWriter.writeRelatedModels(this._pathFunction, (singleModel1, stringFunctionalList) -> this.writeEmbeddedModelFields((SingleModel)singleModel1, jsonObjectBuilder, (FunctionalList<String>)stringFunctionalList), (resourceURL, resourceEmbeddedPathElements) -> this._singleModelMessageMapper.mapLinkedResourceURL(jsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)resourceURL), (resourceURL, resourceEmbeddedPathElements) -> this._singleModelMessageMapper.mapEmbeddedResourceURL(jsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)resourceURL));
        fieldsWriter.writeRelatedCollections(this._resourceNameFunction, (url, resourceEmbeddedPathElements) -> this._singleModelMessageMapper.mapLinkedResourceURL(jsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)url));
        fieldsWriter.writeNestedResources(baseRepresentorFunction, singleModel, embeddedPathElements, (nestedSingleModel, nestedPathElements, nestedRepresentorFunction) -> this.writeEmbeddedModelFields((SingleModel)nestedSingleModel, jsonObjectBuilder, (FunctionalList<String>)nestedPathElements, (BaseRepresentorFunction)nestedRepresentorFunction));
        fieldsWriter.writeNestedLists(baseRepresentorFunction, singleModel, (nestedListFieldFunction, list) -> this._writeNestedList((NestedListFieldFunction)nestedListFieldFunction, (List)list, this._jsonObjectBuilder, embeddedPathElements));
    }

    private Consumer<BaseRepresentor> _mapPageSemantics(JSONObjectBuilder jsonObjectBuilder) {
        return baseRepresentor -> {
            String type = baseRepresentor.getPrimaryType();
            this._singleModelMessageMapper.mapNestedPageSemantics(jsonObjectBuilder, type);
        };
    }

    private void _writeBasicFields(FieldsWriter<?> fieldsWriter, JSONObjectBuilder jsonObjectBuilder) {
        fieldsWriter.writeApplicationRelativeURLFields((field, value) -> this._singleModelMessageMapper.mapStringField(jsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeBooleanFields((field, value) -> this._singleModelMessageMapper.mapBooleanField(jsonObjectBuilder, (String)field, (Boolean)value));
        fieldsWriter.writeBooleanListFields((field, value) -> this._singleModelMessageMapper.mapBooleanListField(jsonObjectBuilder, (String)field, (List<Boolean>)value));
        fieldsWriter.writeLocalizedStringFields((field, value) -> this._singleModelMessageMapper.mapStringField(jsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeNumberFields((field, value) -> this._singleModelMessageMapper.mapNumberField(jsonObjectBuilder, (String)field, (Number)value));
        fieldsWriter.writeNumberListFields((field, value) -> this._singleModelMessageMapper.mapNumberListField(jsonObjectBuilder, (String)field, (List<Number>)value));
        fieldsWriter.writeRelativeURLFields((field, value) -> this._singleModelMessageMapper.mapStringField(jsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeStringFields((field, value) -> this._singleModelMessageMapper.mapStringField(jsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeStringListFields((field, value) -> this._singleModelMessageMapper.mapStringListField(jsonObjectBuilder, (String)field, (List<String>)value));
        fieldsWriter.writeLinks((fieldName, link) -> this._singleModelMessageMapper.mapLink(jsonObjectBuilder, (String)fieldName, (String)link));
        fieldsWriter.writeTypes(types -> this._singleModelMessageMapper.mapTypes(jsonObjectBuilder, (List<String>)types));
        fieldsWriter.writeBinaries((field, value) -> this._singleModelMessageMapper.mapLink(jsonObjectBuilder, (String)field, (String)value));
    }

    private void _writeEmbeddedBasicFields(FieldsWriter<?> fieldsWriter, JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements) {
        fieldsWriter.writeApplicationRelativeURLFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceStringField(jsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeBooleanFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceBooleanField(jsonObjectBuilder, embeddedPathElements, (String)field, (Boolean)value));
        fieldsWriter.writeBooleanListFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceBooleanListField(jsonObjectBuilder, embeddedPathElements, (String)field, (List<Boolean>)value));
        fieldsWriter.writeLocalizedStringFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceStringField(jsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeNumberFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceNumberField(jsonObjectBuilder, embeddedPathElements, (String)field, (Number)value));
        fieldsWriter.writeNumberListFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceNumberListField(jsonObjectBuilder, embeddedPathElements, (String)field, (List<Number>)value));
        fieldsWriter.writeRelativeURLFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceStringField(this._jsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeStringFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceStringField(jsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeStringListFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceStringListField(jsonObjectBuilder, embeddedPathElements, (String)field, (List<String>)value));
        fieldsWriter.writeLinks((fieldName, link) -> this._singleModelMessageMapper.mapEmbeddedResourceLink(jsonObjectBuilder, embeddedPathElements, (String)fieldName, (String)link));
        fieldsWriter.writeTypes(types -> this._singleModelMessageMapper.mapEmbeddedResourceTypes(jsonObjectBuilder, embeddedPathElements, (List<String>)types));
        fieldsWriter.writeBinaries((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceLink(jsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
    }

    private <U> void _writeItem(JSONObjectBuilder collectionJSONObjectBuilder, SingleModel<U> singleModel, FunctionalList<String> embeddedPathElements, BaseRepresentorFunction baseRepresentorFunction) {
        Optional<Path> pathOptional = WriterUtil.getPathOptional(singleModel, this._pathFunction, baseRepresentorFunction, this._representorFunction, this._singleModel);
        if (!pathOptional.isPresent()) {
            return;
        }
        Optional<FieldsWriter<U>> fieldsWriterOptional = WriterUtil.getFieldsWriter(singleModel, embeddedPathElements, this._requestInfo, baseRepresentorFunction, this._singleModelFunction, pathOptional.get(), this._pathFunction);
        if (!fieldsWriterOptional.isPresent()) {
            return;
        }
        FieldsWriter<U> fieldsWriter = fieldsWriterOptional.get();
        JSONObjectBuilder itemJsonObjectBuilder = new JSONObjectBuilder();
        this._writeBasicFields(fieldsWriter, itemJsonObjectBuilder);
        Optional<FieldsWriter<U>> relatedModelsFieldsWriterOptional = WriterUtil.getFieldsWriter(singleModel, null, this._requestInfo, baseRepresentorFunction, this._singleModelFunction, pathOptional.get(), this._pathFunction);
        relatedModelsFieldsWriterOptional.ifPresent(relatedModelFieldsWriter -> relatedModelFieldsWriter.writeRelatedModels(this._pathFunction, (embeddedSingleModel, embeddedPathElements1) -> this._writeItemEmbeddedModelFields((SingleModel)embeddedSingleModel, (FunctionalList<String>)embeddedPathElements1, itemJsonObjectBuilder, baseRepresentorFunction), (resourceURL, embeddedPathElements1) -> this._singleModelMessageMapper.mapLinkedResourceURL(itemJsonObjectBuilder, (FunctionalList<String>)embeddedPathElements1, (String)resourceURL), (resourceURL, embeddedPathElements1) -> this._singleModelMessageMapper.mapEmbeddedResourceURL(itemJsonObjectBuilder, (FunctionalList<String>)embeddedPathElements1, (String)resourceURL)));
        fieldsWriter.writeRelatedCollections(this._resourceNameFunction, (url, embeddedPathElements1) -> this._singleModelMessageMapper.mapLinkedResourceURL(itemJsonObjectBuilder, (FunctionalList<String>)embeddedPathElements1, (String)url));
        this._writePageNestedResources(baseRepresentorFunction, singleModel, itemJsonObjectBuilder);
        fieldsWriter.writeNestedLists(baseRepresentorFunction, singleModel, (nestedListFieldFunction, list) -> this._writeNestedList((NestedListFieldFunction)nestedListFieldFunction, (List)list, itemJsonObjectBuilder, null));
        this._singleModelMessageMapper.onFinishNestedCollectionItem(collectionJSONObjectBuilder, itemJsonObjectBuilder, singleModel);
    }

    private <S> void _writeItemEmbeddedModelFields(SingleModel<S> singleModel, FunctionalList<String> embeddedPathElements, JSONObjectBuilder itemJsonObjectBuilder, BaseRepresentorFunction baseRepresentorFunction) {
        Optional<Path> pathOptional = WriterUtil.getPathOptional(singleModel, this._pathFunction, baseRepresentorFunction, this._representorFunction, this._singleModel);
        if (!pathOptional.isPresent()) {
            return;
        }
        Optional<FieldsWriter<S>> fieldsWriterOptional = WriterUtil.getFieldsWriter(singleModel, embeddedPathElements, this._requestInfo, baseRepresentorFunction, this._singleModelFunction, pathOptional.get(), this._pathFunction);
        if (!fieldsWriterOptional.isPresent()) {
            return;
        }
        FieldsWriter<S> fieldsWriter = fieldsWriterOptional.get();
        this._writeEmbeddedBasicFields(fieldsWriter, itemJsonObjectBuilder, embeddedPathElements);
        fieldsWriter.writeRelatedModels(this._pathFunction, (embeddedSingleModel, embeddedModelEmbeddedPathElements) -> this._writeItemEmbeddedModelFields((SingleModel)embeddedSingleModel, (FunctionalList<String>)embeddedModelEmbeddedPathElements, itemJsonObjectBuilder, baseRepresentorFunction), (resourceURL, resourceEmbeddedPathElements) -> this._singleModelMessageMapper.mapLinkedResourceURL(itemJsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)resourceURL), (resourceURL, resourceEmbeddedPathElements) -> this._singleModelMessageMapper.mapEmbeddedResourceURL(itemJsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)resourceURL));
        fieldsWriter.writeRelatedCollections(this._resourceNameFunction, (url, embeddedPathElements1) -> this._singleModelMessageMapper.mapLinkedResourceURL(itemJsonObjectBuilder, (FunctionalList<String>)embeddedPathElements1, (String)url));
        fieldsWriter.writeNestedResources(baseRepresentorFunction, singleModel, embeddedPathElements, (nestedSingleModel, nestedPathElements, nestedRepresentorFunction) -> this.writeEmbeddedModelFields((SingleModel)nestedSingleModel, itemJsonObjectBuilder, (FunctionalList<String>)nestedPathElements, (BaseRepresentorFunction)nestedRepresentorFunction));
        fieldsWriter.writeNestedLists(baseRepresentorFunction, singleModel, (nestedListFieldFunction, list) -> this._writeNestedList((NestedListFieldFunction)nestedListFieldFunction, (List)list, itemJsonObjectBuilder, embeddedPathElements));
    }

    private <U> void _writeNestedList(NestedListFieldFunction nestedListFieldFunction, List<U> list, JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedNestedPathElements) {
        String key = nestedListFieldFunction.getKey();
        FunctionalList<String> embeddedPathElements = new FunctionalList<String>(embeddedNestedPathElements, key);
        BaseRepresentorFunction baseRepresentorFunction = __ -> Optional.of(nestedListFieldFunction.getNestedRepresentor());
        JSONObjectBuilder pageJSONObjectBuilder = new JSONObjectBuilder();
        this._singleModelMessageMapper.mapNestedPageItemTotalCount(pageJSONObjectBuilder, list.size());
        ((Optional)baseRepresentorFunction.apply("")).ifPresent(this._mapPageSemantics(pageJSONObjectBuilder));
        list.forEach(model -> this._writeItem(pageJSONObjectBuilder, new SingleModelImpl<Object>(model, "", Collections.emptyList()), embeddedPathElements, baseRepresentorFunction));
        this._singleModelMessageMapper.onFinishNestedCollection(jsonObjectBuilder, pageJSONObjectBuilder, key, list, embeddedPathElements);
    }

    private <U> void _writePageNestedResources(BaseRepresentorFunction baseRepresentorFunction, SingleModel<U> singleModel, JSONObjectBuilder itemJsonObjectBuilder) {
        ((Optional)baseRepresentorFunction.apply(singleModel.getResourceName())).map(Unsafe::unsafeCast).map(BaseRepresentor::getNestedFieldFunctions).map(Collection::stream).orElseGet(Stream::empty).forEach(nestedFieldFunction -> {
            Object mappedModel = nestedFieldFunction.apply(singleModel.getModel());
            if (mappedModel == null) {
                return;
            }
            FunctionalList<String> embeddedNestedPathElements = new FunctionalList<String>(null, nestedFieldFunction.getKey());
            this._writeItemEmbeddedModelFields(new SingleModelImpl<Object>(mappedModel, "", Collections.emptyList()), embeddedNestedPathElements, itemJsonObjectBuilder, __ -> Optional.of(nestedFieldFunction.getNestedRepresentor()));
        });
    }

    public static class Builder<T> {
        private PathFunction _pathFunction;
        private RepresentorFunction _representorFunction;
        private RequestInfo _requestInfo;
        private ResourceNameFunction _resourceNameFunction;
        private SingleModel<T> _singleModel;
        private SingleModelFunction _singleModelFunction;
        private SingleModelMessageMapper<T> _singleModelMessageMapper;

        public SingleModelMessageMapperStep singleModel(SingleModel<T> singleModel) {
            this._singleModel = singleModel;
            return new SingleModelMessageMapperStep();
        }

        public class SingleModelMessageMapperStep {
            public PathFunctionStep modelMessageMapper(SingleModelMessageMapper<T> singleModelMessageMapper) {
                Builder.this._singleModelMessageMapper = singleModelMessageMapper;
                return new PathFunctionStep();
            }
        }

        public class SingleModelFunctionStep {
            public BuildStep singleModelFunction(SingleModelFunction singleModelFunction) {
                Builder.this._singleModelFunction = singleModelFunction;
                return new BuildStep();
            }
        }

        public class ResourceNameFunctionStep {
            public RepresentorFunctionStep resourceNameFunction(ResourceNameFunction resourceNameFunction) {
                Builder.this._resourceNameFunction = resourceNameFunction;
                return new RepresentorFunctionStep();
            }
        }

        public class RequestInfoStep {
            public SingleModelFunctionStep requestInfo(RequestInfo requestInfo) {
                Builder.this._requestInfo = requestInfo;
                return new SingleModelFunctionStep();
            }
        }

        public class RepresentorFunctionStep {
            public RequestInfoStep representorFunction(RepresentorFunction representorFunction) {
                Builder.this._representorFunction = representorFunction;
                return new RequestInfoStep();
            }
        }

        public class PathFunctionStep {
            public ResourceNameFunctionStep pathFunction(PathFunction pathFunction) {
                Builder.this._pathFunction = pathFunction;
                return new ResourceNameFunctionStep();
            }
        }

        public class BuildStep {
            public SingleModelWriter<T> build() {
                return new SingleModelWriter(Builder.this);
            }
        }
    }
}

