/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.writer;

import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.message.json.OperationMapper;
import com.liferay.apio.architect.internal.request.RequestInfo;
import com.liferay.apio.architect.internal.url.URLCreator;
import com.liferay.apio.architect.operation.Operation;
import java.util.Optional;

public class OperationWriter {
    private final JSONObjectBuilder _jsonObjectBuilder;
    private final OperationMapper _operationMapper;
    private final RequestInfo _requestInfo;

    public OperationWriter(OperationMapper operationMapper, RequestInfo requestInfo, JSONObjectBuilder jsonObjectBuilder) {
        this._operationMapper = operationMapper;
        this._requestInfo = requestInfo;
        this._jsonObjectBuilder = jsonObjectBuilder;
    }

    public void write(Operation operation) {
        JSONObjectBuilder operationJSONObjectBuilder = new JSONObjectBuilder();
        Optional<String> urlOptional = URLCreator.createOperationURL(this._requestInfo.getApplicationURL(), operation);
        urlOptional.ifPresent(url -> this._operationMapper.mapOperationURL(operationJSONObjectBuilder, (String)url));
        Optional formOptional = operation.getFormOptional();
        formOptional.map(form -> URLCreator.createFormURL(this._requestInfo.getApplicationURL(), form)).ifPresent(url -> this._operationMapper.mapFormURL(operationJSONObjectBuilder, (String)url));
        this._operationMapper.mapHTTPMethod(operationJSONObjectBuilder, operation.getHttpMethod());
        this._operationMapper.onFinish(this._jsonObjectBuilder, operationJSONObjectBuilder, operation);
    }
}

