/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.writer;

import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.form.FormField;
import com.liferay.apio.architect.internal.message.json.FormMessageMapper;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.request.RequestInfo;
import com.liferay.apio.architect.internal.url.URLCreator;
import java.util.List;
import java.util.function.Function;

public class FormWriter {
    private final Form<?> _form;
    private final FormMessageMapper _formMessageMapper;
    private final RequestInfo _requestInfo;

    public static FormWriter create(Function<Builder, FormWriter> function) {
        return function.apply(new Builder());
    }

    public FormWriter(Builder builder) {
        this._form = builder._form;
        this._formMessageMapper = builder._formMessageMapper;
        this._requestInfo = builder._requestInfo;
    }

    public String write() {
        JSONObjectBuilder jsonObjectBuilder = this._writeForm();
        return jsonObjectBuilder.build();
    }

    private FormWriter _getFormWriter(Form form) {
        return FormWriter.create(builder -> builder.form(form).formMessageMapper(this._formMessageMapper).requestInfo(this._requestInfo).build());
    }

    private void _mapNestedForm(JSONObjectBuilder jsonObjectBuilder, FormField formField, Form form) {
        FormWriter formWriter = this._getFormWriter(form);
        JSONObjectBuilder nestedJsonObjectBuilder = formWriter._writeForm();
        this._formMessageMapper.mapFormField(jsonObjectBuilder, formField, nestedJsonObjectBuilder);
    }

    private JSONObjectBuilder _writeForm() {
        JSONObjectBuilder jsonObjectBuilder = new JSONObjectBuilder();
        String url = URLCreator.createFormURL(this._requestInfo.getApplicationURL(), this._form);
        this._formMessageMapper.mapFormURL(jsonObjectBuilder, url);
        String title = this._form.getTitle(this._requestInfo.getAcceptLanguage());
        this._formMessageMapper.mapFormTitle(jsonObjectBuilder, title);
        String description = this._form.getDescription(this._requestInfo.getAcceptLanguage());
        this._formMessageMapper.mapFormDescription(jsonObjectBuilder, description);
        List formFields = this._form.getFormFields();
        formFields.forEach(formField -> {
            Form form = formField.getForm();
            if (form == null) {
                this._formMessageMapper.mapFormField(jsonObjectBuilder, (FormField)formField);
            } else {
                this._mapNestedForm(jsonObjectBuilder, (FormField)formField, form);
            }
        });
        this._formMessageMapper.onFinish(jsonObjectBuilder, this._form);
        return jsonObjectBuilder;
    }

    public static class Builder {
        private Form _form;
        private FormMessageMapper _formMessageMapper;
        private RequestInfo _requestInfo;

        public FormMessageMapperStep form(Form form) {
            this._form = form;
            return new FormMessageMapperStep();
        }

        public class RequestInfoStep {
            public BuildStep requestInfo(RequestInfo requestInfo) {
                Builder.this._requestInfo = requestInfo;
                return new BuildStep();
            }
        }

        public class FormMessageMapperStep {
            public RequestInfoStep formMessageMapper(FormMessageMapper formMessageMapper) {
                Builder.this._formMessageMapper = formMessageMapper;
                return new RequestInfoStep();
            }
        }

        public class BuildStep {
            public FormWriter build() {
                return new FormWriter(Builder.this);
            }
        }
    }
}

