/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.writer;

import com.liferay.apio.architect.consumer.TriConsumer;
import com.liferay.apio.architect.documentation.contributor.CustomDocumentation;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.internal.documentation.Documentation;
import com.liferay.apio.architect.internal.message.json.DocumentationMessageMapper;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.operation.CreateOperation;
import com.liferay.apio.architect.internal.operation.DeleteOperation;
import com.liferay.apio.architect.internal.operation.RetrieveOperation;
import com.liferay.apio.architect.internal.operation.UpdateOperation;
import com.liferay.apio.architect.internal.request.RequestInfo;
import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.related.RelatedCollection;
import com.liferay.apio.architect.related.RelatedModel;
import com.liferay.apio.architect.representor.BaseRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class DocumentationWriter {
    private final CustomDocumentation _customDocumentation;
    private final Documentation _documentation;
    private final DocumentationMessageMapper _documentationMessageMapper;
    private final RequestInfo _requestInfo;

    public static DocumentationWriter create(Function<Builder, DocumentationWriter> function) {
        return function.apply(new Builder());
    }

    public DocumentationWriter(Builder builder) {
        this._documentation = builder._documentation;
        this._documentationMessageMapper = builder._documentationMessageMapper;
        this._requestInfo = builder._requestInfo;
        this._customDocumentation = this._documentation.getCustomDocumentation();
    }

    public String write() {
        JSONObjectBuilder jsonObjectBuilder = new JSONObjectBuilder();
        this._writeDocumentationMetadata(jsonObjectBuilder);
        Map<String, Representor> representors = this._documentation.getRepresentors();
        Map<String, ItemRoutes> itemRoutesMap = this._documentation.getItemRoutes();
        itemRoutesMap.forEach((name, itemRoutes) -> this._writeRoute(jsonObjectBuilder, (String)name, (Representor)representors.get(name), (TriConsumer<JSONObjectBuilder, String, String>)((TriConsumer)this._documentationMessageMapper::mapResource), (TriConsumer<String, String, JSONObjectBuilder>)((TriConsumer)this::_writeItemOperations), resourceJsonObjectBuilder -> this._writeAllFields((Representor)representors.get(name), (JSONObjectBuilder)resourceJsonObjectBuilder)));
        Map<String, NestedCollectionRoutes> nestedCollectionRoutesMap = this._documentation.getNestedCollectionRoutes();
        Map<String, CollectionRoutes> collectionRoutes = this._documentation.getCollectionRoutes();
        HashSet<String> collectionResources = new HashSet<String>(collectionRoutes.keySet());
        HashSet<String> nestedRoutes = new HashSet<String>(itemRoutesMap.keySet());
        nestedRoutes.addAll(collectionRoutes.keySet());
        nestedRoutes.forEach(name -> {
            Optional<String> nestedCollectionRoute = this._getNestedCollectionRouteOptional(representors, nestedCollectionRoutesMap, (String)name);
            nestedCollectionRoute.ifPresent(collectionResources::add);
        });
        collectionResources.forEach(name -> this._writeRoute(jsonObjectBuilder, (String)name, (Representor)representors.get(name), (TriConsumer<JSONObjectBuilder, String, String>)((TriConsumer)this._documentationMessageMapper::mapResourceCollection), (TriConsumer<String, String, JSONObjectBuilder>)((TriConsumer)this::_writePageOperations), __ -> {}));
        this._documentationMessageMapper.onFinish(jsonObjectBuilder, this._documentation);
        return jsonObjectBuilder.build();
    }

    private Stream<String> _calculateNestableFieldNames(BaseRepresentor representor) {
        ArrayList fieldFunctions = new ArrayList();
        fieldFunctions.addAll(representor.getApplicationRelativeURLFunctions());
        fieldFunctions.addAll(representor.getBinaryFunctions());
        fieldFunctions.addAll(representor.getBooleanFunctions());
        fieldFunctions.addAll(representor.getBooleanListFunctions());
        fieldFunctions.addAll(representor.getLinkFunctions());
        fieldFunctions.addAll(representor.getLocalizedStringFunctions());
        fieldFunctions.addAll(representor.getNestedFieldFunctions());
        fieldFunctions.addAll(representor.getNumberFunctions());
        fieldFunctions.addAll(representor.getNumberListFunctions());
        fieldFunctions.addAll(representor.getRelativeURLFunctions());
        fieldFunctions.addAll(representor.getStringFunctions());
        fieldFunctions.addAll(representor.getStringListFunctions());
        Stream fieldFunctionStream = fieldFunctions.stream();
        Stream<String> fieldNamesStream = fieldFunctionStream.map(fieldFunction -> fieldFunction.getKey());
        List relatedModels = representor.getRelatedModels();
        Stream relatedModelStream = relatedModels.stream();
        Stream<String> relatedModelNamesStream = relatedModelStream.map(RelatedModel::getKey);
        fieldNamesStream = Stream.concat(fieldNamesStream, relatedModelNamesStream);
        List nestedFieldFunctions = representor.getNestedFieldFunctions();
        Stream nestedFieldFunctionStream = nestedFieldFunctions.stream();
        Stream nestedFieldNamesStream = nestedFieldFunctionStream.map(nestedFieldFunction -> this._calculateNestableFieldNames((BaseRepresentor)nestedFieldFunction.getNestedRepresentor())).reduce(Stream::concat).orElseGet(Stream::empty);
        return Stream.concat(fieldNamesStream, nestedFieldNamesStream);
    }

    private String _getCustomDocumentation(String name) {
        return Optional.ofNullable(this._customDocumentation.getDescriptionFunction(name)).map(localeFunction -> {
            AcceptLanguage acceptLanguage = this._requestInfo.getAcceptLanguage();
            return (String)localeFunction.apply(acceptLanguage.getPreferredLocale());
        }).orElse(null);
    }

    private Optional<String> _getNestedCollectionRouteOptional(Map<String, Representor> representorMap, Map<String, ?> nestedRoutesMap, String name) {
        Set<String> nestedRoutes = nestedRoutesMap.keySet();
        Stream nestedRoutesStream = nestedRoutes.stream();
        return nestedRoutesStream.map(nestedRoute -> nestedRoute.split(name + "-")).filter(routes -> ((String[])routes).length == 2 && !routes[0].equals("") && !routes[0].equals(routes[1]) && representorMap.containsKey(routes[1])).map(routes -> routes[1]).findFirst();
    }

    private void _writeAllFields(Representor representor, JSONObjectBuilder resourceJsonObjectBuilder) {
        Stream<String> fieldNamesStream = this._calculateNestableFieldNames((BaseRepresentor)representor);
        Stream relatedCollections = representor.getRelatedCollections();
        Stream<String> relatedCollectionsNamesStream = relatedCollections.map(RelatedCollection::getKey);
        fieldNamesStream = Stream.concat(fieldNamesStream, relatedCollectionsNamesStream);
        this._writeFields(fieldNamesStream, resourceJsonObjectBuilder);
    }

    private void _writeDocumentationMetadata(JSONObjectBuilder jsonObjectBuilder) {
        Optional<String> apiTitleOptional = this._documentation.getAPITitleOptional();
        apiTitleOptional.ifPresent(title -> this._documentationMessageMapper.mapTitle(jsonObjectBuilder, (String)title));
        Optional<String> apiDescriptionOptional = this._documentation.getAPIDescriptionOptional();
        apiDescriptionOptional.ifPresent(description -> this._documentationMessageMapper.mapDescription(jsonObjectBuilder, (String)description));
        Optional<String> entryPointOptional = this._documentation.getEntryPointOptional();
        entryPointOptional.ifPresent(entryPoint -> this._documentationMessageMapper.mapEntryPoint(jsonObjectBuilder, (String)entryPoint));
    }

    private void _writeFields(Stream<String> fields, JSONObjectBuilder resourceJsonObjectBuilder) {
        Stream<String> stream = fields.distinct();
        stream.forEach(field -> this._writeFormField(resourceJsonObjectBuilder, (String)field));
    }

    private void _writeFormField(JSONObjectBuilder resourceJsonObjectBuilder, String fieldName) {
        JSONObjectBuilder jsonObjectBuilder = new JSONObjectBuilder();
        String customDocumentation = this._getCustomDocumentation(fieldName);
        this._documentationMessageMapper.mapProperty(jsonObjectBuilder, fieldName, customDocumentation);
        this._documentationMessageMapper.onFinishProperty(resourceJsonObjectBuilder, jsonObjectBuilder, fieldName);
    }

    private void _writeItemOperations(String name, String type, JSONObjectBuilder resourceJsonObjectBuilder) {
        Map<String, ItemRoutes> itemRoutesMap = this._documentation.getItemRoutes();
        Optional.ofNullable(itemRoutesMap.getOrDefault(name, null)).ifPresent(itemRoutes -> {
            RetrieveOperation retrieveOperation = new RetrieveOperation(name, false);
            this._writeOperation(retrieveOperation, resourceJsonObjectBuilder, name, type);
            Optional optional = itemRoutes.getFormOptional();
            UpdateOperation updateOperation = optional.map(form -> new UpdateOperation((Form)form, name)).orElse(new UpdateOperation(null, name));
            this._writeOperation(updateOperation, resourceJsonObjectBuilder, name, type);
            DeleteOperation deleteOperation = new DeleteOperation(name);
            this._writeOperation(deleteOperation, resourceJsonObjectBuilder, name, type);
        });
    }

    private void _writeOperation(Operation operation, JSONObjectBuilder jsonObjectBuilder, String resourceName, String type) {
        JSONObjectBuilder operationJsonObjectBuilder = new JSONObjectBuilder();
        String customDocumentation = this._getCustomDocumentation(operation.getName());
        this._documentationMessageMapper.mapOperation(operationJsonObjectBuilder, resourceName, type, operation, customDocumentation);
        this._documentationMessageMapper.onFinishOperation(jsonObjectBuilder, operationJsonObjectBuilder, operation);
    }

    private void _writePageOperations(String resource, String type, JSONObjectBuilder resourceJsonObjectBuilder) {
        Map<String, CollectionRoutes> collectionRoutesMap = this._documentation.getCollectionRoutes();
        Optional.ofNullable(collectionRoutesMap.getOrDefault(resource, null)).ifPresent(collectionRoutes -> {
            this._writeOperation(new RetrieveOperation(resource, true), resourceJsonObjectBuilder, resource, type);
            Optional optional = collectionRoutes.getFormOptional();
            CreateOperation createOperation = optional.map(form -> new CreateOperation((Form)form, resource)).orElse(new CreateOperation(null, resource));
            this._writeOperation(createOperation, resourceJsonObjectBuilder, resource, type);
        });
    }

    private void _writeRoute(JSONObjectBuilder jsonObjectBuilder, String name, Representor representor, TriConsumer<JSONObjectBuilder, String, String> writeResourceBiConsumer, TriConsumer<String, String, JSONObjectBuilder> writeOperationsTriConsumer, Consumer<JSONObjectBuilder> writeFieldsRepresentor) {
        List types = representor.getTypes();
        types.forEach(type -> {
            JSONObjectBuilder resourceJsonObjectBuilder = new JSONObjectBuilder();
            String customDocumentation = this._getCustomDocumentation((String)type);
            writeResourceBiConsumer.accept((Object)resourceJsonObjectBuilder, type, (Object)customDocumentation);
            writeOperationsTriConsumer.accept((Object)name, type, (Object)resourceJsonObjectBuilder);
            writeFieldsRepresentor.accept(resourceJsonObjectBuilder);
            this._documentationMessageMapper.onFinishResource(jsonObjectBuilder, resourceJsonObjectBuilder, (String)type);
        });
    }

    public static class Builder {
        private Documentation _documentation;
        private DocumentationMessageMapper _documentationMessageMapper;
        private RequestInfo _requestInfo;

        public DocumentationMessageMapperStep documentation(Documentation documentation) {
            this._documentation = documentation;
            return new DocumentationMessageMapperStep();
        }

        public class RequestInfoStep {
            public BuildStep requestInfo(RequestInfo requestInfo) {
                Builder.this._requestInfo = requestInfo;
                return new BuildStep();
            }
        }

        public class DocumentationMessageMapperStep {
            public RequestInfoStep documentationMessageMapper(DocumentationMessageMapper documentationMessageMapper) {
                Builder.this._documentationMessageMapper = documentationMessageMapper;
                return new RequestInfoStep();
            }
        }

        public class BuildStep {
            public DocumentationWriter build() {
                return new DocumentationWriter(Builder.this);
            }
        }
    }
}

