/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.writer;

import com.liferay.apio.architect.batch.BatchResult;
import com.liferay.apio.architect.internal.alias.PathFunction;
import com.liferay.apio.architect.internal.message.json.BatchResultMessageMapper;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.request.RequestInfo;
import com.liferay.apio.architect.internal.url.ApplicationURL;
import com.liferay.apio.architect.internal.url.URLCreator;
import com.liferay.apio.architect.representor.Representor;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class BatchResultWriter<T> {
    private final BatchResult<T> _batchResult;
    private final BatchResultMessageMapper<T> _batchResultMessageMapper;
    private final JSONObjectBuilder _jsonObjectBuilder;
    private final PathFunction _pathFunction;
    private final Function<String, Optional<Representor<Object>>> _representorFunction;
    private final RequestInfo _requestInfo;

    public Optional<String> write() {
        Optional<Representor<Object>> optional = this._representorFunction.apply(this._batchResult.resourceName);
        if (!optional.isPresent()) {
            return Optional.empty();
        }
        Representor<Object> representor = optional.get();
        List identifiers = this._batchResult.getIdentifiers();
        this._batchResultMessageMapper.mapItemTotalCount(this._jsonObjectBuilder, identifiers.size());
        ApplicationURL applicationURL = this._requestInfo.getApplicationURL();
        List types = representor.getTypes();
        for (Object identifier : identifiers) {
            JSONObjectBuilder itemJsonObjectBuilder = new JSONObjectBuilder();
            ((Optional)this._pathFunction.apply(this._batchResult.resourceName, identifier)).ifPresent(path -> {
                this._batchResultMessageMapper.onStartItem(this._jsonObjectBuilder, itemJsonObjectBuilder);
                String url = URLCreator.createSingleURL(applicationURL, path);
                this._batchResultMessageMapper.mapItemSelfURL(this._jsonObjectBuilder, itemJsonObjectBuilder, url);
                this._batchResultMessageMapper.mapItemTypes(this._jsonObjectBuilder, itemJsonObjectBuilder, types);
                this._batchResultMessageMapper.onFinishItem(this._jsonObjectBuilder, itemJsonObjectBuilder);
            });
        }
        this._batchResultMessageMapper.onFinish(this._jsonObjectBuilder, this._batchResult);
        return Optional.of(this._jsonObjectBuilder.build());
    }

    private BatchResultWriter(BatchResult<T> batchResult, BatchResultMessageMapper<T> batchResultMessageMapper, PathFunction pathFunction, Function<String, Optional<Representor<Object>>> representorFunction, RequestInfo requestInfo) {
        this._batchResult = batchResult;
        this._batchResultMessageMapper = batchResultMessageMapper;
        this._pathFunction = pathFunction;
        this._representorFunction = representorFunction;
        this._requestInfo = requestInfo;
        this._jsonObjectBuilder = new JSONObjectBuilder();
    }

    public static interface Builder {
        public static <T> BatchResultMessageMapperStep<T> batchResult(BatchResult<T> batchResult) {
            return batchResultMessageMapper -> pathFunction -> representorFunction -> requestInfo -> () -> new BatchResultWriter(batchResult, batchResultMessageMapper, pathFunction, representorFunction, requestInfo);
        }

        public static interface RequestInfoStep<T> {
            public BuildStep<T> requestInfo(RequestInfo var1);
        }

        public static interface RepresentorFunctionStep<T> {
            public RequestInfoStep<T> representorFunction(Function<String, Optional<Representor<Object>>> var1);
        }

        public static interface PathFunctionStep<T> {
            public RepresentorFunctionStep<T> pathFunction(PathFunction var1);
        }

        public static interface BuildStep<T> {
            public BatchResultWriter<T> build();
        }

        public static interface BatchResultMessageMapperStep<T> {
            public PathFunctionStep<T> batchResultMessageMapper(BatchResultMessageMapper<T> var1);
        }
    }
}

