/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.url;

import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.internal.operation.BatchCreateOperation;
import com.liferay.apio.architect.internal.operation.CreateOperation;
import com.liferay.apio.architect.internal.operation.DeleteOperation;
import com.liferay.apio.architect.internal.operation.RetrieveOperation;
import com.liferay.apio.architect.internal.operation.UpdateOperation;
import com.liferay.apio.architect.internal.pagination.PageType;
import com.liferay.apio.architect.internal.url.ApplicationURL;
import com.liferay.apio.architect.internal.url.ServerURL;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.pagination.Page;
import com.liferay.apio.architect.uri.Path;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;

public final class URLCreator {
    public static String createAbsoluteURL(ApplicationURL applicationURL, String relativeURL) {
        return URLCreator._buildURL((String)applicationURL.get(), relativeURL);
    }

    public static String createAbsoluteURL(ServerURL serverURL, String relativeURL) {
        return URLCreator._buildURL((String)serverURL.get(), relativeURL);
    }

    public static String createBinaryURL(ApplicationURL applicationURL, String binaryId, Path path) {
        return URLCreator.createAbsoluteURL(applicationURL, String.join((CharSequence)"/", "b", path.asURI(), binaryId));
    }

    public static String createCollectionPageURL(String collectionURL, Page page, PageType pageType) {
        return UriBuilder.fromUri((String)collectionURL).queryParam("page", new Object[]{pageType.getPageNumber(page)}).queryParam("per_page", new Object[]{page.getItemsPerPage()}).build(new Object[0]).toString();
    }

    public static String createCollectionURL(ApplicationURL applicationURL, String name) {
        return URLCreator.createAbsoluteURL(applicationURL, "/p/" + name);
    }

    public static String createFormURL(ApplicationURL applicationURL, Form form) {
        return URLCreator.createAbsoluteURL(applicationURL, String.join((CharSequence)"/", "f", form.getId()));
    }

    public static String createNestedCollectionURL(ApplicationURL applicationURL, Path path, String name) {
        return URLCreator.createAbsoluteURL(applicationURL, URLCreator._getReusablePath(path, name));
    }

    public static Optional<String> createOperationURL(ApplicationURL applicationURL, Operation operation) {
        Optional optional = operation.getURIOptional();
        return optional.map(uri -> {
            if (operation instanceof BatchCreateOperation) {
                return "batch/" + uri;
            }
            if (operation.isCustom()) {
                return URLCreator._createCustomOperationURL(operation, uri);
            }
            if (operation instanceof CreateOperation) {
                return "p/" + uri;
            }
            if (operation instanceof DeleteOperation) {
                return "p/" + uri;
            }
            if (operation instanceof RetrieveOperation) {
                return "p/" + uri;
            }
            if (operation instanceof UpdateOperation) {
                return "p/" + uri;
            }
            return null;
        }).map(uri -> URLCreator.createAbsoluteURL(applicationURL, uri));
    }

    public static String createSingleURL(ApplicationURL applicationURL, Path path) {
        return URLCreator.createAbsoluteURL(applicationURL, "/p/" + path.asURI());
    }

    public static Path getPath(String url) {
        String[] serverAndPath = url.split("/[bfp]/");
        if (serverAndPath.length == 2) {
            String fullPath = serverAndPath[1];
            String[] pathComponents = fullPath.split("/");
            String id = pathComponents.length == 1 ? null : pathComponents[1];
            return new Path(pathComponents[0], id);
        }
        return null;
    }

    private static String _buildURL(String baseUrl, String relativeURL) {
        if (relativeURL == null || relativeURL.isEmpty()) {
            return null;
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        if (relativeURL.startsWith("/")) {
            relativeURL = relativeURL.substring(1);
        }
        return String.join((CharSequence)"/", baseUrl, relativeURL);
    }

    private static String _createCustomOperationURL(Operation operation, String uri) {
        StringBuilder sb = new StringBuilder();
        sb.append("c/");
        sb.append(uri);
        sb.append("/");
        sb.append(operation.getCustomRoute());
        return sb.toString();
    }

    private static String _getReusablePath(Path path, String name) {
        if (name.equals(path.getName())) {
            return String.join((CharSequence)"/", "p", "r", path.asURI());
        }
        return String.join((CharSequence)"/", "p", path.asURI(), name);
    }

    private URLCreator() {
        throw new UnsupportedOperationException();
    }
}

