/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.routes;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.alias.form.FormBuilderFunction;
import com.liferay.apio.architect.alias.routes.CustomItemFunction;
import com.liferay.apio.architect.alias.routes.DeleteItemConsumer;
import com.liferay.apio.architect.alias.routes.GetItemFunction;
import com.liferay.apio.architect.alias.routes.UpdateItemFunction;
import com.liferay.apio.architect.alias.routes.permission.HasRemovePermissionFunction;
import com.liferay.apio.architect.alias.routes.permission.HasUpdatePermissionFunction;
import com.liferay.apio.architect.consumer.throwable.ThrowableBiConsumer;
import com.liferay.apio.architect.consumer.throwable.ThrowableConsumer;
import com.liferay.apio.architect.consumer.throwable.ThrowablePentaConsumer;
import com.liferay.apio.architect.consumer.throwable.ThrowableTetraConsumer;
import com.liferay.apio.architect.consumer.throwable.ThrowableTriConsumer;
import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.custom.actions.CustomRoute;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.function.throwable.ThrowableBiFunction;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.function.throwable.ThrowableHexaFunction;
import com.liferay.apio.architect.function.throwable.ThrowablePentaFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTetraFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTriFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.alias.ProvideFunction;
import com.liferay.apio.architect.internal.form.FormImpl;
import com.liferay.apio.architect.internal.operation.CreateOperation;
import com.liferay.apio.architect.internal.operation.DeleteOperation;
import com.liferay.apio.architect.internal.operation.RetrieveOperation;
import com.liferay.apio.architect.internal.operation.UpdateOperation;
import com.liferay.apio.architect.internal.routes.RoutesBuilderUtil;
import com.liferay.apio.architect.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.uri.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class ItemRoutesImpl<T, S>
implements ItemRoutes<T, S> {
    private final Map<String, CustomItemFunction<?, S>> _customItemFunctions;
    private final Map<String, CustomRoute> _customRoutes;
    private final DeleteItemConsumer<S> _deleteItemConsumer;
    private final Form _form;
    private final GetItemFunction<T, S> _singleModelFunction;
    private final UpdateItemFunction<T, S> _updateItemFunction;

    public ItemRoutesImpl(BuilderImpl<T, S> builderImpl) {
        this._deleteItemConsumer = ((BuilderImpl)builderImpl)._deleteItemConsumer;
        this._form = ((BuilderImpl)builderImpl)._form;
        this._singleModelFunction = ((BuilderImpl)builderImpl)._singleModelFunction;
        this._updateItemFunction = ((BuilderImpl)builderImpl)._updateItemFunction;
        this._customItemFunctions = ((BuilderImpl)builderImpl)._customItemFunctions;
        this._customRoutes = ((BuilderImpl)builderImpl)._customRoutes;
    }

    public Optional<Map<String, CustomItemFunction<?, S>>> getCustomItemFunctionsOptional() {
        return Optional.of(this._customItemFunctions);
    }

    public Map<String, CustomRoute> getCustomRoutes() {
        return this._customRoutes;
    }

    public Optional<DeleteItemConsumer<S>> getDeleteConsumerOptional() {
        return Optional.ofNullable(this._deleteItemConsumer);
    }

    public Optional<Form> getFormOptional() {
        return Optional.ofNullable(this._form);
    }

    public Optional<GetItemFunction<T, S>> getItemFunctionOptional() {
        return Optional.ofNullable(this._singleModelFunction);
    }

    public Optional<UpdateItemFunction<T, S>> getUpdateItemFunctionOptional() {
        return Optional.ofNullable(this._updateItemFunction);
    }

    public static class BuilderImpl<T, S>
    implements ItemRoutes.Builder<T, S> {
        private Map<String, CustomItemFunction<?, S>> _customItemFunctions = new HashMap();
        private Map<String, BiFunction<Credentials, S, Boolean>> _customPermissionFunctions = new HashMap<String, BiFunction<Credentials, S, Boolean>>();
        private final Map<String, CustomRoute> _customRoutes = new HashMap<String, CustomRoute>();
        private DeleteItemConsumer<S> _deleteItemConsumer;
        private Form _form;
        private HasRemovePermissionFunction<S> _hasRemovePermissionFunction;
        private HasUpdatePermissionFunction<S> _hasUpdatePermissionFunction;
        private final Function<S, Optional<Path>> _identifierToPathFunction;
        private final String _name;
        private final Function<String, Optional<String>> _nameFunction;
        private final Consumer<String> _neededProviderConsumer;
        private final IdentifierFunction<?> _pathToIdentifierFunction;
        private final ProvideFunction _provideFunction;
        private GetItemFunction<T, S> _singleModelFunction;
        private UpdateItemFunction<T, S> _updateItemFunction;

        public BuilderImpl(String name, ProvideFunction provideFunction, Consumer<String> neededProviderConsumer, Function<Path, ?> pathToIdentifierFunction, Function<S, Optional<Path>> identifierToPathFunction, Function<String, Optional<String>> nameFunction) {
            this._name = name;
            this._provideFunction = provideFunction;
            this._neededProviderConsumer = neededProviderConsumer;
            this._pathToIdentifierFunction = pathToIdentifierFunction::apply;
            this._identifierToPathFunction = identifierToPathFunction;
            this._nameFunction = nameFunction;
        }

        public <R, U, I extends Identifier<?>> ItemRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowableBiFunction<S, R, U> throwableBiFunction, Class<I> supplier, BiFunction<Credentials, S, Boolean> permissionBiFunction, FormBuilderFunction<R> formBuilderFunction) {
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionBiFunction);
            CustomItemFunction customFunction = httpServletRequest -> s -> body -> Try.fromFallible(() -> (SingleModelImpl)throwableBiFunction.andThen(t -> new SingleModelImpl<Object>(t, this._getResourceName(supplier))).apply(s, this._getModel(customRoute.getFormOptional(), (Body)body)));
            this._customItemFunctions.put(name, customFunction);
            return this;
        }

        public <A, B, C, D, R, U, I extends Identifier<?>> ItemRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowableHexaFunction<S, R, A, B, C, D, U> throwableHexaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, Class<I> supplier, BiFunction<Credentials, S, Boolean> permissionBiFunction, FormBuilderFunction<R> formBuilderFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionBiFunction);
            CustomItemFunction customFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, (a, b, c, d) -> (SingleModelImpl)throwableHexaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._getResourceName(supplier))).apply(s, this._getModel(customRoute.getFormOptional(), (Body)body), a, b, c, d));
            this._customItemFunctions.put(name, customFunction);
            return this;
        }

        public <A, B, C, R, U, I extends Identifier<?>> ItemRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowablePentaFunction<S, R, A, B, C, U> throwablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<I> supplier, BiFunction<Credentials, S, Boolean> permissionBiFunction, FormBuilderFunction<R> formBuilderFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionBiFunction);
            CustomItemFunction customFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, (a, b, c) -> (SingleModelImpl)throwablePentaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._getResourceName(supplier))).apply(s, this._getModel(customRoute.getFormOptional(), (Body)body), a, b, c));
            this._customItemFunctions.put(name, customFunction);
            return this;
        }

        public <A, B, R, U, I extends Identifier<?>> ItemRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowableTetraFunction<S, R, A, B, U> throwableTetraFunction, Class<A> aClass, Class<B> bClass, Class<I> supplier, BiFunction<Credentials, S, Boolean> permissionBiFunction, FormBuilderFunction<R> formBuilderFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionBiFunction);
            CustomItemFunction customFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, (a, b) -> (SingleModelImpl)throwableTetraFunction.andThen(t -> new SingleModelImpl<Object>(t, this._getResourceName(supplier))).apply(s, this._getModel(customRoute.getFormOptional(), (Body)body), a, b));
            this._customItemFunctions.put(name, customFunction);
            return this;
        }

        public <A, R, U, I extends Identifier<?>> ItemRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowableTriFunction<S, R, A, U> throwableTriFunction, Class<A> aClass, Class<I> supplier, BiFunction<Credentials, S, Boolean> permissionBiFunction, FormBuilderFunction<R> formBuilderFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionBiFunction);
            CustomItemFunction customFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, a -> (SingleModelImpl)throwableTriFunction.andThen(t -> new SingleModelImpl<Object>(t, this._getResourceName(supplier))).apply(s, this._getModel(customRoute.getFormOptional(), (Body)body), a));
            this._customItemFunctions.put(name, customFunction);
            return this;
        }

        public <A> ItemRoutes.Builder<T, S> addGetter(ThrowableBiFunction<S, A, T> getterThrowableBiFunction, Class<A> aClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, Credentials.class, (a, credentials) -> (SingleModelImpl)getterThrowableBiFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, a));
            return this;
        }

        public ItemRoutes.Builder<T, S> addGetter(ThrowableFunction<S, T> getterThrowableFunction) {
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Credentials.class, credentials -> (SingleModelImpl)getterThrowableFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s));
            return this;
        }

        public <A, B, C, D> ItemRoutes.Builder<T, S> addGetter(ThrowablePentaFunction<S, A, B, C, D, T> getterThrowablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, Credentials.class, (a, b, c, d, credentials) -> (SingleModelImpl)getterThrowablePentaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, a, b, c, d));
            return this;
        }

        public <A, B, C> ItemRoutes.Builder<T, S> addGetter(ThrowableTetraFunction<S, A, B, C, T> getterThrowableTetraFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, Credentials.class, (a, b, c, credentials) -> (SingleModelImpl)getterThrowableTetraFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, a, b, c));
            return this;
        }

        public <A, B> ItemRoutes.Builder<T, S> addGetter(ThrowableTriFunction<S, A, B, T> getterThrowableTriFunction, Class<A> aClass, Class<B> bClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, Credentials.class, (a, b, credentials) -> (SingleModelImpl)getterThrowableTriFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, a, b));
            return this;
        }

        public <A> ItemRoutes.Builder<T, S> addRemover(ThrowableBiConsumer<S, A> removerThrowableBiConsumer, Class<A> aClass, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = httpServletRequest -> s -> RoutesBuilderUtil.provideConsumer((Function)this._provideFunction.apply(httpServletRequest), aClass, a -> removerThrowableBiConsumer.accept(s, a));
            return this;
        }

        public ItemRoutes.Builder<T, S> addRemover(ThrowableConsumer<S> removerThrowableConsumer, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = __ -> removerThrowableConsumer;
            return this;
        }

        public <A, B, C, D> ItemRoutes.Builder<T, S> addRemover(ThrowablePentaConsumer<S, A, B, C, D> removerThrowablePentaConsumer, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = httpServletRequest -> s -> RoutesBuilderUtil.provideConsumer((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, (a, b, c, d) -> removerThrowablePentaConsumer.accept(s, a, b, c, d));
            return this;
        }

        public <A, B, C> ItemRoutes.Builder<T, S> addRemover(ThrowableTetraConsumer<S, A, B, C> removerThrowableTetraConsumer, Class<A> aClass, Class<B> bClass, Class<C> cClass, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = httpServletRequest -> s -> RoutesBuilderUtil.provideConsumer((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, (a, b, c) -> removerThrowableTetraConsumer.accept(s, a, b, c));
            return this;
        }

        public <A, B> ItemRoutes.Builder<T, S> addRemover(ThrowableTriConsumer<S, A, B> removerThrowableTriConsumer, Class<A> aClass, Class<B> bClass, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = httpServletRequest -> s -> RoutesBuilderUtil.provideConsumer((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, (a, b) -> removerThrowableTriConsumer.accept(s, a, b));
            return this;
        }

        public <R> ItemRoutes.Builder<T, S> addUpdater(ThrowableBiFunction<S, R, T> updaterThrowableBiFunction, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), this._pathToIdentifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Credentials.class, credentials -> (SingleModelImpl)updaterThrowableBiFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body)));
            return this;
        }

        public <A, B, C, D, R> ItemRoutes.Builder<T, S> addUpdater(ThrowableHexaFunction<S, R, A, B, C, D, T> updaterThrowableHexaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), this._pathToIdentifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, Credentials.class, (a, b, c, d, credentials) -> (SingleModelImpl)updaterThrowableHexaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body), a, b, c, d));
            return this;
        }

        public <A, B, C, R> ItemRoutes.Builder<T, S> addUpdater(ThrowablePentaFunction<S, R, A, B, C, T> updaterThrowablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), this._pathToIdentifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, Credentials.class, (a, b, c, credentials) -> (SingleModelImpl)updaterThrowablePentaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body), a, b, c));
            return this;
        }

        public <A, B, R> ItemRoutes.Builder<T, S> addUpdater(ThrowableTetraFunction<S, R, A, B, T> updaterThrowableTetraFunction, Class<A> aClass, Class<B> bClass, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), this._pathToIdentifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, Credentials.class, (a, b, credentials) -> (SingleModelImpl)updaterThrowableTetraFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body), a, b));
            return this;
        }

        public <A, R> ItemRoutes.Builder<T, S> addUpdater(ThrowableTriFunction<S, R, A, T> updaterThrowableTriFunction, Class<A> aClass, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), this._pathToIdentifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, Credentials.class, (a, credentials) -> (SingleModelImpl)updaterThrowableTriFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body), a));
            return this;
        }

        public ItemRoutes<T, S> build() {
            return new ItemRoutesImpl(this);
        }

        private void _calculateForm(CustomRoute customRoute, FormBuilderFunction<?> formBuilderFunction, String name) {
            if (formBuilderFunction != null) {
                Form form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("p", this._name, name), this._pathToIdentifierFunction));
                customRoute.setForm(form);
            }
        }

        private Operation _createOperation(Form form, HTTPMethod method, String name, String path, String custom) {
            if (method == HTTPMethod.GET) {
                return new RetrieveOperation(name, false, path, custom);
            }
            if (method == HTTPMethod.POST) {
                return new CreateOperation(form, name, path, custom);
            }
            if (method == HTTPMethod.DELETE) {
                return new DeleteOperation(name, path, custom);
            }
            if (method == HTTPMethod.PUT) {
                return new UpdateOperation(form, name, path, custom);
            }
            return null;
        }

        private <R> R _getModel(Optional<Form<?>> formOptional, Body body) {
            return formOptional.map(form -> form.get(body)).orElse(null);
        }

        private List<Operation> _getOperations(Credentials credentials, S identifier) {
            Boolean canUpdate;
            Boolean canRemove;
            Optional<Path> optional = this._identifierToPathFunction.apply(identifier);
            if (!optional.isPresent()) {
                return Collections.emptyList();
            }
            Path path = optional.get();
            ArrayList<Operation> operations = new ArrayList<Operation>();
            if (this._hasRemovePermissionFunction != null && (canRemove = (Boolean)Try.fromFallible(() -> (Boolean)this._hasRemovePermissionFunction.apply((Object)credentials, identifier)).orElse((Object)false)).booleanValue()) {
                DeleteOperation deleteOperation = new DeleteOperation(this._name, path.asURI());
                operations.add(deleteOperation);
            }
            if (this._hasUpdatePermissionFunction != null && (canUpdate = (Boolean)Try.fromFallible(() -> (Boolean)this._hasUpdatePermissionFunction.apply((Object)credentials, identifier)).orElse((Object)false)).booleanValue()) {
                UpdateOperation updateOperation = new UpdateOperation(this._form, this._name, path.asURI());
                operations.add(updateOperation);
            }
            Set<String> customPermissionKeys = this._customPermissionFunctions.keySet();
            Stream customPermissionKeysStream = customPermissionKeys.stream();
            customPermissionKeysStream.filter(key -> this._getPermissionFunction(credentials, identifier, (String)key)).forEach(routeEntry -> {
                CustomRoute customRoute = this._customRoutes.get(routeEntry);
                Optional formOptional = customRoute.getFormOptional();
                Form form = formOptional.orElse(null);
                Operation operation = this._createOperation(form, customRoute.getMethod(), this._name, path.asURI(), (String)routeEntry);
                operations.add(operation);
            });
            return operations;
        }

        private Boolean _getPermissionFunction(Credentials credentials, S identifier, String key) {
            return (Boolean)Try.fromFallible(() -> this._customPermissionFunctions.get(key)).map(function -> (Boolean)function.apply(credentials, identifier)).orElse((Object)false);
        }

        private <I extends Identifier<?>> String _getResourceName(Class<I> supplier) {
            return this._nameFunction.apply(supplier.getName()).orElse(null);
        }
    }
}

