/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.representor;

import com.liferay.apio.architect.alias.BinaryFunction;
import com.liferay.apio.architect.alias.representor.FieldFunction;
import com.liferay.apio.architect.alias.representor.NestedFieldFunction;
import com.liferay.apio.architect.alias.representor.NestedListFieldFunction;
import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.date.DateTransformer;
import com.liferay.apio.architect.internal.related.RelatedCollectionImpl;
import com.liferay.apio.architect.internal.related.RelatedModelImpl;
import com.liferay.apio.architect.internal.representor.NestedRepresentorImpl;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.related.RelatedCollection;
import com.liferay.apio.architect.related.RelatedModel;
import com.liferay.apio.architect.representor.BaseRepresentor;
import com.liferay.apio.architect.representor.NestedRepresentor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class BaseRepresentorImpl<T>
implements BaseRepresentor<T> {
    protected final Map<String, BinaryFunction<T>> binaryFunctions = new LinkedHashMap<String, BinaryFunction<T>>();
    protected final Map<String, List<FieldFunction<T, ?>>> fieldFunctions = new LinkedHashMap();
    protected final List<NestedFieldFunction<T, ?>> nestedFieldFunctions = new ArrayList();
    protected final List<NestedListFieldFunction<T, ?>> nestedListFieldFunctions = new ArrayList();
    protected String primaryType;
    protected final List<RelatedCollection<T, ?>> relatedCollections = new ArrayList();
    protected final List<RelatedModel<T, ?>> relatedModels = new ArrayList();
    protected final Supplier<List<RelatedCollection<T, ?>>> supplier;
    protected final List<String> types = new ArrayList<String>();
    private final Function<Class<? extends Identifier<?>>, String> _nameFunction;

    public List<FieldFunction<T, String>> getApplicationRelativeURLFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("APPLICATION_RELATIVE_URL")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public Optional<BinaryFunction<T>> getBinaryFunction(String binaryId) {
        return Optional.ofNullable(this.binaryFunctions.get(binaryId));
    }

    public List<FieldFunction<T, BinaryFile>> getBinaryFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("BINARY")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public List<FieldFunction<T, Boolean>> getBooleanFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("BOOLEAN")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public List<FieldFunction<T, List<Boolean>>> getBooleanListFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("BOOLEAN_LIST")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public List<FieldFunction<T, String>> getLinkFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("LINK")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public List<FieldFunction<T, Function<AcceptLanguage, String>>> getLocalizedStringFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("LOCALIZED")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public List<NestedFieldFunction<T, ?>> getNestedFieldFunctions() {
        return this.nestedFieldFunctions;
    }

    public List<NestedListFieldFunction<T, ?>> getNestedListFieldFunctions() {
        return this.nestedListFieldFunctions;
    }

    public List<FieldFunction<T, Number>> getNumberFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("NUMBER")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public List<FieldFunction<T, List<Number>>> getNumberListFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("NUMBER_LIST")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public Stream<RelatedCollection<T, ? extends Identifier>> getRelatedCollections() {
        return Stream.of(this.relatedCollections, this.supplier.get()).filter(Objects::nonNull).flatMap(Collection::stream);
    }

    public List<RelatedModel<T, ?>> getRelatedModels() {
        return this.relatedModels;
    }

    public List<FieldFunction<T, String>> getRelativeURLFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("RELATIVE_URL")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public List<FieldFunction<T, String>> getStringFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("STRING")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public List<FieldFunction<T, List<String>>> getStringListFunctions() {
        return Optional.ofNullable(this.fieldFunctions.get("STRING_LIST")).map(Unsafe::unsafeCast).orElseGet(Collections::emptyList);
    }

    public List<String> getTypes() {
        return this.types;
    }

    protected BaseRepresentorImpl(Function<Class<? extends Identifier<?>>, String> nameFunction, Supplier<List<RelatedCollection<T, ?>>> supplier) {
        this._nameFunction = nameFunction;
        this.supplier = supplier;
    }

    protected void addApplicationRelativeURLFunction(String key, Function<T, String> function) {
        this._addFieldFunction(key, function, "APPLICATION_RELATIVE_URL");
    }

    protected void addBinaryFunction(String key, BinaryFunction<T> binaryFunction) {
        this.binaryFunctions.put(key, binaryFunction);
        this._addFieldFunction(key, (Function)binaryFunction, "BINARY");
    }

    protected void addBooleanFunction(String key, Function<T, Boolean> function) {
        this._addFieldFunction(key, function, "BOOLEAN");
    }

    protected void addBooleanListFunction(String key, Function<T, List<Boolean>> function) {
        this._addFieldFunction(key, function, "BOOLEAN_LIST");
    }

    protected void addLanguageFunction(String key, Function<T, Function<AcceptLanguage, String>> function) {
        this._addFieldFunction(key, function, "LOCALIZED");
    }

    protected void addLinkFunction(String key, Function<T, String> function) {
        this._addFieldFunction(key, function, "LINK");
    }

    protected <S> void addNestedField(final String key, final Function<T, S> transformFunction, Function<NestedRepresentor.Builder<S>, NestedRepresentor<S>> function) {
        NestedFieldFunction nestedFieldFunction = function.andThen(nestedRepresentor -> new NestedFieldFunction<T, S>((NestedRepresentor)nestedRepresentor){
            final /* synthetic */ NestedRepresentor val$nestedRepresentor;
            {
                this.val$nestedRepresentor = nestedRepresentor;
            }

            public S apply(T t) {
                return transformFunction.apply(t);
            }

            public String getKey() {
                return key;
            }

            public NestedRepresentor<S> getNestedRepresentor() {
                return this.val$nestedRepresentor;
            }
        }).apply(new NestedRepresentorImpl.BuilderImpl<T>(this._nameFunction, this.supplier));
        this.nestedFieldFunctions.add(nestedFieldFunction);
    }

    protected <S> void addNestedListField(final String key, final Function<T, List<S>> transformFunction, Function<NestedRepresentor.Builder<S>, NestedRepresentor<S>> function) {
        NestedListFieldFunction nestedFieldFunction = function.andThen(nestedRepresentor -> new NestedListFieldFunction<T, S>((NestedRepresentor)nestedRepresentor){
            final /* synthetic */ NestedRepresentor val$nestedRepresentor;
            {
                this.val$nestedRepresentor = nestedRepresentor;
            }

            public List<S> apply(T t) {
                return (List)transformFunction.apply(t);
            }

            public String getKey() {
                return key;
            }

            public NestedRepresentor<S> getNestedRepresentor() {
                return this.val$nestedRepresentor;
            }
        }).apply(new NestedRepresentorImpl.BuilderImpl<T>(this._nameFunction, this.supplier));
        this.nestedListFieldFunctions.add(nestedFieldFunction);
    }

    protected void addNumberFunction(String key, Function<T, Number> function) {
        this._addFieldFunction(key, function, "NUMBER");
    }

    protected void addNumberListFunction(String key, Function<T, List<Number>> function) {
        this._addFieldFunction(key, function, "NUMBER_LIST");
    }

    protected <S extends Identifier<?>> void addRelatedCollection(String key, Class<S> itemIdentifierClass, Function<T, ?> modelToIdentifierFunction) {
        RelatedCollectionImpl<T, S> relatedCollection = new RelatedCollectionImpl<T, S>(key, itemIdentifierClass, modelToIdentifierFunction);
        this.relatedCollections.add(relatedCollection);
    }

    protected <S> void addRelatedModel(String key, Class<? extends Identifier<S>> identifierClass, Function<T, S> modelToIdentifierFunction) {
        RelatedModelImpl<T, S> relatedModel = new RelatedModelImpl<T, S>(key, identifierClass, modelToIdentifierFunction, () -> this._nameFunction.apply(identifierClass));
        this.relatedModels.add(relatedModel);
    }

    protected void addRelativeURLFunction(String key, Function<T, String> function) {
        this._addFieldFunction(key, function, "RELATIVE_URL");
    }

    protected void addStringFunction(String key, Function<T, String> function) {
        this._addFieldFunction(key, function, "STRING");
    }

    protected void addStringListFunction(String key, Function<T, List<String>> function) {
        this._addFieldFunction(key, function, "STRING_LIST");
    }

    protected void addTypes(String type, String ... types) {
        this.primaryType = type;
        this.types.add(type);
        Collections.addAll(this.types, types);
    }

    private <S> void _addFieldFunction(final String key, final Function<T, S> function, String mapKey) {
        List list = this.fieldFunctions.computeIfAbsent(mapKey, __ -> new ArrayList());
        FieldFunction fieldFunction = new FieldFunction<T, S>(){

            public S apply(T t) {
                return function.apply(t);
            }

            public String getKey() {
                return key;
            }
        };
        list.add(fieldFunction);
    }

    protected static abstract class BaseBuilderImpl<T, S extends BaseRepresentorImpl<T>> {
        protected final S baseRepresentor;

        protected BaseBuilderImpl(S baseRepresentor) {
            this.baseRepresentor = baseRepresentor;
        }

        public abstract class BaseFirstStepImpl<U extends BaseRepresentor<T>, V extends BaseRepresentor.BaseFirstStep<T, U, V>>
        implements BaseRepresentor.BaseFirstStep<T, U, V> {
            private final V _this = this.getThis();

            public V addApplicationRelativeURL(String key, Function<T, String> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addApplicationRelativeURLFunction(key, function);
                return this._this;
            }

            public V addBinary(String key, BinaryFunction<T> binaryFunction) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addBinaryFunction(key, binaryFunction);
                return this._this;
            }

            public V addBoolean(String key, Function<T, Boolean> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addBooleanFunction(key, function);
                return this._this;
            }

            public V addBooleanList(String key, Function<T, List<Boolean>> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addBooleanListFunction(key, function);
                return this._this;
            }

            public V addDate(String key, Function<T, Date> function) {
                Function<Date, String> formatFunction = date -> {
                    if (date == null) {
                        return null;
                    }
                    return DateTransformer.asString(date);
                };
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addStringFunction(key, function.andThen(formatFunction));
                return this._this;
            }

            public V addLink(String key, String url) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addLinkFunction(key, __ -> url);
                return this._this;
            }

            public <W> V addLinkedModel(String key, Class<? extends Identifier<W>> identifierClass, Function<T, W> modelToIdentifierFunction) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addRelatedModel(key, identifierClass, modelToIdentifierFunction);
                return this._this;
            }

            public V addLocalizedStringByLanguage(String key, BiFunction<T, AcceptLanguage, String> stringFunction) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addLanguageFunction(key, t -> acceptLanguage -> (String)stringFunction.apply((Object)t, (AcceptLanguage)acceptLanguage));
                return this._this;
            }

            public V addLocalizedStringByLocale(String key, BiFunction<T, Locale, String> stringFunction) {
                return this.addLocalizedStringByLanguage(key, (t, acceptLanguage) -> (String)stringFunction.apply(t, acceptLanguage.getPreferredLocale()));
            }

            public <W> V addNested(String key, Function<T, W> transformFunction, Function<NestedRepresentor.Builder<W>, NestedRepresentor<W>> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addNestedField(key, transformFunction, function);
                return this._this;
            }

            public <W> V addNestedList(String key, Function<T, List<W>> transformFunction, Function<NestedRepresentor.Builder<W>, NestedRepresentor<W>> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addNestedListField(key, transformFunction, function);
                return this._this;
            }

            public V addNumber(String key, Function<T, Number> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addNumberFunction(key, function);
                return this._this;
            }

            public V addNumberList(String key, Function<T, List<Number>> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addNumberListFunction(key, function);
                return this._this;
            }

            public <W, S extends Identifier<?>> V addRelatedCollection(String key, Class<S> itemIdentifierClass, Function<T, W> modelToIdentifierFunction) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addRelatedCollection(key, itemIdentifierClass, modelToIdentifierFunction);
                return this._this;
            }

            public V addRelativeURL(String key, Function<T, String> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addRelativeURLFunction(key, function);
                return this._this;
            }

            public V addString(String key, Function<T, String> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addStringFunction(key, function);
                return this._this;
            }

            public V addStringList(String key, Function<T, List<String>> function) {
                ((BaseRepresentorImpl)BaseBuilderImpl.this.baseRepresentor).addStringListFunction(key, function);
                return this._this;
            }

            public U build() {
                return (U)BaseBuilderImpl.this.baseRepresentor;
            }

            protected BaseFirstStepImpl() {
            }

            protected abstract V getThis();
        }
    }
}

