/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.message.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class JSONObjectBuilder {
    private static final ObjectMapper _OBJECT_MAPPER = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.enable(SerializationFeature.INDENT_OUTPUT);
        }
    };
    private final ObjectNode _objectNode = _OBJECT_MAPPER.createObjectNode();

    public String build() {
        try {
            return _OBJECT_MAPPER.writeValueAsString((Object)this._objectNode);
        }
        catch (JsonProcessingException jpe) {
            return this._objectNode.toString();
        }
    }

    public FieldStep field(String name) {
        return new FieldStep(name, this._objectNode);
    }

    public FieldStep ifElseCondition(boolean condition, Function<JSONObjectBuilder, FieldStep> ifFunction, Function<JSONObjectBuilder, FieldStep> elseFunction) {
        if (condition) {
            return ifFunction.apply(this);
        }
        return elseFunction.apply(this);
    }

    public FieldStep nestedField(String parentName, String ... nestedNames) {
        FieldStep fieldStep = this.field(parentName);
        for (String nestedName : nestedNames) {
            fieldStep = fieldStep.field(nestedName);
        }
        return fieldStep;
    }

    public FieldStep nestedPrefixedField(String prefix, String parentName, String ... nestedNames) {
        FieldStep fieldStep = this.nestedField(prefix, parentName);
        for (String nestedName : nestedNames) {
            fieldStep = fieldStep.nestedField(prefix, nestedName);
        }
        return fieldStep;
    }

    public FieldStep nestedSuffixedField(String suffix, String parentName, String ... nestedNames) {
        FieldStep fieldStep = this.nestedField(parentName, suffix);
        for (String nestedName : nestedNames) {
            fieldStep = fieldStep.nestedField(nestedName, suffix);
        }
        return fieldStep;
    }

    public static class FieldStep {
        private final String _name;
        private final ObjectNode _objectNode;

        public FieldStep(String name, ObjectNode objectNode) {
            this._name = name;
            this._objectNode = objectNode;
        }

        public ArrayValueStep arrayValue() {
            ArrayNode arrayNode = Optional.ofNullable(this._objectNode.get(this._name)).filter(JsonNode::isArray).map(ArrayNode.class::cast).orElseGet(() -> ((ObjectMapper)_OBJECT_MAPPER).createArrayNode());
            this._objectNode.set(this._name, (JsonNode)arrayNode);
            return new ArrayValueStep(arrayNode);
        }

        @SafeVarargs
        public final void arrayValue(Consumer<ArrayValueStep> consumer, Consumer<ArrayValueStep> ... consumers) {
            ArrayValueStep arrayValueStep = this.arrayValue();
            consumer.accept(arrayValueStep);
            for (Consumer<ArrayValueStep> arrayValueStepConsumer : consumers) {
                arrayValueStepConsumer.accept(arrayValueStep);
            }
        }

        public void booleanValue(Boolean value) {
            this._objectNode.put(this._name, value);
        }

        public FieldStep field(String name) {
            ObjectNode objectNode = Optional.ofNullable(this._objectNode.get(this._name)).filter(JsonNode::isObject).map(ObjectNode.class::cast).orElseGet(() -> ((ObjectMapper)_OBJECT_MAPPER).createObjectNode());
            this._objectNode.set(this._name, (JsonNode)objectNode);
            return new FieldStep(name, objectNode);
        }

        @SafeVarargs
        public final void fields(Consumer<FieldStep> consumer, Consumer<FieldStep> ... consumers) {
            consumer.accept(this);
            for (Consumer<FieldStep> fieldStepConsumer : consumers) {
                fieldStepConsumer.accept(this);
            }
        }

        public FieldStep ifCondition(boolean condition, Function<FieldStep, FieldStep> ifFunction) {
            if (condition) {
                return ifFunction.apply(this);
            }
            return this;
        }

        public FieldStep ifElseCondition(boolean condition, Function<FieldStep, FieldStep> ifFunction, Function<FieldStep, FieldStep> elseFunction) {
            if (condition) {
                return ifFunction.apply(this);
            }
            return elseFunction.apply(this);
        }

        public FieldStep nestedField(String parentName, String ... nestedNames) {
            FieldStep fieldStep = this.field(parentName);
            for (String nestedName : nestedNames) {
                fieldStep = fieldStep.field(nestedName);
            }
            return fieldStep;
        }

        public FieldStep nestedPrefixedField(String prefix, String parentName, String ... nestedNames) {
            FieldStep fieldStep = this.nestedField(prefix, parentName);
            for (String nestedName : nestedNames) {
                fieldStep = fieldStep.nestedField(prefix, nestedName);
            }
            return fieldStep;
        }

        public FieldStep nestedSuffixedField(String suffix, String parentName, String ... nestedNames) {
            FieldStep fieldStep = this.nestedField(parentName, suffix);
            for (String nestedName : nestedNames) {
                fieldStep = fieldStep.nestedField(nestedName, suffix);
            }
            return fieldStep;
        }

        public void numberValue(Number value) {
            this._objectNode.putPOJO(this._name, (Object)value);
        }

        public void objectValue(JSONObjectBuilder jsonObjectBuilder) {
            ObjectNode objectNode = jsonObjectBuilder._objectNode;
            this._objectNode.set(this._name, (JsonNode)objectNode);
        }

        public void stringValue(String value) {
            this._objectNode.put(this._name, value);
        }
    }

    public static class ArrayValueStep {
        private final ArrayNode _arrayNode;

        public ArrayValueStep(ArrayNode arrayNode) {
            this._arrayNode = arrayNode;
        }

        public void add(Consumer<JSONObjectBuilder> consumer) {
            JSONObjectBuilder jsonObjectBuilder = new JSONObjectBuilder();
            consumer.accept(jsonObjectBuilder);
            this.add(jsonObjectBuilder);
        }

        @SafeVarargs
        public final void add(Consumer<JSONObjectBuilder> consumer, Consumer<JSONObjectBuilder> ... consumers) {
            this.add(consumer);
            for (Consumer<JSONObjectBuilder> jsonObjectBuilderConsumer : consumers) {
                this.add(jsonObjectBuilderConsumer);
            }
        }

        public void add(JSONObjectBuilder jsonObjectBuilder) {
            this._arrayNode.add((JsonNode)jsonObjectBuilder._objectNode);
        }

        public void addAllBooleans(Collection<Boolean> collection) {
            collection.forEach(this::addBoolean);
        }

        public void addAllNumbers(Collection<Number> collection) {
            collection.forEach(this::addNumber);
        }

        public void addAllStrings(Collection<String> collection) {
            collection.forEach(this::addString);
        }

        public void addBoolean(Boolean value) {
            this._arrayNode.add(value);
        }

        public void addNumber(Number value) {
            this._arrayNode.addPOJO((Object)value);
        }

        public void addString(String value) {
            this._arrayNode.add(value);
        }
    }
}

