/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.form;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.alias.form.FormBuilderFunction;
import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.form.FieldType;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.form.FormField;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.form.FormFieldImpl;
import com.liferay.apio.architect.internal.form.FormUtil;
import com.liferay.apio.architect.language.AcceptLanguage;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;

public class FormImpl<T>
implements Form<T> {
    private Function<AcceptLanguage, String> _descriptionFunction;
    private final Map<String, FormBuilderFunction<?>> _formBuilderFunctionsMap = new HashMap();
    private final String _id;
    private final Map<String, Function<T, Consumer<List<Boolean>>>> _optionalBooleanLists = new HashMap<String, Function<T, Consumer<List<Boolean>>>>();
    private final Map<String, Function<T, Consumer<Boolean>>> _optionalBooleans = new HashMap<String, Function<T, Consumer<Boolean>>>();
    private final Map<String, Function<T, Consumer<List<Date>>>> _optionalDateLists = new HashMap<String, Function<T, Consumer<List<Date>>>>();
    private final Map<String, Function<T, Consumer<Date>>> _optionalDates = new HashMap<String, Function<T, Consumer<Date>>>();
    private final Map<String, Function<T, Consumer<List<Double>>>> _optionalDoubleLists = new HashMap<String, Function<T, Consumer<List<Double>>>>();
    private final Map<String, Function<T, Consumer<Double>>> _optionalDoubles = new HashMap<String, Function<T, Consumer<Double>>>();
    private final Map<String, Function<T, Consumer<List<BinaryFile>>>> _optionalFileLists = new HashMap<String, Function<T, Consumer<List<BinaryFile>>>>();
    private final Map<String, Function<T, Consumer<BinaryFile>>> _optionalFiles = new HashMap<String, Function<T, Consumer<BinaryFile>>>();
    private final Map<String, Function<T, Consumer<?>>> _optionalLinkedModel = new HashMap();
    private final Map<String, Function<T, Consumer<List<?>>>> _optionalLinkedModelList = new HashMap();
    private final Map<String, Function<T, Consumer<List<Long>>>> _optionalLongLists = new HashMap<String, Function<T, Consumer<List<Long>>>>();
    private final Map<String, Function<T, Consumer<Long>>> _optionalLongs = new HashMap<String, Function<T, Consumer<Long>>>();
    private final Map<String, Function<T, Consumer<Object>>> _optionalNestedModel = new HashMap<String, Function<T, Consumer<Object>>>();
    private final Map<String, Function<T, Consumer<List<Object>>>> _optionalNestedModelLists = new HashMap<String, Function<T, Consumer<List<Object>>>>();
    private final Map<String, Function<T, Consumer<List<String>>>> _optionalStringLists = new HashMap<String, Function<T, Consumer<List<String>>>>();
    private final Map<String, Function<T, Consumer<String>>> _optionalStrings = new HashMap<String, Function<T, Consumer<String>>>();
    private final IdentifierFunction<?> _pathToIdentifierFunction;
    private final Map<String, Function<T, Consumer<List<Boolean>>>> _requiredBooleanLists = new HashMap<String, Function<T, Consumer<List<Boolean>>>>();
    private final Map<String, Function<T, Consumer<Boolean>>> _requiredBooleans = new HashMap<String, Function<T, Consumer<Boolean>>>();
    private final Map<String, Function<T, Consumer<List<Date>>>> _requiredDateLists = new HashMap<String, Function<T, Consumer<List<Date>>>>();
    private final Map<String, Function<T, Consumer<Date>>> _requiredDates = new HashMap<String, Function<T, Consumer<Date>>>();
    private final Map<String, Function<T, Consumer<List<Double>>>> _requiredDoubleLists = new HashMap<String, Function<T, Consumer<List<Double>>>>();
    private final Map<String, Function<T, Consumer<Double>>> _requiredDoubles = new HashMap<String, Function<T, Consumer<Double>>>();
    private final Map<String, Function<T, Consumer<List<BinaryFile>>>> _requiredFileLists = new HashMap<String, Function<T, Consumer<List<BinaryFile>>>>();
    private final Map<String, Function<T, Consumer<BinaryFile>>> _requiredFiles = new HashMap<String, Function<T, Consumer<BinaryFile>>>();
    private final Map<String, Function<T, Consumer<?>>> _requiredLinkedModel = new HashMap();
    private final Map<String, Function<T, Consumer<List<?>>>> _requiredLinkedModelList = new HashMap();
    private final Map<String, Function<T, Consumer<List<Long>>>> _requiredLongLists = new HashMap<String, Function<T, Consumer<List<Long>>>>();
    private final Map<String, Function<T, Consumer<Long>>> _requiredLongs = new HashMap<String, Function<T, Consumer<Long>>>();
    private final Map<String, Function<T, Consumer<Object>>> _requiredNestedModel = new HashMap<String, Function<T, Consumer<Object>>>();
    private final Map<String, Function<T, Consumer<List<Object>>>> _requiredNestedModelLists = new HashMap<String, Function<T, Consumer<List<Object>>>>();
    private final Map<String, Function<T, Consumer<List<String>>>> _requiredStringLists = new HashMap<String, Function<T, Consumer<List<String>>>>();
    private final Map<String, Function<T, Consumer<String>>> _requiredStrings = new HashMap<String, Function<T, Consumer<String>>>();
    private Supplier<T> _supplier;
    private Function<AcceptLanguage, String> _titleFunction;

    public T get(Body body) {
        T t = this._supplier.get();
        this._getFormFields(this, body, t);
        return t;
    }

    public String getDescription(AcceptLanguage acceptLanguage) {
        return this._descriptionFunction.apply(acceptLanguage);
    }

    public List<FormField> getFormFields() {
        return this._getFormFields(this);
    }

    public String getId() {
        return this._id;
    }

    public List<T> getList(Body body) {
        Optional optional = body.getBodyMembersOptional();
        List bodyMembers = (List)optional.orElseThrow(() -> new BadRequestException("Body does not contain members"));
        Stream stream = bodyMembers.stream();
        return stream.map(this::get).collect(Collectors.toList());
    }

    public String getTitle(AcceptLanguage acceptLanguage) {
        return this._titleFunction.apply(acceptLanguage);
    }

    private FormImpl(List<String> paths, IdentifierFunction<?> pathToIdentifierFunction) {
        this._id = String.join((CharSequence)"/", paths);
        this._pathToIdentifierFunction = pathToIdentifierFunction;
    }

    private List<FormField> _getFormFields(FormImpl<T> form) {
        return Stream.of(FormUtil.getOptionalFormFieldStream(form._optionalBooleans, FieldType.BOOLEAN), FormUtil.getOptionalFormFieldStream(form._optionalBooleanLists, FieldType.BOOLEAN_LIST), FormUtil.getOptionalFormFieldStream(form._optionalDates, FieldType.DATE), FormUtil.getOptionalFormFieldStream(form._optionalDateLists, FieldType.DATE_LIST), FormUtil.getOptionalFormFieldStream(form._optionalDoubles, FieldType.DOUBLE), FormUtil.getOptionalFormFieldStream(form._optionalDoubleLists, FieldType.DOUBLE_LIST), FormUtil.getOptionalFormFieldStream(form._optionalFiles, FieldType.FILE), FormUtil.getOptionalFormFieldStream(form._optionalFileLists, FieldType.FILE_LIST), FormUtil.getOptionalFormFieldStream(form._optionalLinkedModel, FieldType.LINKED_MODEL), FormUtil.getOptionalFormFieldStream(form._optionalLinkedModelList, FieldType.LINKED_MODEL_LIST), FormUtil.getOptionalFormFieldStream(form._optionalLongs, FieldType.LONG), FormUtil.getOptionalFormFieldStream(form._optionalLongLists, FieldType.LONG_LIST), this._getNestedModelFormFieldStream(form._optionalNestedModel, FieldType.NESTED_MODEL, false), this._getNestedModelFormFieldStream(form._optionalNestedModelLists, FieldType.NESTED_MODEL_LIST, false), FormUtil.getOptionalFormFieldStream(form._optionalStrings, FieldType.STRING), FormUtil.getOptionalFormFieldStream(form._optionalStringLists, FieldType.STRING_LIST), FormUtil.getRequiredFormFieldStream(form._requiredBooleans, FieldType.BOOLEAN), FormUtil.getRequiredFormFieldStream(form._requiredBooleanLists, FieldType.BOOLEAN_LIST), FormUtil.getRequiredFormFieldStream(form._requiredDates, FieldType.DATE), FormUtil.getRequiredFormFieldStream(form._requiredDateLists, FieldType.DATE_LIST), FormUtil.getRequiredFormFieldStream(form._requiredDoubles, FieldType.DOUBLE), FormUtil.getRequiredFormFieldStream(form._requiredDoubleLists, FieldType.DOUBLE_LIST), FormUtil.getRequiredFormFieldStream(form._requiredFiles, FieldType.FILE), FormUtil.getRequiredFormFieldStream(form._requiredFileLists, FieldType.FILE_LIST), FormUtil.getRequiredFormFieldStream(form._requiredLinkedModel, FieldType.LINKED_MODEL), FormUtil.getRequiredFormFieldStream(form._requiredLinkedModelList, FieldType.LINKED_MODEL_LIST), FormUtil.getRequiredFormFieldStream(form._requiredLongs, FieldType.LONG), FormUtil.getRequiredFormFieldStream(form._requiredLongLists, FieldType.LONG_LIST), this._getNestedModelFormFieldStream(form._requiredNestedModel, FieldType.NESTED_MODEL, true), this._getNestedModelFormFieldStream(form._requiredNestedModelLists, FieldType.NESTED_MODEL_LIST, true), FormUtil.getRequiredFormFieldStream(form._requiredStrings, FieldType.STRING), FormUtil.getRequiredFormFieldStream(form._requiredStringLists, FieldType.STRING_LIST)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    private <U> void _getFormFields(FormImpl<U> formImpl, Body body, U u) {
        formImpl._optionalBooleans.forEach(FormUtil.getOptionalBoolean(body, u));
        formImpl._optionalBooleanLists.forEach(FormUtil.getOptionalBooleanList(body, u));
        formImpl._optionalDates.forEach(FormUtil.getOptionalDate(body, u));
        formImpl._optionalDateLists.forEach(FormUtil.getOptionalDateList(body, u));
        formImpl._optionalDoubles.forEach(FormUtil.getOptionalDouble(body, u));
        formImpl._optionalDoubleLists.forEach(FormUtil.getOptionalDoubleList(body, u));
        formImpl._optionalFiles.forEach(FormUtil.getOptionalFile(body, u));
        formImpl._optionalFileLists.forEach(FormUtil.getOptionalFileList(body, u));
        formImpl._optionalLinkedModel.forEach(FormUtil.getOptionalLinkedModel(body, u, this._pathToIdentifierFunction));
        formImpl._optionalLinkedModelList.forEach(FormUtil.getOptionalLinkedModelList(body, u, this._pathToIdentifierFunction));
        formImpl._optionalLongs.forEach(FormUtil.getOptionalLong(body, u));
        formImpl._optionalLongLists.forEach(FormUtil.getOptionalLongList(body, u));
        formImpl._optionalNestedModel.forEach(super._getOptionalNestedModel(body, u));
        formImpl._optionalNestedModelLists.forEach(super._getOptionalNestedModelList(body, u));
        formImpl._optionalStrings.forEach(FormUtil.getOptionalString(body, u));
        formImpl._optionalStringLists.forEach(FormUtil.getOptionalStringList(body, u));
        formImpl._requiredBooleans.forEach(FormUtil.getRequiredBoolean(body, u));
        formImpl._requiredBooleanLists.forEach(FormUtil.getRequiredBooleanList(body, u));
        formImpl._requiredDates.forEach(FormUtil.getRequiredDate(body, u));
        formImpl._requiredDateLists.forEach(FormUtil.getRequiredDateList(body, u));
        formImpl._requiredDoubles.forEach(FormUtil.getRequiredDouble(body, u));
        formImpl._requiredDoubleLists.forEach(FormUtil.getRequiredDoubleList(body, u));
        formImpl._requiredFiles.forEach(FormUtil.getRequiredFile(body, u));
        formImpl._requiredFileLists.forEach(FormUtil.getRequiredFileList(body, u));
        formImpl._requiredLinkedModel.forEach(FormUtil.getRequiredLinkedModel(body, u, this._pathToIdentifierFunction));
        formImpl._requiredLinkedModelList.forEach(FormUtil.getRequiredLinkedModelList(body, u, this._pathToIdentifierFunction));
        formImpl._requiredLongs.forEach(FormUtil.getRequiredLong(body, u));
        formImpl._requiredLongLists.forEach(FormUtil.getRequiredLongList(body, u));
        formImpl._requiredNestedModel.forEach(super._getRequiredNestedModel(body, u));
        formImpl._requiredNestedModelLists.forEach(super._getRequiredNestedModelList(body, u));
        formImpl._requiredStrings.forEach(FormUtil.getRequiredString(body, u));
        formImpl._requiredStringLists.forEach(FormUtil.getRequiredStringList(body, u));
    }

    private <V> FormImpl<V> _getNestedForm(String key) {
        List<String> paths = Collections.singletonList(this._id);
        BuilderImpl builder = new BuilderImpl(paths, this._pathToIdentifierFunction);
        FormBuilderFunction<?> formBuilderFunction = this._formBuilderFunctionsMap.get(key);
        return (FormImpl)formBuilderFunction.apply(builder);
    }

    private <U, V> void _getNestedModel(Body body, U u, String key, Function<U, Consumer<V>> consumerFunction, boolean required) {
        FormImpl<V> nestedForm = this._getNestedForm(key);
        T v = nestedForm._supplier.get();
        Optional bodyOptional = body.getNestedBodyOptional(key);
        if (bodyOptional.isPresent()) {
            this._getFormFields(nestedForm, (Body)bodyOptional.get(), v);
        } else if (required) {
            throw new BadRequestException("Field \"" + key + "\" is required");
        }
        consumerFunction.apply(u).accept(v);
    }

    private Stream<FormField> _getNestedModelFormFieldStream(Map<String, ?> nestedModelMap, FieldType fieldType, boolean required) {
        Set<String> nestedModelKeys = nestedModelMap.keySet();
        Stream stream = nestedModelKeys.stream();
        return stream.map(key -> new FormFieldImpl((String)key, required, fieldType, this._getNestedForm((String)key)));
    }

    private <U, V> void _getNestedModelList(Body body, U u, String key, Function<U, Consumer<List<V>>> consumerFunction, boolean required) {
        FormImpl nestedForm = this._getNestedForm(key);
        Optional bodyListOptional = body.getNestedBodyListOptional(key);
        if (bodyListOptional.isPresent()) {
            List bodies = (List)bodyListOptional.get();
            Stream stream = bodies.stream();
            List models = stream.map(nestedBody -> {
                T v = nestedForm._supplier.get();
                this._getFormFields(nestedForm, (Body)nestedBody, (Object)v);
                return v;
            }).collect(Collectors.toList());
            consumerFunction.apply(u).accept(models);
        } else if (required) {
            throw new BadRequestException("Field \"" + key + "\" is required");
        }
    }

    private <U> BiConsumer<String, Function<U, Consumer<Object>>> _getOptionalNestedModel(Body body, U u) {
        return (key, consumerFunction) -> this._getNestedModel(body, u, (String)key, (Function)consumerFunction, false);
    }

    private <U> BiConsumer<String, Function<U, Consumer<List<Object>>>> _getOptionalNestedModelList(Body body, U u) {
        return (key, consumerFunction) -> this._getNestedModelList(body, u, (String)key, (Function)consumerFunction, false);
    }

    private <U> BiConsumer<String, Function<U, Consumer<Object>>> _getRequiredNestedModel(Body body, U u) {
        return (key, consumerFunction) -> this._getNestedModel(body, u, (String)key, (Function)consumerFunction, true);
    }

    private <U> BiConsumer<String, Function<U, Consumer<List<Object>>>> _getRequiredNestedModelList(Body body, U u) {
        return (key, consumerFunction) -> this._getNestedModelList(body, u, (String)key, (Function)consumerFunction, true);
    }

    public static class BuilderImpl<T>
    implements Form.Builder<T>,
    Form.Builder.FieldStep<T>,
    Form.Builder.ConstructorStep<T>,
    Form.Builder.DescriptionStep<T> {
        private final FormImpl<T> _form;

        public static <T> BuilderImpl<T> empty() {
            return new BuilderImpl<T>(Collections.emptyList(), __ -> null);
        }

        public BuilderImpl(List<String> paths, IdentifierFunction<?> pathToIdentifierFunction) {
            this._form = new FormImpl(paths, pathToIdentifierFunction);
        }

        public Form.Builder.FieldStep<T> addOptionalBoolean(String key, BiConsumer<T, Boolean> biConsumer) {
            ((FormImpl)this._form)._optionalBooleans.put(key, t -> aBoolean -> biConsumer.accept((Object)t, (Boolean)aBoolean));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalBooleanList(String key, BiConsumer<T, List<Boolean>> biConsumer) {
            ((FormImpl)this._form)._optionalBooleanLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Boolean>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalDate(String key, BiConsumer<T, Date> biConsumer) {
            ((FormImpl)this._form)._optionalDates.put(key, t -> date -> biConsumer.accept((Object)t, (Date)date));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalDateList(String key, BiConsumer<T, List<Date>> biConsumer) {
            ((FormImpl)this._form)._optionalDateLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Date>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalDouble(String key, BiConsumer<T, Double> biConsumer) {
            ((FormImpl)this._form)._optionalDoubles.put(key, t -> aDouble -> biConsumer.accept((Object)t, (Double)aDouble));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalDoubleList(String key, BiConsumer<T, List<Double>> biConsumer) {
            ((FormImpl)this._form)._optionalDoubleLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Double>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalFile(String key, BiConsumer<T, BinaryFile> biConsumer) {
            ((FormImpl)this._form)._optionalFiles.put(key, t -> binaryFile -> biConsumer.accept((Object)t, (BinaryFile)binaryFile));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalFileList(String key, BiConsumer<T, List<BinaryFile>> biConsumer) {
            ((FormImpl)this._form)._optionalFileLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<BinaryFile>)list));
            return this;
        }

        public <C> Form.Builder.FieldStep<T> addOptionalLinkedModel(String key, Class<? extends Identifier<C>> aClass, BiConsumer<T, C> biConsumer) {
            ((FormImpl)this._form)._optionalLinkedModel.put(key, t -> c -> biConsumer.accept(t, c));
            return this;
        }

        public <C> Form.Builder.FieldStep<T> addOptionalLinkedModelList(String key, Class<? extends Identifier<C>> aClass, BiConsumer<T, List<C>> biConsumer) {
            ((FormImpl)this._form)._optionalLinkedModelList.put(key, t -> c -> biConsumer.accept((Object)t, (List)c));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalLong(String key, BiConsumer<T, Long> biConsumer) {
            ((FormImpl)this._form)._optionalLongs.put(key, t -> aLong -> biConsumer.accept((Object)t, (Long)aLong));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalLongList(String key, BiConsumer<T, List<Long>> biConsumer) {
            ((FormImpl)this._form)._optionalLongLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Long>)list));
            return this;
        }

        public <U> Form.Builder.FieldStep<T> addOptionalNestedModel(String key, FormBuilderFunction<U> formBuilderFunction, BiConsumer<T, U> biConsumer) {
            ((FormImpl)this._form)._optionalNestedModel.put(key, t -> object -> biConsumer.accept(t, object));
            ((FormImpl)this._form)._formBuilderFunctionsMap.put(key, formBuilderFunction);
            return this;
        }

        public <U> Form.Builder.FieldStep<T> addOptionalNestedModelList(String key, FormBuilderFunction<U> formBuilderFunction, BiConsumer<T, List<U>> biConsumer) {
            ((FormImpl)this._form)._optionalNestedModelLists.put(key, t -> list -> biConsumer.accept((Object)t, (List)list));
            ((FormImpl)this._form)._formBuilderFunctionsMap.put(key, formBuilderFunction);
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalString(String key, BiConsumer<T, String> biConsumer) {
            ((FormImpl)this._form)._optionalStrings.put(key, t -> string -> biConsumer.accept((Object)t, (String)string));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalStringList(String key, BiConsumer<T, List<String>> biConsumer) {
            ((FormImpl)this._form)._optionalStringLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<String>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredBoolean(String key, BiConsumer<T, Boolean> biConsumer) {
            ((FormImpl)this._form)._requiredBooleans.put(key, t -> aBoolean -> biConsumer.accept((Object)t, (Boolean)aBoolean));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredBooleanList(String key, BiConsumer<T, List<Boolean>> biConsumer) {
            ((FormImpl)this._form)._requiredBooleanLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Boolean>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredDate(String key, BiConsumer<T, Date> biConsumer) {
            ((FormImpl)this._form)._requiredDates.put(key, t -> date -> biConsumer.accept((Object)t, (Date)date));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredDateList(String key, BiConsumer<T, List<Date>> biConsumer) {
            ((FormImpl)this._form)._requiredDateLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Date>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredDouble(String key, BiConsumer<T, Double> biConsumer) {
            ((FormImpl)this._form)._requiredDoubles.put(key, t -> aDouble -> biConsumer.accept((Object)t, (Double)aDouble));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredDoubleList(String key, BiConsumer<T, List<Double>> biConsumer) {
            ((FormImpl)this._form)._requiredDoubleLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Double>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredFile(String key, BiConsumer<T, BinaryFile> biConsumer) {
            ((FormImpl)this._form)._requiredFiles.put(key, t -> binaryFile -> biConsumer.accept((Object)t, (BinaryFile)binaryFile));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredFileList(String key, BiConsumer<T, List<BinaryFile>> biConsumer) {
            ((FormImpl)this._form)._requiredFileLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<BinaryFile>)list));
            return this;
        }

        public <C> Form.Builder.FieldStep<T> addRequiredLinkedModel(String key, Class<? extends Identifier<C>> aClass, BiConsumer<T, C> biConsumer) {
            ((FormImpl)this._form)._requiredLinkedModel.put(key, t -> c -> biConsumer.accept(t, c));
            return this;
        }

        public <C> Form.Builder.FieldStep<T> addRequiredLinkedModelList(String key, Class<? extends Identifier<C>> aClass, BiConsumer<T, List<C>> biConsumer) {
            ((FormImpl)this._form)._requiredLinkedModelList.put(key, t -> c -> biConsumer.accept((Object)t, (List)c));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredLong(String key, BiConsumer<T, Long> biConsumer) {
            ((FormImpl)this._form)._requiredLongs.put(key, t -> aLong -> biConsumer.accept((Object)t, (Long)aLong));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredLongList(String key, BiConsumer<T, List<Long>> biConsumer) {
            ((FormImpl)this._form)._requiredLongLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Long>)list));
            return this;
        }

        public <U> Form.Builder.FieldStep<T> addRequiredNestedModel(String key, FormBuilderFunction<U> formBuilderFunction, BiConsumer<T, U> biConsumer) {
            ((FormImpl)this._form)._requiredNestedModel.put(key, t -> object -> biConsumer.accept(t, object));
            ((FormImpl)this._form)._formBuilderFunctionsMap.put(key, formBuilderFunction);
            return this;
        }

        public <U> Form.Builder.FieldStep<T> addRequiredNestedModelList(String key, FormBuilderFunction<U> formBuilderFunction, BiConsumer<T, List<U>> biConsumer) {
            ((FormImpl)this._form)._optionalNestedModelLists.put(key, t -> list -> biConsumer.accept((Object)t, (List)list));
            ((FormImpl)this._form)._formBuilderFunctionsMap.put(key, formBuilderFunction);
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredString(String key, BiConsumer<T, String> biConsumer) {
            ((FormImpl)this._form)._requiredStrings.put(key, t -> string -> biConsumer.accept((Object)t, (String)string));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredStringList(String key, BiConsumer<T, List<String>> biConsumer) {
            ((FormImpl)this._form)._requiredStringLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<String>)list));
            return this;
        }

        public Form<T> build() {
            return this._form;
        }

        public Form.Builder.FieldStep<T> constructor(Supplier<T> supplier) {
            ((FormImpl)this._form)._supplier = supplier;
            return this;
        }

        public Form.Builder.ConstructorStep<T> description(Function<AcceptLanguage, String> descriptionFunction) {
            ((FormImpl)this._form)._descriptionFunction = descriptionFunction;
            return this;
        }

        public Form.Builder.DescriptionStep<T> title(Function<AcceptLanguage, String> titleFunction) {
            ((FormImpl)this._form)._titleFunction = titleFunction;
            return this;
        }
    }
}

