/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.writer;

import com.liferay.apio.architect.alias.representor.FieldFunction;
import com.liferay.apio.architect.alias.representor.NestedListFieldFunction;
import com.liferay.apio.architect.consumer.TriConsumer;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.alias.BaseRepresentorFunction;
import com.liferay.apio.architect.internal.alias.PathFunction;
import com.liferay.apio.architect.internal.alias.SingleModelFunction;
import com.liferay.apio.architect.internal.list.FunctionalList;
import com.liferay.apio.architect.internal.request.RequestInfo;
import com.liferay.apio.architect.internal.response.control.Embedded;
import com.liferay.apio.architect.internal.response.control.Fields;
import com.liferay.apio.architect.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.internal.url.URLCreator;
import com.liferay.apio.architect.related.RelatedCollection;
import com.liferay.apio.architect.related.RelatedModel;
import com.liferay.apio.architect.representor.BaseRepresentor;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.uri.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldsWriter<T> {
    private final BaseRepresentor<T> _baseRepresentor;
    private final FunctionalList<String> _embeddedPathElements;
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private final Path _path;
    private final PathFunction _pathFunction;
    private final RequestInfo _requestInfo;
    private final SingleModel<T> _singleModel;
    private final SingleModelFunction _singleModelFunction;

    public static <T, S, U> Optional<SingleModel<U>> getSingleModel(RelatedModel<T, S> relatedModel, SingleModel<T> parentSingleModel, SingleModelFunction singleModelFunction) {
        Function modelToIdentifierFunction = relatedModel.getModelToIdentifierFunction();
        return modelToIdentifierFunction.andThen(s -> (Optional)singleModelFunction.apply(s, relatedModel.getIdentifierClass())).apply(parentSingleModel.getModel()).map(Unsafe::unsafeCast);
    }

    public FieldsWriter(SingleModel<T> singleModel, RequestInfo requestInfo, BaseRepresentor<T> baseRepresentor, Path path, FunctionalList<String> embeddedPathElements, SingleModelFunction singleModelFunction, PathFunction pathFunction) {
        this._singleModel = singleModel;
        this._requestInfo = requestInfo;
        this._baseRepresentor = baseRepresentor;
        this._path = path;
        this._embeddedPathElements = embeddedPathElements;
        this._singleModelFunction = singleModelFunction;
        this._pathFunction = pathFunction;
    }

    public Predicate<String> getFieldsPredicate() {
        Fields fields = this._requestInfo.getFields();
        return (Predicate)fields.apply(this._baseRepresentor.getTypes());
    }

    public void writeApplicationRelativeURLFields(BiConsumer<String, String> biConsumer) {
        this.writeFields(BaseRepresentor::getApplicationRelativeURLFunctions, this.writeField(relativeURL -> URLCreator.createAbsoluteURL(this._requestInfo.getApplicationURL(), relativeURL), biConsumer));
    }

    public void writeBinaries(BiConsumer<String, String> biConsumer) {
        Function<String, String> urlFunction = binaryId -> URLCreator.createBinaryURL(this._requestInfo.getApplicationURL(), binaryId, this._path);
        this.writeFields(BaseRepresentor::getBinaryFunctions, (key, binaryFile) -> biConsumer.accept((String)key, (String)urlFunction.apply((String)key)));
    }

    public void writeBooleanFields(BiConsumer<String, Boolean> biConsumer) {
        this.writeFields(BaseRepresentor::getBooleanFunctions, this.writeField(biConsumer));
    }

    public void writeBooleanListFields(BiConsumer<String, List<Boolean>> biConsumer) {
        this.writeFields(BaseRepresentor::getBooleanListFunctions, this.writeField(biConsumer));
    }

    public <U> BiConsumer<String, U> writeField(BiConsumer<String, U> biConsumer) {
        return this.writeField(Function.identity(), biConsumer);
    }

    public <U, V> BiConsumer<String, U> writeField(Function<U, V> function, BiConsumer<String, V> biConsumer) {
        return (key, u) -> {
            Object data = function.apply(u);
            if (data instanceof String) {
                if (data != null && !((String)data).isEmpty()) {
                    biConsumer.accept((String)key, (Object)data);
                }
            } else if (data != null) {
                biConsumer.accept((String)key, (Object)data);
            }
        };
    }

    public <U> void writeFields(Function<BaseRepresentor<T>, List<FieldFunction<T, U>>> representorFunction, BiConsumer<String, U> biConsumer) {
        List<FieldFunction<T, U>> list = representorFunction.apply(this._baseRepresentor);
        Stream stream = list.stream();
        stream.filter(fieldFunction -> {
            Predicate<String> fieldsPredicate = this.getFieldsPredicate();
            return fieldsPredicate.test(fieldFunction.getKey());
        }).forEach(fieldFunction -> this._tryToWriteField(fieldFunction.getKey(), key -> {
            Object u = fieldFunction.apply(this._singleModel.getModel());
            biConsumer.accept((String)key, (Object)u);
        }));
    }

    public void writeLinks(BiConsumer<String, String> biConsumer) {
        this.writeFields(BaseRepresentor::getLinkFunctions, this.writeField(Function.identity(), biConsumer));
    }

    public void writeLocalizedStringFields(BiConsumer<String, String> biConsumer) {
        this.writeFields(BaseRepresentor::getLocalizedStringFunctions, this.writeField(function -> (String)function.apply(this._requestInfo.getAcceptLanguage()), biConsumer));
    }

    public <S> void writeNestedLists(BaseRepresentorFunction baseRepresentorFunction, SingleModel<S> singleModel, BiConsumer<NestedListFieldFunction, List<?>> biConsumer) {
        ((Optional)baseRepresentorFunction.apply(singleModel.getResourceName())).map(Unsafe::unsafeCast).map(BaseRepresentor::getNestedListFieldFunctions).map(Collection::stream).orElseGet(Stream::empty).forEach(nestedListFieldFunction -> {
            String key;
            Predicate<String> fieldsPredicate = this.getFieldsPredicate();
            if (!fieldsPredicate.test(key = nestedListFieldFunction.getKey())) {
                return;
            }
            List list = (List)nestedListFieldFunction.apply(singleModel.getModel());
            if (list == null) {
                return;
            }
            biConsumer.accept((NestedListFieldFunction)nestedListFieldFunction, list);
        });
    }

    public <S, U> void writeNestedResources(BaseRepresentorFunction baseRepresentorFunction, SingleModel<U> singleModel, FunctionalList<String> embeddedPathElements, TriConsumer<SingleModel<S>, FunctionalList<String>, BaseRepresentorFunction> triConsumer) {
        ((Optional)baseRepresentorFunction.apply(singleModel.getResourceName())).map(Unsafe::unsafeCast).map(BaseRepresentor::getNestedFieldFunctions).map(Collection::stream).orElseGet(Stream::empty).forEach(nestedFieldFunction -> {
            String key;
            Predicate<String> fieldsPredicate = this.getFieldsPredicate();
            if (!fieldsPredicate.test(key = nestedFieldFunction.getKey())) {
                return;
            }
            Object mappedModel = nestedFieldFunction.apply(singleModel.getModel());
            if (mappedModel == null) {
                return;
            }
            FunctionalList<String> embeddedNestedPathElements = new FunctionalList<String>(embeddedPathElements, nestedFieldFunction.getKey());
            SingleModelImpl<Object> nestedSingleModel = new SingleModelImpl<Object>(mappedModel, "", Collections.emptyList());
            BaseRepresentorFunction nestedRepresentorFunction = __ -> Optional.of(nestedFieldFunction.getNestedRepresentor());
            triConsumer.accept(nestedSingleModel, embeddedNestedPathElements, (Object)nestedRepresentorFunction);
        });
    }

    public void writeNumberFields(BiConsumer<String, Number> biConsumer) {
        this.writeFields(BaseRepresentor::getNumberFunctions, this.writeField(biConsumer));
    }

    public void writeNumberListFields(BiConsumer<String, List<Number>> biConsumer) {
        this.writeFields(BaseRepresentor::getNumberListFunctions, this.writeField(biConsumer));
    }

    public <U extends Identifier> void writeRelatedCollection(RelatedCollection<T, U> relatedCollection, String resourceName, FunctionalList<String> parentEmbeddedPathElements, BiConsumer<String, FunctionalList<String>> biConsumer) {
        String key;
        Predicate<String> fieldsPredicate = this.getFieldsPredicate();
        if (!fieldsPredicate.test(key = relatedCollection.getKey())) {
            return;
        }
        Path path = (Path)Try.fromFallible(() -> relatedCollection.getModelToIdentifierFunction()).map(function -> function.apply(this._singleModel.getModel())).map(model -> (Optional)this._pathFunction.apply(resourceName, model)).map(Optional::get).orElse((Object)this._path);
        this._writeCollectionPath(resourceName, parentEmbeddedPathElements, biConsumer, key, path);
    }

    public void writeRelatedCollections(Function<String, Optional<String>> nameFunction, BiConsumer<String, FunctionalList<String>> biConsumer) {
        BaseRepresentor<T> representor = this._baseRepresentor;
        Stream stream = representor.getRelatedCollections();
        stream.forEach(relatedCollection -> {
            Class identifierClass = relatedCollection.getIdentifierClass();
            Optional optional = (Optional)nameFunction.apply(identifierClass.getName());
            optional.ifPresent(name -> this.writeRelatedCollection((RelatedCollection)relatedCollection, (String)name, this._embeddedPathElements, biConsumer));
        });
    }

    public <U> void writeRelatedModel(RelatedModel<T, U> relatedModel, PathFunction pathFunction, BiConsumer<SingleModel<?>, FunctionalList<String>> modelBiConsumer, BiConsumer<String, FunctionalList<String>> linkedURLBiConsumer, BiConsumer<String, FunctionalList<String>> embeddedURLBiConsumer) {
        this.writeRelatedModel(relatedModel, pathFunction, (url, embeddedPathElements) -> {
            Stream stream;
            String embeddedPath;
            Embedded embedded = this._requestInfo.getEmbedded();
            if (embedded.test(embeddedPath = String.join((CharSequence)".", (stream = Stream.concat(Stream.of(embeddedPathElements.head()), embeddedPathElements.tailStream())).collect(Collectors.toList())))) {
                Optional singleModelOptional = FieldsWriter.getSingleModel(relatedModel, this._singleModel, (SingleModelFunction)Unsafe.unsafeCast(this._singleModelFunction));
                if (!singleModelOptional.isPresent()) {
                    return;
                }
                SingleModel singleModel = singleModelOptional.get();
                embeddedURLBiConsumer.accept((String)url, (FunctionalList<String>)embeddedPathElements);
                modelBiConsumer.accept(singleModel, (FunctionalList<String>)embeddedPathElements);
            } else {
                linkedURLBiConsumer.accept((String)url, (FunctionalList<String>)embeddedPathElements);
            }
        });
    }

    public <U> void writeRelatedModel(RelatedModel<T, U> relatedModel, PathFunction pathFunction, BiConsumer<String, FunctionalList<String>> biConsumer) {
        String key;
        Predicate<String> fieldsPredicate = this.getFieldsPredicate();
        if (!fieldsPredicate.test(key = relatedModel.getKey())) {
            return;
        }
        FunctionalList<String> embeddedPathElements = new FunctionalList<String>(this._embeddedPathElements, key);
        Function modelToIdentifierFunction = relatedModel.getModelToIdentifierFunction();
        Object relatedIdentifier = modelToIdentifierFunction.apply(this._singleModel.getModel());
        if (relatedIdentifier == null) {
            return;
        }
        ((Optional)pathFunction.apply(relatedModel.getIdentifierName(), relatedIdentifier)).map(path -> URLCreator.createSingleURL(this._requestInfo.getApplicationURL(), path)).ifPresent(url -> this._tryToWriteField(key, __ -> biConsumer.accept((String)url, embeddedPathElements)));
    }

    public void writeRelatedModels(PathFunction pathFunction, BiConsumer<SingleModel<?>, FunctionalList<String>> modelBiConsumer, BiConsumer<String, FunctionalList<String>> linkedURLBiConsumer, BiConsumer<String, FunctionalList<String>> embeddedURLBiConsumer) {
        List embeddedRelatedModels = this._baseRepresentor.getRelatedModels();
        embeddedRelatedModels.forEach(relatedModel -> this.writeRelatedModel((RelatedModel)relatedModel, pathFunction, modelBiConsumer, linkedURLBiConsumer, embeddedURLBiConsumer));
    }

    public void writeRelativeURLFields(BiConsumer<String, String> biConsumer) {
        this.writeFields(BaseRepresentor::getRelativeURLFunctions, this.writeField(relativeURL -> URLCreator.createAbsoluteURL(this._requestInfo.getServerURL(), relativeURL), biConsumer));
    }

    public void writeSingleURL(Consumer<String> urlConsumer) {
        String url = URLCreator.createSingleURL(this._requestInfo.getApplicationURL(), this._path);
        urlConsumer.accept(url);
    }

    public void writeStringFields(BiConsumer<String, String> biConsumer) {
        this.writeFields(BaseRepresentor::getStringFunctions, this.writeField(biConsumer));
    }

    public void writeStringListFields(BiConsumer<String, List<String>> biConsumer) {
        this.writeFields(BaseRepresentor::getStringListFunctions, this.writeField(biConsumer));
    }

    public void writeTypes(Consumer<List<String>> consumer) {
        consumer.accept(this._baseRepresentor.getTypes());
    }

    private void _tryToWriteField(String key, Consumer<String> consumer) {
        block2: {
            try {
                consumer.accept(key);
            }
            catch (Exception e) {
                if (!this._logger.isDebugEnabled()) break block2;
                this._logger.debug("Unable to write field" + key, (Throwable)e);
            }
        }
    }

    private void _writeCollectionPath(String resourceName, FunctionalList<String> parentEmbeddedPathElements, BiConsumer<String, FunctionalList<String>> biConsumer, String key, Path path) {
        String url = URLCreator.createNestedCollectionURL(this._requestInfo.getApplicationURL(), path, resourceName);
        FunctionalList<String> embeddedPathElements = new FunctionalList<String>(parentEmbeddedPathElements, key);
        this._tryToWriteField(key, __ -> biConsumer.accept(url, embeddedPathElements));
    }
}

