/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.writer;

import com.liferay.apio.architect.internal.entrypoint.EntryPoint;
import com.liferay.apio.architect.internal.message.json.EntryPointMessageMapper;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.request.RequestInfo;
import com.liferay.apio.architect.internal.url.ApplicationURL;
import com.liferay.apio.architect.internal.url.URLCreator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class EntryPointWriter {
    private final EntryPoint _entryPoint;
    private final EntryPointMessageMapper _entryPointMessageMapper;
    private final JSONObjectBuilder _jsonObjectBuilder;
    private final RequestInfo _requestInfo;
    private final Function<String, Optional<String>> _typeFunction;

    public String write() {
        ApplicationURL applicationURL = this._requestInfo.getApplicationURL();
        this._entryPointMessageMapper.mapSelfURL(this._jsonObjectBuilder, (String)applicationURL.get());
        List<String> resourceNames = this._entryPoint.getResourceNames();
        for (String resourceName : resourceNames) {
            JSONObjectBuilder itemJsonObjectBuilder = new JSONObjectBuilder();
            String url = URLCreator.createCollectionURL(applicationURL, resourceName);
            this._entryPointMessageMapper.mapItemSelfURL(this._jsonObjectBuilder, itemJsonObjectBuilder, resourceName, url);
            this._getCollectionItemType(resourceName, itemJsonObjectBuilder);
            this._entryPointMessageMapper.onFinishItem(this._jsonObjectBuilder, itemJsonObjectBuilder);
        }
        this._entryPointMessageMapper.onFinish(this._jsonObjectBuilder, this._entryPoint);
        return this._jsonObjectBuilder.build();
    }

    private EntryPointWriter(EntryPoint entryPoint, EntryPointMessageMapper entryPointMessageMapper, RequestInfo requestInfo, Function<String, Optional<String>> typeFunction) {
        this._entryPoint = entryPoint;
        this._entryPointMessageMapper = entryPointMessageMapper;
        this._requestInfo = requestInfo;
        this._typeFunction = typeFunction;
        this._jsonObjectBuilder = new JSONObjectBuilder();
    }

    private void _getCollectionItemType(String resourceName, JSONObjectBuilder itemJsonObjectBuilder) {
        this._typeFunction.apply(resourceName).ifPresent(type -> this._entryPointMessageMapper.mapSemantics(itemJsonObjectBuilder, (String)type));
    }

    public static interface Builder {
        public static EntryPointMessageMapperStep entryPoint(EntryPoint entryPoint) {
            return entryPointMessageMapper -> requestInfo -> typeFunction -> () -> new EntryPointWriter(entryPoint, entryPointMessageMapper, requestInfo, typeFunction);
        }

        public static interface TypeFunctionStep {
            public BuildStep typeFunction(Function<String, Optional<String>> var1);
        }

        public static interface RequestInfoStep {
            public TypeFunctionStep requestInfo(RequestInfo var1);
        }

        public static interface EntryPointMessageMapperStep {
            public RequestInfoStep entryPointMessageMapper(EntryPointMessageMapper var1);
        }

        public static interface BuildStep {
            public EntryPointWriter build();
        }
    }
}

