/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.validator;

import com.liferay.apio.architect.internal.wiring.osgi.validator.NameValidator;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;

@Component(service={NameValidator.class})
public class NameValidatorImpl
implements NameValidator {
    private static final String _VALID_CHARACTERS_REGEX = "[a-zA-Z-]+";

    @Override
    public String getValidationError() {
        return "Name cannot be null and can only contains alphabetic characters and hyphens";
    }

    @Override
    public boolean validate(String name) {
        return Optional.ofNullable(name).map(string -> string.matches(_VALID_CHARACTERS_REGEX)).orElse(false);
    }
}

