/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.resource;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.wiring.osgi.manager.util.ManagerUtil;
import com.liferay.apio.architect.representor.Representable;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.router.ItemRouter;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={})
public class NestedCollectionResourceRegistrar {
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private ServiceTracker<NestedCollectionResource, ServiceRegistration<?>> _serviceTracker;

    @Activate
    protected void activate(BundleContext bundleContext) {
        String[] classes = new String[]{ItemRouter.class.getName(), NestedCollectionRouter.class.getName(), Representable.class.getName()};
        this._serviceTracker = ManagerUtil.createServiceTracker(bundleContext, NestedCollectionResource.class, classes, (properties, service) -> {
            Try identifierClassTry = ManagerUtil.getTypeParamTry(service, NestedCollectionResource.class, 2);
            identifierClassTry.voidFold(__ -> this._logger.warn("Unable to get identifier class from {}", service.getClass()), clazz -> properties.put("apio.architect.principal.type.argument", clazz));
            Try parentClassTry = ManagerUtil.getTypeParamTry(service, NestedCollectionResource.class, 4);
            parentClassTry.voidFold(__ -> this._logger.warn("Unable to get parent identifier class from {}", service.getClass()), clazz -> properties.put("apio.architect.parent.identifier.class", clazz));
        });
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }
}

