/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.resource;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.wiring.osgi.manager.util.ManagerUtil;
import com.liferay.apio.architect.representor.Representable;
import com.liferay.apio.architect.resource.ItemResource;
import com.liferay.apio.architect.router.ItemRouter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={})
public class ItemResourceRegistrar {
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private ServiceTracker<ItemResource, ServiceRegistration<?>> _serviceTracker;

    @Activate
    protected void activate(BundleContext bundleContext) {
        String[] classes = new String[]{ItemRouter.class.getName(), Representable.class.getName()};
        this._serviceTracker = ManagerUtil.createServiceTracker(bundleContext, ItemResource.class, classes, (properties, service) -> {
            Try classTry = ManagerUtil.getTypeParamTry(service, ItemResource.class, 2);
            classTry.voidFold(__ -> this._logger.warn("Unable to get identifier class from {}", service.getClass()), clazz -> properties.put("apio.architect.principal.type.argument", clazz));
        });
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }
}

