/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.util;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.internal.wiring.osgi.util.GenericUtil;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class ManagerUtil {
    public static <T> ServiceTracker<T, ServiceRegistration<?>> createServiceTracker(BundleContext bundleContext, Class<T> clazz, String[] classes, BiConsumer<Dictionary<String, Object>, T> biConsumer) {
        return new ServiceTracker(bundleContext, clazz, serviceReference -> {
            Dictionary<String, Object> properties = ManagerUtil.getProperties(serviceReference);
            Object t = Try.fromFallible(() -> bundleContext.getService(serviceReference)).orElse(null);
            if (t == null) {
                return null;
            }
            biConsumer.accept(properties, t);
            return bundleContext.registerService(classes, t, properties);
        });
    }

    public static <T> Try<Class<T>> getGenericClassFromProperty(ServiceReference serviceReference, String typeArgumentProperty) {
        return Try.success((Object)typeArgumentProperty).map(arg_0 -> ((ServiceReference)serviceReference).getProperty(arg_0)).filter(Objects::nonNull).map(Unsafe::unsafeCast);
    }

    public static <T> Dictionary<String, Object> getProperties(ServiceReference<T> serviceReference) {
        String[] propertyKeys;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (String propertyKey : propertyKeys = serviceReference.getPropertyKeys()) {
            ((Dictionary)properties).put(propertyKey, serviceReference.getProperty(propertyKey));
        }
        return properties;
    }

    public static <T, U> Try<Class<U>> getTypeParamTry(T t, Class<T> interfaceClass, int position) {
        return Try.fromFallible(() -> GenericUtil.getGenericTypeArgumentTry(t.getClass(), interfaceClass, position)).flatMap(classTry -> classTry).map(Unsafe::unsafeCast);
    }
}

