/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.uri.mapper;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.internal.wiring.osgi.error.ApioDeveloperError;
import com.liferay.apio.architect.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.IdentifierClassManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.uri.mapper.PathIdentifierMapperManager;
import com.liferay.apio.architect.internal.wiring.osgi.util.GenericUtil;
import com.liferay.apio.architect.router.ReusableNestedCollectionRouter;
import com.liferay.apio.architect.uri.Path;
import com.liferay.apio.architect.uri.mapper.PathIdentifierMapper;
import java.util.Optional;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PathIdentifierMapperManager.class})
public class PathIdentifierMapperManagerImpl
extends ClassNameBaseManager<PathIdentifierMapper>
implements PathIdentifierMapperManager {
    @Reference
    private IdentifierClassManager _identifierClassManager;

    public PathIdentifierMapperManagerImpl() {
        super(PathIdentifierMapper.class, 0);
    }

    @Override
    public boolean hasPathIdentifierMapper(String name) {
        return this._getPathIdentifierMapperTry(name).isSuccess();
    }

    @Override
    public <T> T mapToIdentifierOrFail(Path path) {
        return this.mapToIdentifierOrFail(path, null);
    }

    @Override
    public <T, R> T mapToIdentifierOrFail(Path path, ClassNameBaseManager<R> classNameBaseManager) {
        Try<PathIdentifierMapper<T>> pathIdentifierMapperTry = this._getPathIdentifierMapperTry(path.getName());
        return (T)pathIdentifierMapperTry.map(service -> service.map(path)).orElseGet(() -> this._getReusablePathIdentifierMapper(path, classNameBaseManager));
    }

    @Override
    public <T> Optional<Path> mapToPath(String name, T identifier) {
        return this.mapToPath(name, identifier, null);
    }

    @Override
    public <R, T> Optional<Path> mapToPath(String name, T identifier, ClassNameBaseManager<R> classNameBaseManager) {
        Try<PathIdentifierMapper<T>> pathIdentifierMapperTry = this._getPathIdentifierMapperTry(name);
        Path value = (Path)pathIdentifierMapperTry.map(service -> service.map(name, identifier)).orElseGet(() -> this._getReusablePath(name, identifier, classNameBaseManager));
        return Optional.ofNullable(value);
    }

    private <T, R> Try<Class<T>> _getClassTry(Class clazz, ClassNameBaseManager<R> classNameBaseManager) {
        Optional<R> serviceOptional = classNameBaseManager.getServiceOptional(clazz);
        return serviceOptional.map(o -> GenericUtil.getGenericTypeArgumentTry(o.getClass(), ReusableNestedCollectionRouter.class, 3)).orElse(null);
    }

    private <T> Try<PathIdentifierMapper<T>> _getPathIdentifierMapperTry(String name) {
        return this._getPathIdentifierMapperTry(name, clazz -> GenericUtil.getGenericTypeArgumentTry(clazz, Identifier.class, 0));
    }

    private <T> Try<PathIdentifierMapper<T>> _getPathIdentifierMapperTry(String name, Function<Class, Try<Class<T>>> function) {
        return Try.success((Object)name).mapOptional(this._identifierClassManager::getIdentifierClassOptional).flatMap(function::apply).mapOptional(this::getServiceOptional).map(Unsafe::unsafeCast);
    }

    private <R, T> Path _getReusablePath(String name, T identifier, ClassNameBaseManager<R> classNameBaseManager) {
        Try<PathIdentifierMapper<T>> pathIdentifierMapperTry = this._getPathIdentifierMapperTry(name, clazz -> this._getClassTry((Class)clazz, classNameBaseManager));
        return (Path)pathIdentifierMapperTry.map(pathIdentifierMapper -> pathIdentifierMapper.map(name, identifier)).orElse(null);
    }

    private <R, T> T _getReusablePathIdentifierMapper(Path path, ClassNameBaseManager<R> classNameBaseManager) {
        Try<PathIdentifierMapper<T>> pathIdentifierMapperTry = this._getPathIdentifierMapperTry(path.getName(), clazz -> this._getClassTry((Class)clazz, classNameBaseManager));
        return (T)pathIdentifierMapperTry.map(service -> service.map(path)).orElseThrow(() -> new ApioDeveloperError.MustHavePathIdentifierMapper(path));
    }
}

