/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.router;

import com.liferay.apio.architect.internal.alias.ProvideFunction;
import com.liferay.apio.architect.internal.routes.NestedCollectionRoutesImpl;
import com.liferay.apio.architect.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.cache.ManagerCache;
import com.liferay.apio.architect.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.NameManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.RepresentableManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.ItemRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.ReusableNestedCollectionRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.uri.mapper.PathIdentifierMapperManager;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.router.ReusableNestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.apio.architect.uri.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ReusableNestedCollectionRouterManager.class})
public class ReusableNestedCollectionRouterManagerImpl
extends ClassNameBaseManager<ReusableNestedCollectionRouter>
implements ReusableNestedCollectionRouterManager {
    @Reference
    private ItemRouterManager _itemRouterManager;
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private NameManager _nameManager;
    @Reference
    private PathIdentifierMapperManager _pathIdentifierMapperManager;
    @Reference
    private ProviderManager _providerManager;
    @Reference
    private RepresentableManager _representableManager;

    public ReusableNestedCollectionRouterManagerImpl() {
        super(ReusableNestedCollectionRouter.class, 2);
    }

    @Override
    public Map<String, NestedCollectionRoutes> getReusableCollectionRoutes() {
        return ManagerCache.INSTANCE.getReusableCollectionRoutesMap(this::_computeNestedCollectionRoutes);
    }

    @Override
    public Optional<NestedCollectionRoutes> getReusableCollectionRoutesOptional(String name) {
        return ManagerCache.INSTANCE.getReusableNestedCollectionRoutesOptional(name, this::_computeNestedCollectionRoutes);
    }

    private void _computeNestedCollectionRoutes() {
        this.forEachService((className, reusableNestedCollectionRouter) -> {
            Optional<String> nameOptional = this._nameManager.getNameOptional((String)className);
            if (!nameOptional.isPresent()) {
                if (this._logger.isWarnEnabled()) {
                    this._logger.warn("Unable to find a Representable for class name " + className);
                }
                return;
            }
            String name = nameOptional.get();
            TreeSet<String> neededProviders = new TreeSet<String>();
            Optional representorOptional = this._representableManager.getRepresentorOptional(name);
            Representor representor = representorOptional.get();
            NestedCollectionRoutesImpl.BuilderImpl<Object, Object, Object> builder = new NestedCollectionRoutesImpl.BuilderImpl<Object, Object, Object>("r", name, ProvideFunction.curry(this._providerManager::provideMandatory), neededProviders::add, path -> this._pathIdentifierMapperManager.mapToIdentifierOrFail((Path)path), identifier -> this._pathIdentifierMapperManager.mapToPath(name, identifier, this), arg_0 -> representor.getIdentifier(arg_0));
            NestedCollectionRoutes nestedCollectionRoutes = reusableNestedCollectionRouter.collectionRoutes(builder);
            List<String> missingProviders = this._providerManager.getMissingProviders(neededProviders);
            if (!missingProviders.isEmpty()) {
                if (this._logger.isWarnEnabled()) {
                    this._logger.warn("Missing providers for classes: " + missingProviders);
                }
                return;
            }
            Optional optional = this._itemRouterManager.getItemRoutesOptional(name);
            if (!optional.isPresent()) {
                if (this._logger.isWarnEnabled()) {
                    this._logger.warn("Missing item router for resource with name " + name);
                }
                return;
            }
            ManagerCache.INSTANCE.putReusableNestedCollectionRoutes(name, nestedCollectionRoutes);
        });
    }
}

