/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.router;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.alias.ProvideFunction;
import com.liferay.apio.architect.internal.routes.NestedCollectionRoutesImpl;
import com.liferay.apio.architect.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.cache.ManagerCache;
import com.liferay.apio.architect.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.NameManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.RepresentableManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.ItemRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.NestedCollectionRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.uri.mapper.PathIdentifierMapperManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.util.ManagerUtil;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={NestedCollectionRouterManager.class})
public class NestedCollectionRouterManagerImpl
extends ClassNameBaseManager<NestedCollectionRouter>
implements NestedCollectionRouterManager {
    @Reference
    private ItemRouterManager _itemRouterManager;
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private NameManager _nameManager;
    @Reference
    private PathIdentifierMapperManager _pathIdentifierMapperManager;
    @Reference
    private ProviderManager _providerManager;
    @Reference
    private RepresentableManager _representableManager;

    public NestedCollectionRouterManagerImpl() {
        super(NestedCollectionRouter.class, 2);
    }

    @Override
    public Map<String, NestedCollectionRoutes> getNestedCollectionRoutes() {
        return ManagerCache.INSTANCE.getNestedCollectionRoutesMap(this::_computeNestedCollectionRoutes);
    }

    @Override
    public <T, S, U> Optional<NestedCollectionRoutes<T, S, U>> getNestedCollectionRoutesOptional(String name, String nestedName) {
        return ManagerCache.INSTANCE.getNestedCollectionRoutesOptional(name, nestedName, this::_computeNestedCollectionRoutes);
    }

    @Override
    protected void emit(ServiceReference<NestedCollectionRouter> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
        NestedCollectionRouter nestedCollectionRouter = (NestedCollectionRouter)this.bundleContext.getService(serviceReference);
        if (nestedCollectionRouter == null) {
            return;
        }
        Try identifierClassTry = ManagerUtil.getGenericClassFromProperty(serviceReference, "apio.architect.principal.type.argument");
        Try parentClassTry = ManagerUtil.getGenericClassFromProperty(serviceReference, "apio.architect.parent.identifier.class");
        identifierClassTry.recoverWith(__ -> ManagerUtil.getTypeParamTry(nestedCollectionRouter, NestedCollectionRouter.class, 2)).map(Class::getName).flatMap(identifierClassName -> parentClassTry.recoverWith(__ -> ManagerUtil.getTypeParamTry(nestedCollectionRouter, NestedCollectionRouter.class, 4)).map(Class::getName).map(parentClassName -> parentClassName + "-" + identifierClassName)).voidFold(__ -> this._logger.warn("Unable to get generic information from {}", nestedCollectionRouter.getClass()), arg_0 -> emitter.emit(arg_0));
    }

    private void _computeNestedCollectionRoutes() {
        this.forEachService((key, nestedCollectionRouter) -> {
            String[] classNames = key.split("-");
            if (classNames.length != 2) {
                return;
            }
            String parentClassName = classNames[0];
            String nestedClassName = classNames[1];
            Optional<String> nameOptional = this._nameManager.getNameOptional(parentClassName);
            if (!nameOptional.isPresent()) {
                this._logger.warn("Unable to find a Representable for parent class name {}", (Object)parentClassName);
                return;
            }
            String name = nameOptional.get();
            Optional<String> nestedNameOptional = this._nameManager.getNameOptional(nestedClassName);
            if (!nestedNameOptional.isPresent()) {
                this._logger.warn("Unable to find a Representable for nested class name {}", (Object)nestedClassName);
                return;
            }
            String nestedName = nestedNameOptional.get();
            Optional representorOptional = this._representableManager.getRepresentorOptional(nestedName);
            if (!representorOptional.isPresent()) {
                this._logger.warn("Unable to find a Representable for nested class name " + nestedClassName);
                return;
            }
            Representor representor = representorOptional.get();
            Optional nestedItemRoutes = this._itemRouterManager.getItemRoutesOptional(nestedName);
            if (!nestedItemRoutes.isPresent()) {
                this._logger.warn("Missing item router for resource with name {}", (Object)nestedName);
                return;
            }
            Optional parentItemRoutes = this._itemRouterManager.getItemRoutesOptional(name);
            if (!parentItemRoutes.isPresent()) {
                this._logger.warn("Missing item router for resource with name {}", (Object)name);
                return;
            }
            TreeSet<String> neededProviders = new TreeSet<String>();
            NestedCollectionRoutesImpl.BuilderImpl<Object, Object, Object> builder = new NestedCollectionRoutesImpl.BuilderImpl<Object, Object, Object>(name, nestedName, ProvideFunction.curry(this._providerManager::provideMandatory), neededProviders::add, this._pathIdentifierMapperManager::mapToIdentifierOrFail, identifier -> this._pathIdentifierMapperManager.mapToPath(name, identifier), arg_0 -> representor.getIdentifier(arg_0));
            NestedCollectionRoutes nestedCollectionRoutes = nestedCollectionRouter.collectionRoutes(builder);
            List<String> missingProviders = this._providerManager.getMissingProviders(neededProviders);
            if (!missingProviders.isEmpty()) {
                this._logger.warn("Missing providers for classes: {}", missingProviders);
                return;
            }
            ManagerCache.INSTANCE.putNestedCollectionRoutes(name + "-" + nestedName, nestedCollectionRoutes);
        });
    }
}

