/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.router;

import com.liferay.apio.architect.internal.alias.ProvideFunction;
import com.liferay.apio.architect.internal.routes.ItemRoutesImpl;
import com.liferay.apio.architect.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.cache.ManagerCache;
import com.liferay.apio.architect.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.NameManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.ItemRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.uri.mapper.PathIdentifierMapperManager;
import com.liferay.apio.architect.router.ItemRouter;
import com.liferay.apio.architect.routes.ItemRoutes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ItemRouterManager.class})
public class ItemRouterManagerImpl
extends ClassNameBaseManager<ItemRouter>
implements ItemRouterManager {
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private NameManager _nameManager;
    @Reference
    private PathIdentifierMapperManager _pathIdentifierMapperManager;
    @Reference
    private ProviderManager _providerManager;

    public ItemRouterManagerImpl() {
        super(ItemRouter.class, 2);
    }

    @Override
    public Map<String, ItemRoutes> getItemRoutes() {
        return ManagerCache.INSTANCE.getItemRoutesMap(this::_computeItemRoutes);
    }

    @Override
    public <T, S> Optional<ItemRoutes<T, S>> getItemRoutesOptional(String name) {
        return ManagerCache.INSTANCE.getItemRoutesOptional(name, this::_computeItemRoutes);
    }

    private void _computeItemRoutes() {
        this.forEachService((className, itemRouter) -> {
            Optional<String> nameOptional = this._nameManager.getNameOptional((String)className);
            if (!nameOptional.isPresent()) {
                this._logger.warn("Unable to find a Representable for class name {}", className);
                return;
            }
            String name = nameOptional.get();
            boolean hasPathIdentifierMapper = this._pathIdentifierMapperManager.hasPathIdentifierMapper(name);
            if (!hasPathIdentifierMapper) {
                this._logger.warn("Missing path identifier mapper for resource with name {}", (Object)name);
                return;
            }
            TreeSet<String> neededProviders = new TreeSet<String>();
            ItemRoutesImpl.BuilderImpl builder = new ItemRoutesImpl.BuilderImpl(name, ProvideFunction.curry(this._providerManager::provideMandatory), neededProviders::add, this._pathIdentifierMapperManager::mapToIdentifierOrFail, identifier -> this._pathIdentifierMapperManager.mapToPath(name, identifier), this._nameManager::getNameOptional);
            ItemRoutes itemRoutes = itemRouter.itemRoutes(builder);
            List<String> missingProviders = this._providerManager.getMissingProviders(neededProviders);
            if (!missingProviders.isEmpty()) {
                this._logger.warn("Missing providers for classes: {}", missingProviders);
                return;
            }
            ManagerCache.INSTANCE.putItemRoutes(name, itemRoutes);
        });
    }
}

