/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.router;

import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.internal.alias.ProvideFunction;
import com.liferay.apio.architect.internal.routes.CollectionRoutesImpl;
import com.liferay.apio.architect.internal.url.ApplicationURL;
import com.liferay.apio.architect.internal.url.ServerURL;
import com.liferay.apio.architect.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.cache.ManagerCache;
import com.liferay.apio.architect.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.NameManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.representable.RepresentableManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.CollectionRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.router.ItemRouterManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.uri.mapper.PathIdentifierMapperManager;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.router.CollectionRouter;
import com.liferay.apio.architect.routes.CollectionRoutes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CollectionRouterManager.class})
public class CollectionRouterManagerImpl
extends ClassNameBaseManager<CollectionRouter>
implements CollectionRouterManager {
    private static final List<String> _mandatoryClassNames = Arrays.asList(ApplicationURL.class.getName(), Credentials.class.getName(), Pagination.class.getName(), ServerURL.class.getName());
    @Reference
    private ItemRouterManager _itemRouterManager;
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private NameManager _nameManager;
    @Reference
    private PathIdentifierMapperManager _pathIdentifierMapperManager;
    @Reference
    private ProviderManager _providerManager;
    @Reference
    private RepresentableManager _representableManager;

    public CollectionRouterManagerImpl() {
        super(CollectionRouter.class, 2);
    }

    @Override
    public Map<String, CollectionRoutes> getCollectionRoutes() {
        return ManagerCache.INSTANCE.getCollectionRoutes(this::_computeCollectionRoutes);
    }

    @Override
    public <T, S> Optional<CollectionRoutes<T, S>> getCollectionRoutesOptional(String name) {
        return ManagerCache.INSTANCE.getCollectionRoutesOptional(name, this::_computeCollectionRoutes);
    }

    @Override
    public List<String> getResourceNames() {
        return ManagerCache.INSTANCE.getRootResourceNames(this::_computeCollectionRoutes);
    }

    private void _computeCollectionRoutes() {
        List<String> list = this._providerManager.getMissingProviders(_mandatoryClassNames);
        if (!list.isEmpty()) {
            this._logger.warn("Missing providers for mandatory classes: {}", list);
            return;
        }
        this.forEachService((className, collectionRouter) -> {
            Optional<String> nameOptional = this._nameManager.getNameOptional((String)className);
            if (!nameOptional.isPresent()) {
                this._logger.warn("Unable to find a Representable for class name {}", className);
                return;
            }
            String name = nameOptional.get();
            Optional representorOptional = this._representableManager.getRepresentorOptional(name);
            if (!representorOptional.isPresent()) {
                this._logger.warn("Unable to find a Representable for class name {}", className);
                return;
            }
            Representor representor = representorOptional.get();
            TreeSet<String> neededProviders = new TreeSet<String>();
            CollectionRoutesImpl.BuilderImpl<Object, Object> builder = new CollectionRoutesImpl.BuilderImpl<Object, Object>(name, ProvideFunction.curry(this._providerManager::provideMandatory), neededProviders::add, this._pathIdentifierMapperManager::mapToIdentifierOrFail, arg_0 -> representor.getIdentifier(arg_0), this._nameManager::getNameOptional);
            CollectionRoutes collectionRoutes = collectionRouter.collectionRoutes(builder);
            List<String> missingProviders = this._providerManager.getMissingProviders(neededProviders);
            if (!missingProviders.isEmpty()) {
                this._logger.warn("Missing providers for classes: {}", missingProviders);
                return;
            }
            Optional optional = this._itemRouterManager.getItemRoutesOptional(name);
            if (!optional.isPresent()) {
                this._logger.warn("Missing item router for resource with name {}", (Object)name);
                return;
            }
            ManagerCache.INSTANCE.putRootResourceName(name);
            ManagerCache.INSTANCE.putCollectionRoutes(name, collectionRoutes);
        });
    }
}

