/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.provider;

import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.provider.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ProviderManager.class})
public class ProviderManagerImpl
extends ClassNameBaseManager<Provider>
implements ProviderManager {
    private Logger _logger = LoggerFactory.getLogger(this.getClass());

    public ProviderManagerImpl() {
        super(Provider.class, 0);
    }

    @Override
    public List<String> getMissingProviders(Collection<String> neededProviders) {
        Set providedClassNames = this.serviceTrackerMap.keySet();
        ArrayList<String> list = new ArrayList<String>(neededProviders);
        list.removeAll(providedClassNames);
        return list;
    }

    @Override
    public <T> T provideMandatory(HttpServletRequest httpServletRequest, Class<T> clazz) {
        Optional providerOptional = this.getServiceOptional(clazz);
        if (!providerOptional.isPresent()) {
            this._logger.warn("Missing provider for mandatory class: {}", clazz);
            throw new NotFoundException();
        }
        Optional<T> optional = this.provideOptional(httpServletRequest, clazz);
        if (clazz.equals(Credentials.class) && !optional.isPresent()) {
            return (T)Unsafe.unsafeCast(() -> "");
        }
        return optional.orElseThrow(() -> {
            this._logger.warn("Mandatory provider for class {} returned null", (Object)clazz);
            return new NotFoundException();
        });
    }

    @Override
    public <T> Optional<T> provideOptional(HttpServletRequest httpServletRequest, Class<T> clazz) {
        Optional optional = (Optional)Unsafe.unsafeCast(this.getServiceOptional(clazz));
        return optional.map(provider -> provider.createContext(httpServletRequest));
    }
}

