/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.documentation.contributor;

import com.liferay.apio.architect.documentation.contributor.CustomDocumentation;
import com.liferay.apio.architect.documentation.contributor.CustomDocumentationContributor;
import com.liferay.apio.architect.internal.documentation.contributor.CustomDocumentationImpl;
import com.liferay.apio.architect.internal.wiring.osgi.manager.cache.ManagerCache;
import com.liferay.apio.architect.internal.wiring.osgi.manager.documentation.contributor.CustomDocumentationManager;
import com.liferay.osgi.service.tracker.collections.internal.DefaultServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={CustomDocumentationManager.class})
public class CustomDocumentationManagerImpl
implements CustomDocumentationManager {
    private ServiceTrackerList<CustomDocumentationContributor, CustomDocumentationContributor> _serviceTrackerList;

    @Activate
    public void activate(BundleContext bundleContext) {
        this._serviceTrackerList = this._openServiceTrackerList(bundleContext);
        ManagerCache.INSTANCE.clear();
    }

    @Deactivate
    public void deactivate() {
        this._serviceTrackerList.close();
        ManagerCache.INSTANCE.clear();
    }

    @Override
    public CustomDocumentation getCustomDocumentation() {
        return ManagerCache.INSTANCE.getDocumentationContribution(this::_computeDocumentationContribution);
    }

    private void _computeDocumentationContribution() {
        CustomDocumentationImpl.BuilderImpl builder = new CustomDocumentationImpl.BuilderImpl();
        Iterable iterable = () -> this._serviceTrackerList.iterator();
        Stream<CustomDocumentationContributor> stream = StreamSupport.stream(iterable.spliterator(), false);
        stream.forEach(customDocumentationContributor -> customDocumentationContributor.customDocumentation(builder));
        CustomDocumentation customDocumentation = builder.build();
        ManagerCache.INSTANCE.putDocumentationContribution(customDocumentation);
    }

    private ServiceTrackerList<CustomDocumentationContributor, CustomDocumentationContributor> _openServiceTrackerList(BundleContext bundleContext) {
        return ServiceTrackerListFactory.open((BundleContext)bundleContext, CustomDocumentationContributor.class, null, (ServiceTrackerCustomizer)new DefaultServiceTrackerCustomizer<CustomDocumentationContributor>(bundleContext){

            public CustomDocumentationContributor addingService(ServiceReference<CustomDocumentationContributor> serviceReference) {
                ManagerCache.INSTANCE.clear();
                return (CustomDocumentationContributor)super.addingService(serviceReference);
            }

            public void removedService(ServiceReference<CustomDocumentationContributor> serviceReference, CustomDocumentationContributor customDocumentationContributor) {
                ManagerCache.INSTANCE.clear();
                super.removedService(serviceReference, (Object)customDocumentationContributor);
            }
        });
    }
}

