/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.cache;

import com.liferay.apio.architect.documentation.contributor.CustomDocumentation;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.message.json.BatchResultMessageMapper;
import com.liferay.apio.architect.internal.message.json.DocumentationMessageMapper;
import com.liferay.apio.architect.internal.message.json.EntryPointMessageMapper;
import com.liferay.apio.architect.internal.message.json.ErrorMessageMapper;
import com.liferay.apio.architect.internal.message.json.FormMessageMapper;
import com.liferay.apio.architect.internal.message.json.PageMessageMapper;
import com.liferay.apio.architect.internal.message.json.SingleModelMessageMapper;
import com.liferay.apio.architect.internal.unsafe.Unsafe;
import com.liferay.apio.architect.internal.wiring.osgi.alias.EmptyFunction;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Variant;

public class ManagerCache {
    public static final ManagerCache INSTANCE = new ManagerCache();
    private static final MediaType _MEDIA_TYPE = MediaType.valueOf((String)"application/hal+json");
    private Map<MediaType, BatchResultMessageMapper> _batchResultMessageMappers;
    private Map<String, CollectionRoutes> _collectionRoutes;
    private CustomDocumentation _customDocumentation;
    private Map<MediaType, DocumentationMessageMapper> _documentationMessageMappers;
    private Map<MediaType, EntryPointMessageMapper> _entryPointMessageMappers;
    private Map<MediaType, ErrorMessageMapper> _errorMessageMappers;
    private Map<MediaType, FormMessageMapper> _formMessageMappers;
    private Map<String, Class<Identifier>> _identifierClasses;
    private Map<String, ItemRoutes> _itemRoutes;
    private Map<String, String> _names;
    private Map<String, NestedCollectionRoutes> _nestedCollectionRoutes;
    private Map<MediaType, PageMessageMapper> _pageMessageMappers;
    private Map<String, Representor> _representors;
    private Map<String, NestedCollectionRoutes> _reusableNestedCollectionRoutes;
    private List<String> _rootResourceNames;
    private Map<MediaType, SingleModelMessageMapper> _singleModelMessageMappers;

    public void clear() {
        this._collectionRoutes = null;
        this._documentationMessageMappers = null;
        this._entryPointMessageMappers = null;
        this._errorMessageMappers = null;
        this._formMessageMappers = null;
        this._identifierClasses = null;
        this._itemRoutes = null;
        this._names = null;
        this._nestedCollectionRoutes = null;
        this._pageMessageMappers = null;
        this._batchResultMessageMappers = null;
        this._representors = null;
        this._reusableNestedCollectionRoutes = null;
        this._rootResourceNames = null;
        this._singleModelMessageMappers = null;
    }

    public <T> Optional<BatchResultMessageMapper<T>> getBatchResultMessageMapperOptional(Request request, EmptyFunction computeEmptyFunction) {
        if (this._batchResultMessageMappers == null) {
            computeEmptyFunction.invoke();
        }
        Optional<BatchResultMessageMapper> optional = this._getMessageMapperOptional(request, this._batchResultMessageMappers);
        return optional.map(Unsafe::unsafeCast);
    }

    public Map<String, CollectionRoutes> getCollectionRoutes(EmptyFunction computeEmptyFunction) {
        if (this._collectionRoutes == null) {
            computeEmptyFunction.invoke();
        }
        return this._collectionRoutes;
    }

    public <T, S> Optional<CollectionRoutes<T, S>> getCollectionRoutesOptional(String name, EmptyFunction computeEmptyFunction) {
        if (this._collectionRoutes == null) {
            computeEmptyFunction.invoke();
        }
        return Optional.ofNullable(this._collectionRoutes).map(map -> (CollectionRoutes)map.get(name)).map(Unsafe::unsafeCast);
    }

    public CustomDocumentation getDocumentationContribution(EmptyFunction computeEmptyFunction) {
        if (this._customDocumentation == null) {
            computeEmptyFunction.invoke();
        }
        return this._customDocumentation;
    }

    public Optional<DocumentationMessageMapper> getDocumentationMessageMapperOptional(Request request, EmptyFunction computeEmptyFunction) {
        if (this._documentationMessageMappers == null) {
            computeEmptyFunction.invoke();
        }
        Optional<DocumentationMessageMapper> optional = this._getMessageMapperOptional(request, this._documentationMessageMappers);
        return optional.map(Unsafe::unsafeCast);
    }

    public Optional<EntryPointMessageMapper> getEntryPointMessageMapperOptional(Request request, EmptyFunction computeEmptyFunction) {
        if (this._entryPointMessageMappers == null) {
            computeEmptyFunction.invoke();
        }
        Optional<EntryPointMessageMapper> optional = this._getMessageMapperOptional(request, this._entryPointMessageMappers);
        return optional.map(Unsafe::unsafeCast);
    }

    public Optional<ErrorMessageMapper> getErrorMessageMapperOptional(Request request, EmptyFunction computeEmptyFunction) {
        if (this._errorMessageMappers == null) {
            computeEmptyFunction.invoke();
        }
        Optional<ErrorMessageMapper> optional = this._getMessageMapperOptional(request, this._errorMessageMappers);
        return optional.map(Unsafe::unsafeCast);
    }

    public Optional<FormMessageMapper> getFormMessageMapperOptional(Request request, EmptyFunction computeEmptyFunction) {
        if (this._formMessageMappers == null) {
            computeEmptyFunction.invoke();
        }
        Optional<FormMessageMapper> optional = this._getMessageMapperOptional(request, this._formMessageMappers);
        return optional.map(Unsafe::unsafeCast);
    }

    public <T extends Identifier> Optional<Class<T>> getIdentifierClassOptional(String name, EmptyFunction computeEmptyFunction) {
        if (this._identifierClasses == null) {
            computeEmptyFunction.invoke();
        }
        return Optional.ofNullable(this._identifierClasses).map(map -> (Class)map.get(name)).map(Unsafe::unsafeCast);
    }

    public Map<String, ItemRoutes> getItemRoutesMap(EmptyFunction computeEmptyFunction) {
        if (this._itemRoutes == null) {
            computeEmptyFunction.invoke();
        }
        return this._itemRoutes;
    }

    public <T, S> Optional<ItemRoutes<T, S>> getItemRoutesOptional(String name, EmptyFunction computeEmptyFunction) {
        if (this._itemRoutes == null) {
            computeEmptyFunction.invoke();
        }
        return Optional.ofNullable(this._itemRoutes).map(map -> (ItemRoutes)map.get(name)).map(Unsafe::unsafeCast);
    }

    public Optional<String> getNameOptional(String className, EmptyFunction computeEmptyFunction) {
        if (this._names == null) {
            computeEmptyFunction.invoke();
        }
        Optional<Map<String, String>> optional = this.getNamesOptional();
        return optional.map(map -> (String)map.get(className));
    }

    public Optional<Map<String, String>> getNamesOptional() {
        return Optional.ofNullable(this._names);
    }

    public Map<String, NestedCollectionRoutes> getNestedCollectionRoutesMap(EmptyFunction computeEmptyFunction) {
        if (this._nestedCollectionRoutes == null) {
            computeEmptyFunction.invoke();
        }
        return this._nestedCollectionRoutes;
    }

    public <T, S, U> Optional<NestedCollectionRoutes<T, S, U>> getNestedCollectionRoutesOptional(String name, String nestedName, EmptyFunction computeEmptyFunction) {
        if (this._nestedCollectionRoutes == null) {
            computeEmptyFunction.invoke();
        }
        return Optional.ofNullable(this._nestedCollectionRoutes).map(map -> (NestedCollectionRoutes)map.get(name + "-" + nestedName)).map(Unsafe::unsafeCast);
    }

    public <T> Optional<PageMessageMapper<T>> getPageMessageMapperOptional(Request request, EmptyFunction computeEmptyFunction) {
        if (this._pageMessageMappers == null) {
            computeEmptyFunction.invoke();
        }
        Optional<PageMessageMapper> optional = this._getMessageMapperOptional(request, this._pageMessageMappers);
        return optional.map(Unsafe::unsafeCast);
    }

    public Map<String, Representor> getRepresentorMap(EmptyFunction computeEmptyFunction) {
        if (this._representors == null) {
            computeEmptyFunction.invoke();
        }
        return this._representors;
    }

    public <T> Optional<Representor<T>> getRepresentorOptional(String name, EmptyFunction computeEmptyFunction) {
        if (this._representors == null) {
            computeEmptyFunction.invoke();
        }
        return Optional.ofNullable(this._representors).map(map -> (Representor)map.get(name)).map(Unsafe::unsafeCast);
    }

    public Map<String, NestedCollectionRoutes> getReusableCollectionRoutesMap(EmptyFunction computeEmptyFunction) {
        if (this._reusableNestedCollectionRoutes == null) {
            computeEmptyFunction.invoke();
        }
        return this._reusableNestedCollectionRoutes;
    }

    public Optional<NestedCollectionRoutes> getReusableNestedCollectionRoutesOptional(String name, EmptyFunction computeEmptyFunction) {
        if (this._reusableNestedCollectionRoutes == null) {
            computeEmptyFunction.invoke();
        }
        return Optional.ofNullable(this._reusableNestedCollectionRoutes).map(map -> (NestedCollectionRoutes)map.get(name)).map(Unsafe::unsafeCast);
    }

    public List<String> getRootResourceNames(EmptyFunction computeEmptyFunction) {
        if (this._rootResourceNames == null) {
            computeEmptyFunction.invoke();
        }
        return Optional.ofNullable(this._rootResourceNames).orElseGet(Collections::emptyList);
    }

    public <T> Optional<SingleModelMessageMapper<T>> getSingleModelMessageMapperOptional(Request request, EmptyFunction computeEmptyFunction) {
        if (this._singleModelMessageMappers == null) {
            computeEmptyFunction.invoke();
        }
        Optional<SingleModelMessageMapper> optional = this._getMessageMapperOptional(request, this._singleModelMessageMappers);
        return optional.map(Unsafe::unsafeCast);
    }

    public void putBatchResultMessageMapper(MediaType mediaType, BatchResultMessageMapper batchResultMessageMapper) {
        if (this._batchResultMessageMappers == null) {
            this._batchResultMessageMappers = new HashMap<MediaType, BatchResultMessageMapper>();
        }
        this._batchResultMessageMappers.put(mediaType, batchResultMessageMapper);
    }

    public void putCollectionRoutes(String key, CollectionRoutes collectionRoutes) {
        if (this._collectionRoutes == null) {
            this._collectionRoutes = new HashMap<String, CollectionRoutes>();
        }
        this._collectionRoutes.put(key, collectionRoutes);
    }

    public void putDocumentationContribution(CustomDocumentation customDocumentation) {
        this._customDocumentation = customDocumentation;
    }

    public void putDocumentationMessageMapper(MediaType mediaType, DocumentationMessageMapper documentationMessageMapper) {
        if (this._documentationMessageMappers == null) {
            this._documentationMessageMappers = new HashMap<MediaType, DocumentationMessageMapper>();
        }
        this._documentationMessageMappers.put(mediaType, documentationMessageMapper);
    }

    public void putEntryPointMessageMapper(MediaType mediaType, EntryPointMessageMapper entryPointMessageMapper) {
        if (this._entryPointMessageMappers == null) {
            this._entryPointMessageMappers = new HashMap<MediaType, EntryPointMessageMapper>();
        }
        this._entryPointMessageMappers.put(mediaType, entryPointMessageMapper);
    }

    public void putErrorMessageMapper(MediaType mediaType, ErrorMessageMapper errorMessageMapper) {
        if (this._errorMessageMappers == null) {
            this._errorMessageMappers = new HashMap<MediaType, ErrorMessageMapper>();
        }
        this._errorMessageMappers.put(mediaType, errorMessageMapper);
    }

    public void putFormMessageMapper(MediaType mediaType, FormMessageMapper formMessageMapper) {
        if (this._formMessageMappers == null) {
            this._formMessageMappers = new HashMap<MediaType, FormMessageMapper>();
        }
        this._formMessageMappers.put(mediaType, formMessageMapper);
    }

    public void putIdentifierClass(String key, Class<Identifier> identifierClass) {
        if (this._identifierClasses == null) {
            this._identifierClasses = new HashMap<String, Class<Identifier>>();
        }
        this._identifierClasses.put(key, identifierClass);
    }

    public void putItemRoutes(String key, ItemRoutes itemRoutes) {
        if (this._itemRoutes == null) {
            this._itemRoutes = new HashMap<String, ItemRoutes>();
        }
        this._itemRoutes.put(key, itemRoutes);
    }

    public void putName(String key, String name) {
        if (this._names == null) {
            this._names = new HashMap<String, String>();
        }
        this._names.put(key, name);
    }

    public void putNestedCollectionRoutes(String key, NestedCollectionRoutes nestedCollectionRoutes) {
        if (this._nestedCollectionRoutes == null) {
            this._nestedCollectionRoutes = new HashMap<String, NestedCollectionRoutes>();
        }
        this._nestedCollectionRoutes.put(key, nestedCollectionRoutes);
    }

    public void putPageMessageMapper(MediaType mediaType, PageMessageMapper pageMessageMapper) {
        if (this._pageMessageMappers == null) {
            this._pageMessageMappers = new HashMap<MediaType, PageMessageMapper>();
        }
        this._pageMessageMappers.put(mediaType, pageMessageMapper);
    }

    public void putRepresentor(String key, Representor representor) {
        if (this._representors == null) {
            this._representors = new HashMap<String, Representor>();
        }
        this._representors.put(key, representor);
    }

    public void putReusableNestedCollectionRoutes(String key, NestedCollectionRoutes reusableNestedCollectionRoutes) {
        if (this._reusableNestedCollectionRoutes == null) {
            this._reusableNestedCollectionRoutes = new HashMap<String, NestedCollectionRoutes>();
        }
        this._reusableNestedCollectionRoutes.put(key, reusableNestedCollectionRoutes);
    }

    public void putRootResourceName(String rootResourceName) {
        if (this._rootResourceNames == null) {
            this._rootResourceNames = new ArrayList<String>();
        }
        this._rootResourceNames.add(rootResourceName);
    }

    public void putSingleModelMessageMapper(MediaType mediaType, SingleModelMessageMapper singleModelMessageMapper) {
        if (this._singleModelMessageMappers == null) {
            this._singleModelMessageMappers = new HashMap<MediaType, SingleModelMessageMapper>();
        }
        this._singleModelMessageMappers.put(mediaType, singleModelMessageMapper);
    }

    private ManagerCache() {
    }

    private <T> Optional<T> _getMessageMapperOptional(Request request, Map<MediaType, T> messageMappers) {
        return Optional.ofNullable(messageMappers).map(Map::keySet).map(Collection::stream).map(stream -> (MediaType[])stream.toArray(MediaType[]::new)).map(this::_getVariantListBuilder).map(Variant.VariantListBuilder::build).map(arg_0 -> ((Request)request).selectVariant(arg_0)).map(Variant::getMediaType).flatMap(mediaType -> Optional.ofNullable(messageMappers).map(map -> map.get(mediaType)));
    }

    private Variant.VariantListBuilder _getVariantListBuilder(MediaType[] mediaTypes) {
        Variant.VariantListBuilder variantListBuilder = Variant.VariantListBuilder.newInstance();
        List<MediaType> list = Arrays.asList(mediaTypes);
        if (list.contains(_MEDIA_TYPE)) {
            return variantListBuilder.mediaTypes(new MediaType[]{_MEDIA_TYPE}).add().mediaTypes(mediaTypes);
        }
        return variantListBuilder.mediaTypes(mediaTypes);
    }
}

