/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.wiring.osgi.manager.base;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.wiring.osgi.manager.base.BaseManager;
import com.liferay.apio.architect.internal.wiring.osgi.manager.util.ManagerUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import java.util.Optional;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassNameBaseManager<T>
extends BaseManager<T, String> {
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    private final Class<T> _managedClass;
    private final int _principalTypeParamPosition;

    public ClassNameBaseManager(Class<T> managedClass, int principalTypeParamPosition) {
        super(managedClass);
        this._managedClass = managedClass;
        this._principalTypeParamPosition = principalTypeParamPosition;
    }

    public <V> Optional<T> getServiceOptional(Class<V> clazz) {
        return Optional.ofNullable(this.serviceTrackerMap.getService((Object)clazz.getName()));
    }

    @Override
    protected void emit(ServiceReference<T> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
        Object t = this.bundleContext.getService(serviceReference);
        if (t == null) {
            return;
        }
        Try classTry = ManagerUtil.getGenericClassFromProperty(serviceReference, "apio.architect.principal.type.argument");
        classTry.recoverWith(__ -> ManagerUtil.getTypeParamTry(t, this._managedClass, this._principalTypeParamPosition)).map(Class::getName).voidFold(__ -> this._logger.warn("Unable to get generic information from {}", t.getClass()), arg_0 -> emitter.emit(arg_0));
    }
}

