/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.routes;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.alias.form.FormBuilderFunction;
import com.liferay.apio.architect.alias.routes.NestedBatchCreateItemFunction;
import com.liferay.apio.architect.alias.routes.NestedCreateItemFunction;
import com.liferay.apio.architect.alias.routes.NestedGetPageFunction;
import com.liferay.apio.architect.alias.routes.permission.HasNestedAddingPermissionFunction;
import com.liferay.apio.architect.batch.BatchResult;
import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.function.throwable.ThrowableBiFunction;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.function.throwable.ThrowableHexaFunction;
import com.liferay.apio.architect.function.throwable.ThrowablePentaFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTetraFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTriFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.internal.alias.ProvideFunction;
import com.liferay.apio.architect.internal.form.FormImpl;
import com.liferay.apio.architect.internal.operation.BatchCreateOperation;
import com.liferay.apio.architect.internal.operation.CreateOperation;
import com.liferay.apio.architect.internal.pagination.PageImpl;
import com.liferay.apio.architect.internal.routes.RoutesBuilderUtil;
import com.liferay.apio.architect.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.apio.architect.uri.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class NestedCollectionRoutesImpl<T, S, U>
implements NestedCollectionRoutes<T, S, U> {
    private final Form _form;
    private final NestedBatchCreateItemFunction<S, U> _nestedBatchCreateItemFunction;
    private final NestedCreateItemFunction<T, U> _nestedCreateItemFunction;
    private final NestedGetPageFunction<T, U> _nestedGetPageFunction;

    public NestedCollectionRoutesImpl(BuilderImpl<T, S, U> builderImpl) {
        this._form = ((BuilderImpl)builderImpl)._form;
        this._nestedCreateItemFunction = ((BuilderImpl)builderImpl)._nestedCreateItemFunction;
        this._nestedBatchCreateItemFunction = ((BuilderImpl)builderImpl)._nestedBatchCreateItemFunction;
        this._nestedGetPageFunction = ((BuilderImpl)builderImpl)._nestedGetPageFunction;
    }

    public Optional<Form> getFormOptional() {
        return Optional.ofNullable(this._form);
    }

    public Optional<NestedBatchCreateItemFunction<S, U>> getNestedBatchCreateItemFunctionOptional() {
        return Optional.ofNullable(this._nestedBatchCreateItemFunction);
    }

    public Optional<NestedCreateItemFunction<T, U>> getNestedCreateItemFunctionOptional() {
        return Optional.ofNullable(this._nestedCreateItemFunction);
    }

    public Optional<NestedGetPageFunction<T, U>> getNestedGetPageFunctionOptional() {
        return Optional.ofNullable(this._nestedGetPageFunction);
    }

    public static class BuilderImpl<T, S, U>
    implements NestedCollectionRoutes.Builder<T, S, U> {
        private Form _form;
        private ThrowableBiFunction<Credentials, U, Boolean> _hasNestedAddingPermissionFunction;
        private final Function<U, Optional<Path>> _identifierToPathFunction;
        private final Function<T, S> _modelToIdentifierFunction;
        private final String _name;
        private final Consumer<String> _neededProviderConsumer;
        private NestedBatchCreateItemFunction<S, U> _nestedBatchCreateItemFunction;
        private NestedCreateItemFunction<T, U> _nestedCreateItemFunction;
        private NestedGetPageFunction<T, U> _nestedGetPageFunction;
        private final String _nestedName;
        private final IdentifierFunction<?> _pathToIdentifierFunction;
        private final ProvideFunction _provideFunction;

        public BuilderImpl(String name, String nestedName, ProvideFunction provideFunction, Consumer<String> neededProviderConsumer, Function<Path, ?> pathToIdentifierFunction, Function<U, Optional<Path>> identifierToPathFunction, Function<T, S> modelToIdentifierFunction) {
            this._name = name;
            this._nestedName = nestedName;
            this._provideFunction = provideFunction;
            this._neededProviderConsumer = neededProviderConsumer;
            this._pathToIdentifierFunction = pathToIdentifierFunction::apply;
            this._identifierToPathFunction = identifierToPathFunction;
            this._modelToIdentifierFunction = modelToIdentifierFunction;
        }

        public <R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowableBiFunction<U, R, T> creatorThrowableBiFunction, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowableBiFunction batchCreatorThrowableBiFunction = (u, formList) -> this._transformList((List)formList, r -> creatorThrowableBiFunction.apply(u, r));
            return this.addCreator(creatorThrowableBiFunction, batchCreatorThrowableBiFunction, hasNestedAddingPermissionFunction, formBuilderFunction);
        }

        public <R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowableBiFunction<U, R, T> creatorThrowableBiFunction, ThrowableBiFunction<U, List<R>, List<S>> batchCreatorThrowableBiFunction, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._hasNestedAddingPermissionFunction = hasNestedAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name, this._nestedName), this._pathToIdentifierFunction));
            this._nestedCreateItemFunction = httpServletRequest -> identifier -> body -> Try.fromFallible(() -> (SingleModelImpl)creatorThrowableBiFunction.andThen(t -> new SingleModelImpl<Object>(t, this._nestedName, Collections.emptyList())).apply(identifier, form.get(body)));
            this._nestedBatchCreateItemFunction = httpServletRequest -> body -> identifier -> Try.fromFallible(() -> (BatchResult)batchCreatorThrowableBiFunction.andThen(t -> new BatchResult(t, this._nestedName)).apply(identifier, (Object)form.getList(body)));
            return this;
        }

        public <A, B, C, D, R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowableHexaFunction<U, R, A, B, C, D, T> creatorThrowableHexaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowableHexaFunction batchCreatorThrowableHexaFunction = (u, formList, a, b, c, d) -> this._transformList((List)formList, r -> creatorThrowableHexaFunction.apply(u, r, a, b, c, d));
            return this.addCreator(creatorThrowableHexaFunction, batchCreatorThrowableHexaFunction, aClass, bClass, cClass, dClass, hasNestedAddingPermissionFunction, formBuilderFunction);
        }

        public <A, B, C, D, R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowableHexaFunction<U, R, A, B, C, D, T> creatorThrowableHexaFunction, ThrowableHexaFunction<U, List<R>, A, B, C, D, List<S>> batchCreatorThrowableHexaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._hasNestedAddingPermissionFunction = hasNestedAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name, this._nestedName), this._pathToIdentifierFunction));
            this._nestedCreateItemFunction = httpServletRequest -> identifier -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, (a, b, c, d) -> (SingleModelImpl)creatorThrowableHexaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._nestedName, Collections.emptyList())).apply(identifier, form.get(body), a, b, c, d));
            this._nestedBatchCreateItemFunction = httpServletRequest -> body -> identifier -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, (a, b, c, d) -> (BatchResult)batchCreatorThrowableHexaFunction.andThen(t -> new BatchResult(t, this._nestedName)).apply(identifier, (Object)form.getList(body), a, b, c, d));
            return this;
        }

        public <A, B, C, R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowablePentaFunction<U, R, A, B, C, T> creatorThrowablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowablePentaFunction batchCreatorThrowablePentaFunction = (u, formList, a, b, c) -> this._transformList((List)formList, r -> creatorThrowablePentaFunction.apply(u, r, a, b, c));
            return this.addCreator(creatorThrowablePentaFunction, batchCreatorThrowablePentaFunction, aClass, bClass, cClass, hasNestedAddingPermissionFunction, formBuilderFunction);
        }

        public <A, B, C, R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowablePentaFunction<U, R, A, B, C, T> creatorThrowablePentaFunction, ThrowablePentaFunction<U, List<R>, A, B, C, List<S>> batchCreatorThrowablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._hasNestedAddingPermissionFunction = hasNestedAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name, this._nestedName), this._pathToIdentifierFunction));
            this._nestedCreateItemFunction = httpServletRequest -> identifier -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, (a, b, c) -> (SingleModelImpl)creatorThrowablePentaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._nestedName, Collections.emptyList())).apply(identifier, form.get(body), a, b, c));
            this._nestedBatchCreateItemFunction = httpServletRequest -> body -> identifier -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, (a, b, c) -> (BatchResult)batchCreatorThrowablePentaFunction.andThen(t -> new BatchResult(t, this._nestedName)).apply(identifier, (Object)form.getList(body), a, b, c));
            return this;
        }

        public <A, B, R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowableTetraFunction<U, R, A, B, T> creatorThrowableTetraFunction, Class<A> aClass, Class<B> bClass, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowableTetraFunction batchCreatorThrowableTetraFunction = (u, formList, a, b) -> this._transformList((List)formList, r -> creatorThrowableTetraFunction.apply(u, r, a, b));
            return this.addCreator(creatorThrowableTetraFunction, batchCreatorThrowableTetraFunction, aClass, bClass, hasNestedAddingPermissionFunction, formBuilderFunction);
        }

        public <A, B, R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowableTetraFunction<U, R, A, B, T> creatorThrowableTetraFunction, ThrowableTetraFunction<U, List<R>, A, B, List<S>> batchCreatorThrowableTetraFunction, Class<A> aClass, Class<B> bClass, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._hasNestedAddingPermissionFunction = hasNestedAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name, this._nestedName), this._pathToIdentifierFunction));
            this._nestedCreateItemFunction = httpServletRequest -> identifier -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, (a, b) -> (SingleModelImpl)creatorThrowableTetraFunction.andThen(t -> new SingleModelImpl<Object>(t, this._nestedName, Collections.emptyList())).apply(identifier, form.get(body), a, b));
            this._nestedBatchCreateItemFunction = httpServletRequest -> body -> identifier -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, (a, b) -> (BatchResult)batchCreatorThrowableTetraFunction.andThen(t -> new BatchResult(t, this._nestedName)).apply(identifier, (Object)form.getList(body), a, b));
            return this;
        }

        public <A, R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowableTriFunction<U, R, A, T> creatorThrowableTriFunction, Class<A> aClass, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowableTriFunction batchCreatorThrowableTriFunction = (u, formList, a) -> this._transformList((List)formList, r -> creatorThrowableTriFunction.apply(u, r, a));
            return this.addCreator(creatorThrowableTriFunction, batchCreatorThrowableTriFunction, aClass, hasNestedAddingPermissionFunction, formBuilderFunction);
        }

        public <A, R> NestedCollectionRoutes.Builder<T, S, U> addCreator(ThrowableTriFunction<U, R, A, T> creatorThrowableTriFunction, ThrowableTriFunction<U, List<R>, A, List<S>> batchCreatorThrowableTriFunction, Class<A> aClass, HasNestedAddingPermissionFunction<U> hasNestedAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._hasNestedAddingPermissionFunction = hasNestedAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name, this._nestedName), this._pathToIdentifierFunction));
            this._nestedCreateItemFunction = httpServletRequest -> identifier -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, a -> (SingleModelImpl)creatorThrowableTriFunction.andThen(t -> new SingleModelImpl<Object>(t, this._nestedName, Collections.emptyList())).apply(identifier, form.get(body), a));
            this._nestedBatchCreateItemFunction = httpServletRequest -> body -> identifier -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, a -> (BatchResult)batchCreatorThrowableTriFunction.andThen(t -> new BatchResult(t, this._nestedName)).apply(identifier, (Object)form.getList(body), a));
            return this;
        }

        public NestedCollectionRoutes.Builder<T, S, U> addGetter(ThrowableBiFunction<Pagination, U, PageItems<T>> getterThrowableBiFunction) {
            this._nestedGetPageFunction = httpServletRequest -> path -> identifier -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, Credentials.class, (pagination, credentials) -> (PageImpl)getterThrowableBiFunction.andThen(items -> new PageImpl(this._nestedName, items, (Pagination)pagination, (Path)path, this._getOperations((Credentials)credentials, (U)identifier))).apply(pagination, identifier));
            return this;
        }

        public <A, B, C, D> NestedCollectionRoutes.Builder<T, S, U> addGetter(ThrowableHexaFunction<Pagination, U, A, B, C, D, PageItems<T>> getterThrowableHexaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._nestedGetPageFunction = httpServletRequest -> path -> identifier -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, cClass, dClass, Credentials.class, (pagination, a, b, c, d, credentials) -> (PageImpl)getterThrowableHexaFunction.andThen(items -> new PageImpl(this._nestedName, items, (Pagination)pagination, (Path)path, this._getOperations((Credentials)credentials, (U)identifier))).apply(pagination, identifier, a, b, c, d));
            return this;
        }

        public <A, B, C> NestedCollectionRoutes.Builder<T, S, U> addGetter(ThrowablePentaFunction<Pagination, U, A, B, C, PageItems<T>> getterThrowablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._nestedGetPageFunction = httpServletRequest -> path -> identifier -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, cClass, Credentials.class, (pagination, a, b, c, credentials) -> (PageImpl)getterThrowablePentaFunction.andThen(items -> new PageImpl(this._nestedName, items, (Pagination)pagination, (Path)path, this._getOperations((Credentials)credentials, (U)identifier))).apply(pagination, identifier, a, b, c));
            return this;
        }

        public <A, B> NestedCollectionRoutes.Builder<T, S, U> addGetter(ThrowableTetraFunction<Pagination, U, A, B, PageItems<T>> getterThrowableTetraFunction, Class<A> aClass, Class<B> bClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._nestedGetPageFunction = httpServletRequest -> path -> identifier -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, Credentials.class, (pagination, a, b, credentials) -> (PageImpl)getterThrowableTetraFunction.andThen(items -> new PageImpl(this._nestedName, items, (Pagination)pagination, (Path)path, this._getOperations((Credentials)credentials, (U)identifier))).apply(pagination, identifier, a, b));
            return this;
        }

        public <A> NestedCollectionRoutes.Builder<T, S, U> addGetter(ThrowableTriFunction<Pagination, U, A, PageItems<T>> getterThrowableTriFunction, Class<A> aClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._nestedGetPageFunction = httpServletRequest -> path -> identifier -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, Credentials.class, (pagination, a, credentials) -> (PageImpl)getterThrowableTriFunction.andThen(items -> new PageImpl(this._nestedName, items, (Pagination)pagination, (Path)path, this._getOperations((Credentials)credentials, (U)identifier))).apply(pagination, identifier, a));
            return this;
        }

        public NestedCollectionRoutes<T, S, U> build() {
            return new NestedCollectionRoutesImpl(this);
        }

        private List<Operation> _getOperations(Credentials credentials, U identifier) {
            Optional<Path> optional = this._identifierToPathFunction.apply(identifier);
            if (!optional.isPresent()) {
                return Collections.emptyList();
            }
            Path path = optional.get();
            Boolean canAdd = (Boolean)Try.fromFallible(() -> (Boolean)this._hasNestedAddingPermissionFunction.apply((Object)credentials, identifier)).orElse((Object)false);
            if (!canAdd.booleanValue()) {
                return Collections.emptyList();
            }
            String resourceName = null;
            String uri = null;
            if (this._name.equals("r")) {
                resourceName = this._nestedName;
                uri = String.join((CharSequence)"/", this._name, this._nestedName, path.getId());
            } else {
                resourceName = this._name + "/" + this._nestedName;
                uri = path.asURI() + "/" + this._nestedName;
            }
            CreateOperation createOperation = new CreateOperation(this._form, resourceName, uri);
            BatchCreateOperation batchCreateOperation = new BatchCreateOperation(this._form, resourceName, uri);
            return Arrays.asList(createOperation, batchCreateOperation);
        }

        private <V> List<S> _transformList(List<V> list, ThrowableFunction<V, T> transformThrowableFunction) throws Exception {
            ArrayList<Object> newList = new ArrayList<Object>();
            for (V v : list) {
                Object s = transformThrowableFunction.andThen(this._modelToIdentifierFunction::apply).apply(v);
                newList.add(s);
            }
            return newList;
        }
    }
}

