/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.routes;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.alias.form.FormBuilderFunction;
import com.liferay.apio.architect.alias.routes.BatchCreateItemFunction;
import com.liferay.apio.architect.alias.routes.CreateItemFunction;
import com.liferay.apio.architect.alias.routes.CustomPageFunction;
import com.liferay.apio.architect.alias.routes.GetPageFunction;
import com.liferay.apio.architect.alias.routes.permission.HasAddingPermissionFunction;
import com.liferay.apio.architect.batch.BatchResult;
import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.custom.actions.CustomRoute;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.function.throwable.ThrowableBiFunction;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.function.throwable.ThrowableHexaFunction;
import com.liferay.apio.architect.function.throwable.ThrowablePentaFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTetraFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTriFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.internal.alias.ProvideFunction;
import com.liferay.apio.architect.internal.form.FormImpl;
import com.liferay.apio.architect.internal.operation.BatchCreateOperation;
import com.liferay.apio.architect.internal.operation.CreateOperation;
import com.liferay.apio.architect.internal.operation.DeleteOperation;
import com.liferay.apio.architect.internal.operation.RetrieveOperation;
import com.liferay.apio.architect.internal.operation.UpdateOperation;
import com.liferay.apio.architect.internal.pagination.PageImpl;
import com.liferay.apio.architect.internal.routes.RoutesBuilderUtil;
import com.liferay.apio.architect.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.uri.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class CollectionRoutesImpl<T, S>
implements CollectionRoutes<T, S> {
    private final BatchCreateItemFunction<S> _batchCreateItemFunction;
    private final CreateItemFunction<T> _createItemFunction;
    private final Map<String, CustomPageFunction<?>> _customPageFunctions;
    private final Map<String, CustomRoute> _customRoutes;
    private final Form _form;
    private final GetPageFunction<T> _getPageFunction;

    public CollectionRoutesImpl(BuilderImpl<T, S> builderImpl) {
        this._batchCreateItemFunction = ((BuilderImpl)builderImpl)._batchCreateItemFunction;
        this._createItemFunction = ((BuilderImpl)builderImpl)._createItemFunction;
        this._form = ((BuilderImpl)builderImpl)._form;
        this._getPageFunction = ((BuilderImpl)builderImpl)._getPageFunction;
        this._customRoutes = ((BuilderImpl)builderImpl)._customRoutes;
        this._customPageFunctions = ((BuilderImpl)builderImpl)._customRouteFunctions;
    }

    public Optional<BatchCreateItemFunction<S>> getBatchCreateItemFunctionOptional() {
        return Optional.ofNullable(this._batchCreateItemFunction);
    }

    public Optional<CreateItemFunction<T>> getCreateItemFunctionOptional() {
        return Optional.ofNullable(this._createItemFunction);
    }

    public Optional<Map<String, CustomPageFunction<?>>> getCustomPageFunctionsOptional() {
        return Optional.of(this._customPageFunctions);
    }

    public Map<String, CustomRoute> getCustomRoutes() {
        return this._customRoutes;
    }

    public Optional<Form> getFormOptional() {
        return Optional.ofNullable(this._form);
    }

    public Optional<GetPageFunction<T>> getGetPageFunctionOptional() {
        return Optional.ofNullable(this._getPageFunction);
    }

    public static class BuilderImpl<T, S>
    implements CollectionRoutes.Builder<T, S> {
        private BatchCreateItemFunction<S> _batchCreateItemFunction;
        private CreateItemFunction<T> _createItemFunction;
        private final Map<String, Function<Credentials, Boolean>> _customPermissionFunctions = new HashMap<String, Function<Credentials, Boolean>>();
        private Map<String, CustomPageFunction<?>> _customRouteFunctions = new HashMap();
        private final Map<String, CustomRoute> _customRoutes = new HashMap<String, CustomRoute>();
        private Form _form;
        private GetPageFunction<T> _getPageFunction;
        private HasAddingPermissionFunction _hasAddingPermissionFunction;
        private final Function<T, S> _modelToIdentifierFunction;
        private final String _name;
        private final Function<String, Optional<String>> _nameFunction;
        private final Consumer<String> _neededProviderConsumer;
        private final IdentifierFunction<?> _pathToIdentifierFunction;
        private final ProvideFunction _provideFunction;

        public BuilderImpl(String name, ProvideFunction provideFunction, Consumer<String> neededProviderConsumer, Function<Path, ?> pathToIdentifierFunction, Function<T, S> modelToIdentifierFunction, Function<String, Optional<String>> nameFunction) {
            this._name = name;
            this._provideFunction = provideFunction;
            this._neededProviderConsumer = neededProviderConsumer;
            this._pathToIdentifierFunction = pathToIdentifierFunction::apply;
            this._modelToIdentifierFunction = modelToIdentifierFunction;
            this._nameFunction = nameFunction;
        }

        public <A, R> CollectionRoutes.Builder<T, S> addCreator(ThrowableBiFunction<R, A, T> creatorThrowableBiFunction, Class<A> aClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowableBiFunction batchCreatorThrowableBiFunction = (formList, a) -> this._transformList((List)formList, r -> creatorThrowableBiFunction.apply(r, a));
            return this.addCreator(creatorThrowableBiFunction, batchCreatorThrowableBiFunction, aClass, hasAddingPermissionFunction, formBuilderFunction);
        }

        public <A, R> CollectionRoutes.Builder<T, S> addCreator(ThrowableBiFunction<R, A, T> creatorThrowableBiFunction, ThrowableBiFunction<List<R>, A, List<S>> batchCreatorThrowableBiFunction, Class<A> aClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), this._pathToIdentifierFunction));
            this._createItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, a -> (SingleModelImpl)creatorThrowableBiFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body), a));
            this._batchCreateItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, a -> (BatchResult)batchCreatorThrowableBiFunction.andThen(t -> new BatchResult(t, this._name)).apply((Object)form.getList(body), a));
            return this;
        }

        public <R> CollectionRoutes.Builder<T, S> addCreator(ThrowableFunction<R, T> creatorThrowableFunction, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowableFunction batchCreatorThrowableFunction = formList -> this._transformList((List)formList, (ThrowableFunction)creatorThrowableFunction);
            return this.addCreator(creatorThrowableFunction, batchCreatorThrowableFunction, hasAddingPermissionFunction, formBuilderFunction);
        }

        public <R> CollectionRoutes.Builder<T, S> addCreator(ThrowableFunction<R, T> creatorThrowableFunction, ThrowableFunction<List<R>, List<S>> batchCreatorThrowableFunction, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), this._pathToIdentifierFunction));
            this._createItemFunction = httpServletRequest -> body -> Try.fromFallible(() -> (SingleModelImpl)creatorThrowableFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body)));
            this._batchCreateItemFunction = httpServletRequest -> body -> Try.fromFallible(() -> (BatchResult)batchCreatorThrowableFunction.andThen(t -> new BatchResult(t, this._name)).apply((Object)form.getList(body)));
            return this;
        }

        public <A, B, C, D, R> CollectionRoutes.Builder<T, S> addCreator(ThrowablePentaFunction<R, A, B, C, D, T> creatorThrowablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowablePentaFunction batchCreatorThrowablePentaFunction = (formList, a, b, c, d) -> this._transformList((List)formList, r -> creatorThrowablePentaFunction.apply(r, a, b, c, d));
            return this.addCreator(creatorThrowablePentaFunction, batchCreatorThrowablePentaFunction, aClass, bClass, cClass, dClass, hasAddingPermissionFunction, formBuilderFunction);
        }

        public <A, B, C, D, R> CollectionRoutes.Builder<T, S> addCreator(ThrowablePentaFunction<R, A, B, C, D, T> creatorThrowablePentaFunction, ThrowablePentaFunction<List<R>, A, B, C, D, List<S>> batchCreatorThrowablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), this._pathToIdentifierFunction));
            this._createItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, (a, b, c, d) -> (SingleModelImpl)creatorThrowablePentaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body), a, b, c, d));
            this._batchCreateItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, (a, b, c, d) -> (BatchResult)batchCreatorThrowablePentaFunction.andThen(t -> new BatchResult(t, this._name)).apply((Object)form.getList(body), a, b, c, d));
            return this;
        }

        public <A, B, C, R> CollectionRoutes.Builder<T, S> addCreator(ThrowableTetraFunction<R, A, B, C, T> creatorThrowableTetraFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowableTetraFunction batchCreatorThrowableTetraFunction = (formList, a, b, c) -> this._transformList((List)formList, r -> creatorThrowableTetraFunction.apply(r, a, b, c));
            return this.addCreator(creatorThrowableTetraFunction, batchCreatorThrowableTetraFunction, aClass, bClass, cClass, hasAddingPermissionFunction, formBuilderFunction);
        }

        public <A, B, C, R> CollectionRoutes.Builder<T, S> addCreator(ThrowableTetraFunction<R, A, B, C, T> creatorThrowableTetraFunction, ThrowableTetraFunction<List<R>, A, B, C, List<S>> batchCreatorThrowableTetraFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), this._pathToIdentifierFunction));
            this._createItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, (a, b, c) -> (SingleModelImpl)creatorThrowableTetraFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body), a, b, c));
            this._batchCreateItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, (a, b, c) -> (BatchResult)batchCreatorThrowableTetraFunction.andThen(t -> new BatchResult(t, this._name)).apply((Object)form.getList(body), a, b, c));
            return this;
        }

        public <A, B, R> CollectionRoutes.Builder<T, S> addCreator(ThrowableTriFunction<R, A, B, T> creatorThrowableTriFunction, Class<A> aClass, Class<B> bClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            ThrowableTriFunction batchCreatorThrowableTriFunction = (formList, a, b) -> this._transformList((List)formList, r -> creatorThrowableTriFunction.apply(r, a, b));
            return this.addCreator(creatorThrowableTriFunction, batchCreatorThrowableTriFunction, aClass, bClass, hasAddingPermissionFunction, formBuilderFunction);
        }

        public <A, B, R> CollectionRoutes.Builder<T, S> addCreator(ThrowableTriFunction<R, A, B, T> creatorThrowableTriFunction, ThrowableTriFunction<List<R>, A, B, List<S>> batchCreatorThrowableTriFunction, Class<A> aClass, Class<B> bClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), this._pathToIdentifierFunction));
            this._createItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, (a, b) -> (SingleModelImpl)creatorThrowableTriFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body), a, b));
            this._batchCreateItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, (a, b) -> (BatchResult)batchCreatorThrowableTriFunction.andThen(t -> new BatchResult(t, this._name)).apply((Object)form.getList(body), a, b));
            return this;
        }

        public <R, U, I extends Identifier> CollectionRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowableBiFunction<Pagination, R, U> throwableBiFunction, Class<I> supplier, Function<Credentials, Boolean> permissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionFunction);
            CustomPageFunction requestFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, pagination -> (SingleModelImpl)throwableBiFunction.andThen(model -> new SingleModelImpl<Object>(model, this._getResourceName(supplier))).apply(pagination, this._getModel(customRoute, (Body)body)));
            this._customRouteFunctions.put(name, requestFunction);
            return this;
        }

        public <A, B, C, D, R, U, I extends Identifier> CollectionRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowableHexaFunction<Pagination, R, A, B, C, D, U> throwableHexaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, Class<I> supplier, Function<Credentials, Boolean> permissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionFunction);
            CustomPageFunction requestFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, cClass, dClass, (pagination, a, b, c, d) -> (SingleModelImpl)throwableHexaFunction.andThen(model -> new SingleModelImpl<Object>(model, this._getResourceName(supplier))).apply(pagination, this._getModel(customRoute, (Body)body), a, b, c, d));
            this._customRouteFunctions.put(name, requestFunction);
            return this;
        }

        public <A, B, C, R, U, I extends Identifier> CollectionRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowablePentaFunction<Pagination, R, A, B, C, U> throwablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<I> supplier, Function<Credentials, Boolean> permissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionFunction);
            CustomPageFunction requestFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, cClass, (pagination, a, b, c) -> (SingleModelImpl)throwablePentaFunction.andThen(model -> new SingleModelImpl<Object>(model, this._getResourceName(supplier))).apply(pagination, this._getModel(customRoute, (Body)body), a, b, c));
            this._customRouteFunctions.put(name, requestFunction);
            return this;
        }

        public <A, B, R, U, I extends Identifier> CollectionRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowableTetraFunction<Pagination, R, A, B, U> throwableTetraFunction, Class<A> aClass, Class<B> bClass, Class<I> supplier, Function<Credentials, Boolean> permissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionFunction);
            CustomPageFunction requestFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, (pagination, a, b) -> (SingleModelImpl)throwableTetraFunction.andThen(model -> new SingleModelImpl<Object>(model, this._getResourceName(supplier))).apply(pagination, this._getModel(customRoute, (Body)body), a, b));
            this._customRouteFunctions.put(name, requestFunction);
            return this;
        }

        public <A, R, U, I extends Identifier> CollectionRoutes.Builder<T, S> addCustomRoute(CustomRoute customRoute, ThrowableTriFunction<Pagination, R, A, U> throwableTriFunction, Class<A> aClass, Class<I> supplier, Function<Credentials, Boolean> permissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            String name = customRoute.getName();
            this._calculateForm(customRoute, formBuilderFunction, name);
            this._customRoutes.put(name, customRoute);
            this._customPermissionFunctions.put(name, permissionFunction);
            CustomPageFunction requestFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, (pagination, a) -> (SingleModelImpl)throwableTriFunction.andThen(model -> new SingleModelImpl<Object>(model, this._getResourceName(supplier))).apply(pagination, this._getModel(customRoute, (Body)body), a));
            this._customRouteFunctions.put(name, requestFunction);
            return this;
        }

        public <A> CollectionRoutes.Builder<T, S> addGetter(ThrowableBiFunction<Pagination, A, PageItems<T>> getterThrowableBiFunction, Class<A> aClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, Credentials.class, (pagination, a, credentials) -> (PageImpl)getterThrowableBiFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination, a));
            return this;
        }

        public CollectionRoutes.Builder<T, S> addGetter(ThrowableFunction<Pagination, PageItems<T>> getterThrowableFunction) {
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, Credentials.class, (pagination, credentials) -> (PageImpl)getterThrowableFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination));
            return this;
        }

        public <A, B, C, D> CollectionRoutes.Builder<T, S> addGetter(ThrowablePentaFunction<Pagination, A, B, C, D, PageItems<T>> getterThrowablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, cClass, dClass, Credentials.class, (pagination, a, b, c, d, credentials) -> (PageImpl)getterThrowablePentaFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination, a, b, c, d));
            return this;
        }

        public <A, B, C> CollectionRoutes.Builder<T, S> addGetter(ThrowableTetraFunction<Pagination, A, B, C, PageItems<T>> getterThrowableTetraFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, cClass, Credentials.class, (pagination, a, b, c, credentials) -> (PageImpl)getterThrowableTetraFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination, a, b, c));
            return this;
        }

        public <A, B> CollectionRoutes.Builder<T, S> addGetter(ThrowableTriFunction<Pagination, A, B, PageItems<T>> getterThrowableTriFunction, Class<A> aClass, Class<B> bClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, Credentials.class, (pagination, a, b, credentials) -> (PageImpl)getterThrowableTriFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination, a, b));
            return this;
        }

        public CollectionRoutes<T, S> build() {
            return new CollectionRoutesImpl(this);
        }

        private <R> void _calculateForm(CustomRoute customRoute, FormBuilderFunction<R> formBuilderFunction, String name) {
            if (formBuilderFunction != null) {
                Form form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("p", this._name, name), this._pathToIdentifierFunction));
                customRoute.setForm(form);
            }
        }

        private List<Operation> _createCustomOperations(Credentials credentials) {
            ArrayList<Operation> operations = new ArrayList<Operation>();
            Set<String> customPermissionKeys = this._customPermissionFunctions.keySet();
            Stream customPermissionKeysStream = customPermissionKeys.stream();
            customPermissionKeysStream.filter(key -> this._getPermissionFunction(credentials, (String)key)).forEach(routeEntry -> {
                CustomRoute customRoute = this._customRoutes.get(routeEntry);
                Optional formOptional = customRoute.getFormOptional();
                Form form = formOptional.orElse(null);
                Operation operation = this._createOperation(form, customRoute.getMethod(), this._name, this._name, (String)routeEntry);
                operations.add(operation);
            });
            return operations;
        }

        private Operation _createOperation(Form form, HTTPMethod method, String name, String path, String custom) {
            if (method == HTTPMethod.GET) {
                return new RetrieveOperation(name, true, path, custom);
            }
            if (method == HTTPMethod.POST) {
                return new CreateOperation(form, name, path, custom);
            }
            if (method == HTTPMethod.DELETE) {
                return new DeleteOperation(name, path, custom);
            }
            if (method == HTTPMethod.PUT) {
                return new UpdateOperation(form, name, path, custom);
            }
            return null;
        }

        private <R> R _getModel(CustomRoute customRoute, Body body) {
            Optional formOptional = customRoute.getFormOptional();
            return formOptional.map(form -> form.get(body)).orElse(null);
        }

        private List<Operation> _getOperations(Credentials credentials) {
            Boolean canAdd = (Boolean)Try.fromFallible(() -> (Boolean)this._hasAddingPermissionFunction.apply((Object)credentials)).orElse((Object)false);
            if (!canAdd.booleanValue()) {
                return Collections.emptyList();
            }
            ArrayList<Operation> operations = new ArrayList<Operation>();
            CreateOperation createOperation = new CreateOperation(this._form, this._name, this._name);
            operations.add(createOperation);
            BatchCreateOperation batchCreateOperation = new BatchCreateOperation(this._form, this._name, this._name);
            operations.add(batchCreateOperation);
            operations.addAll(this._createCustomOperations(credentials));
            return operations;
        }

        private Boolean _getPermissionFunction(Credentials credentials, String key) {
            return (Boolean)Try.fromFallible(() -> this._customPermissionFunctions.get(key)).map(function -> (Boolean)function.apply(credentials)).orElse((Object)false);
        }

        private <I extends Identifier> String _getResourceName(Class<I> supplier) {
            return this._nameFunction.apply(supplier.getName()).orElse(null);
        }

        private <U> List<S> _transformList(List<U> list, ThrowableFunction<U, T> transformThrowableFunction) throws Exception {
            ArrayList<Object> newList = new ArrayList<Object>();
            for (U u : list) {
                Object s = transformThrowableFunction.andThen(this._modelToIdentifierFunction::apply).apply(u);
                newList.add(s);
            }
            return newList;
        }
    }
}

