/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.request;

import com.liferay.apio.architect.internal.response.control.Embedded;
import com.liferay.apio.architect.internal.response.control.Fields;
import com.liferay.apio.architect.internal.url.ApplicationURL;
import com.liferay.apio.architect.internal.url.ServerURL;
import com.liferay.apio.architect.language.AcceptLanguage;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;

public class RequestInfo {
    private final AcceptLanguage _acceptLanguage;
    private final ApplicationURL _applicationURL;
    private final Embedded _embedded;
    private final Fields _fields;
    private final HttpServletRequest _httpServletRequest;
    private final ServerURL _serverURL;

    public static RequestInfo create(Function<Builder, RequestInfo> function) {
        return function.apply(new Builder());
    }

    public AcceptLanguage getAcceptLanguage() {
        return this._acceptLanguage;
    }

    public ApplicationURL getApplicationURL() {
        return this._applicationURL;
    }

    public Embedded getEmbedded() {
        return this._embedded;
    }

    public Fields getFields() {
        return this._fields;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._httpServletRequest;
    }

    public ServerURL getServerURL() {
        return this._serverURL;
    }

    private RequestInfo(Builder builder) {
        this._acceptLanguage = builder._acceptLanguage;
        this._fields = builder._fields;
        this._serverURL = builder._serverURL;
        this._applicationURL = builder._applicationURL;
        this._embedded = builder._embedded;
        this._httpServletRequest = builder._httpServletRequest;
    }

    public static class Builder {
        private AcceptLanguage _acceptLanguage;
        private ApplicationURL _applicationURL;
        private Embedded _embedded;
        private Fields _fields;
        private HttpServletRequest _httpServletRequest;
        private ServerURL _serverURL;

        public ServerURLStep httpServletRequest(HttpServletRequest httpServletRequest) {
            this._httpServletRequest = httpServletRequest;
            return new ServerURLStep();
        }

        public class ServerURLStep {
            public ApplicationURLStep serverURL(ServerURL serverURL) {
                Builder.this._serverURL = serverURL;
                return new ApplicationURLStep();
            }
        }

        public class LanguageStep {
            public BuildStep language(AcceptLanguage acceptLanguage) {
                Builder.this._acceptLanguage = acceptLanguage;
                return new BuildStep();
            }
        }

        public class FieldsStep {
            public LanguageStep fields(Fields fields) {
                Builder.this._fields = fields;
                return new LanguageStep();
            }
        }

        public class EmbeddedStep {
            public FieldsStep embedded(Embedded embedded) {
                Builder.this._embedded = embedded;
                return new FieldsStep();
            }
        }

        public class BuildStep {
            public RequestInfo build() {
                return new RequestInfo(Builder.this);
            }
        }

        public class ApplicationURLStep {
            public EmbeddedStep applicationURL(ApplicationURL applicationURL) {
                Builder.this._applicationURL = applicationURL;
                return new EmbeddedStep();
            }
        }
    }
}

