/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.operation;

import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.operation.Operation;
import java.util.Optional;

public class RetrieveOperation
implements Operation {
    private final boolean _collection;
    private final String _customRoute;
    private final String _resourceName;
    private final String _uri;

    public RetrieveOperation(String resourceName, boolean collection) {
        this(resourceName, collection, null);
    }

    public RetrieveOperation(String resourceName, boolean collection, String uri) {
        this(resourceName, collection, uri, null);
    }

    public RetrieveOperation(String resourceName, boolean collection, String uri, String customRoute) {
        this._resourceName = resourceName;
        this._collection = collection;
        this._uri = uri;
        this._customRoute = customRoute;
    }

    public String getCustomRoute() {
        return this._customRoute;
    }

    public Optional<Form> getFormOptional() {
        return Optional.empty();
    }

    public HTTPMethod getHttpMethod() {
        return HTTPMethod.GET;
    }

    public String getName() {
        return this._resourceName + "/" + (this.isCustom() ? this._customRoute : "retrieve");
    }

    public Optional<String> getURIOptional() {
        return Optional.ofNullable(this._uri);
    }

    public boolean isCollection() {
        return this._collection;
    }

    public boolean isCustom() {
        return this._customRoute != null;
    }
}

