/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.message.json.plain;

import com.liferay.apio.architect.internal.list.FunctionalList;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.message.json.PageMessageMapper;
import com.liferay.apio.architect.internal.message.json.SingleModelMessageMapper;
import com.liferay.apio.architect.internal.message.json.plain.PlainJSONSingleModelMessageMapper;
import com.liferay.apio.architect.single.model.SingleModel;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(service={PageMessageMapper.class})
public class PlainJSONPageMessageMapper<T>
implements PageMessageMapper<T> {
    private final SingleModelMessageMapper<T> _singleModelMessageMapper = new PlainJSONSingleModelMessageMapper();

    @Override
    public String getMediaType() {
        return "application/json";
    }

    @Override
    public Optional<SingleModelMessageMapper<T>> getSingleModelMessageMapperOptional() {
        return Optional.of(this._singleModelMessageMapper);
    }

    @Override
    public void mapCollectionURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.field("collection").stringValue(url);
    }

    @Override
    public void mapCurrentPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        this._singleModelMessageMapper.mapSelfURL(jsonObjectBuilder, url);
    }

    @Override
    public void mapFirstPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("pages", "first").stringValue(url);
    }

    @Override
    public void mapItemTotalCount(JSONObjectBuilder jsonObjectBuilder, int totalCount) {
        jsonObjectBuilder.field("totalNumberOfItems").numberValue(totalCount);
    }

    @Override
    public void mapLastPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("pages", "last").stringValue(url);
    }

    @Override
    public void mapNextPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("pages", "next").stringValue(url);
    }

    @Override
    public void mapPageCount(JSONObjectBuilder jsonObjectBuilder, int count) {
        jsonObjectBuilder.field("numberOfItems").numberValue(count);
    }

    @Override
    public void mapPreviousPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("pages", "prev").stringValue(url);
    }

    @Override
    public void onFinishItem(JSONObjectBuilder pageJSONObjectBuilder, JSONObjectBuilder itemJSONObjectBuilder, SingleModel<T> singleModel) {
        pageJSONObjectBuilder.field("elements").arrayValue().add(itemJSONObjectBuilder);
    }

    @Override
    public void onFinishNestedCollection(JSONObjectBuilder singleModelJSONObjectBuilder, JSONObjectBuilder collectionJsonObjectBuilder, String fieldName, List<?> list, FunctionalList<String> embeddedPathElements) {
        singleModelJSONObjectBuilder.nestedField(embeddedPathElements.head(), this._getTail(embeddedPathElements)).objectValue(collectionJsonObjectBuilder);
    }

    @Override
    public void onFinishNestedCollectionItem(JSONObjectBuilder collectionJsonObjectBuilder, JSONObjectBuilder itemJSONObjectBuilder, SingleModel<?> singleModel) {
        collectionJsonObjectBuilder.field("elements").arrayValue().add(itemJSONObjectBuilder);
    }

    private String[] _getTail(FunctionalList<String> embeddedPathElements) {
        Stream<String> stream = embeddedPathElements.tailStream();
        return (String[])stream.toArray(String[]::new);
    }
}

