/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.message.json.ld;

import com.liferay.apio.architect.internal.entrypoint.EntryPoint;
import com.liferay.apio.architect.internal.message.json.EntryPointMessageMapper;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={EntryPointMessageMapper.class})
public class JSONLDEntryPointMessageMapper
implements EntryPointMessageMapper {
    @Override
    public String getMediaType() {
        return "application/ld+json";
    }

    @Override
    public void mapItemSelfURL(JSONObjectBuilder entryPointJSONObjectBuilder, JSONObjectBuilder itemJSONObjectBuilder, String resourceName, String url) {
        this.mapSelfURL(itemJSONObjectBuilder, url);
    }

    @Override
    public void mapSelfURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.field("@id").stringValue(url);
    }

    @Override
    public void mapSemantics(JSONObjectBuilder jsonObjectBuilder, String semantics) {
        jsonObjectBuilder.nestedField("manages", "property").stringValue("rdf:type");
        jsonObjectBuilder.nestedField("manages", "object").stringValue("schema:" + semantics);
    }

    @Override
    public void onFinish(JSONObjectBuilder jsonObjectBuilder, EntryPoint entryPoint) {
        jsonObjectBuilder.field("@type").stringValue("EntryPoint");
        jsonObjectBuilder.field("@context").arrayValue(arrayBuilder -> arrayBuilder.add(builder -> builder.field("@vocab").stringValue("http://schema.org/")), arrayBuilder -> arrayBuilder.addString("https://www.w3.org/ns/hydra/core#"));
    }

    @Override
    public void onFinishItem(JSONObjectBuilder entryPointJSONObjectBuilder, JSONObjectBuilder itemJSONObjectBuilder) {
        itemJSONObjectBuilder.field("@type").arrayValue().addString("Collection");
        entryPointJSONObjectBuilder.field("collection").arrayValue().add(itemJSONObjectBuilder);
    }
}

