/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.internal.message.json.ld;

import com.liferay.apio.architect.internal.documentation.Documentation;
import com.liferay.apio.architect.internal.message.json.DocumentationMessageMapper;
import com.liferay.apio.architect.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.internal.message.json.ld.JSONLDMessageMapperUtil;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.operation.Operation;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(service={DocumentationMessageMapper.class})
public class JSONLDDocumentationMessageMapper
implements DocumentationMessageMapper {
    @Override
    public String getMediaType() {
        return "application/ld+json";
    }

    @Override
    public void mapDescription(JSONObjectBuilder jsonObjectBuilder, String description) {
        jsonObjectBuilder.field("description").stringValue(description);
    }

    @Override
    public void mapEntryPoint(JSONObjectBuilder jsonObjectBuilder, String entryPoint) {
        jsonObjectBuilder.field("entrypoint").stringValue(entryPoint);
    }

    @Override
    public void mapOperation(JSONObjectBuilder jsonObjectBuilder, String resourceName, String type, Operation operation, String description) {
        jsonObjectBuilder.field("@id").stringValue("_:" + operation.getName());
        jsonObjectBuilder.field("@type").arrayValue().addAllStrings(JSONLDMessageMapperUtil.getOperationTypes(operation));
        HTTPMethod httpMethod = operation.getHttpMethod();
        jsonObjectBuilder.field("method").stringValue(httpMethod.toString());
        jsonObjectBuilder.field("returns").stringValue(this._getReturnValue(type, operation));
        this._addDescription(jsonObjectBuilder, description);
    }

    @Override
    public void mapProperty(JSONObjectBuilder jsonObjectBuilder, String fieldName, String description) {
        jsonObjectBuilder.field("@type").stringValue("SupportedProperty");
        jsonObjectBuilder.field("property").stringValue(fieldName);
        this._addDescription(jsonObjectBuilder, description);
    }

    @Override
    public void mapResource(JSONObjectBuilder jsonObjectBuilder, String resourceType, String description) {
        jsonObjectBuilder.field("@id").stringValue(resourceType);
        jsonObjectBuilder.field("@type").stringValue("Class");
        jsonObjectBuilder.field("title").stringValue(resourceType);
        this._addDescription(jsonObjectBuilder, description);
    }

    @Override
    public void mapResourceCollection(JSONObjectBuilder jsonObjectBuilder, String resourceType, String description) {
        jsonObjectBuilder.field("@id").stringValue("vocab:" + resourceType + "Collection");
        jsonObjectBuilder.field("@type").stringValue("Class");
        jsonObjectBuilder.field("subClassOf").stringValue("Collection");
        jsonObjectBuilder.field("description").stringValue("A collection of " + resourceType);
        jsonObjectBuilder.field("title").stringValue(resourceType + "Collection");
        Stream.of("totalItems", "member", "numberOfItems").forEach(fieldName -> {
            JSONObjectBuilder propertyJsonObjectBuilder = new JSONObjectBuilder();
            this.mapProperty(propertyJsonObjectBuilder, (String)fieldName, description);
            this.onFinishProperty(jsonObjectBuilder, propertyJsonObjectBuilder, (String)fieldName);
        });
        this._addDescription(jsonObjectBuilder, description);
    }

    @Override
    public void mapTitle(JSONObjectBuilder jsonObjectBuilder, String title) {
        jsonObjectBuilder.field("title").stringValue(title);
    }

    @Override
    public void onFinish(JSONObjectBuilder jsonObjectBuilder, Documentation documentation) {
        jsonObjectBuilder.field("@context").arrayValue(arrayBuilder -> arrayBuilder.add(builder -> builder.field("@vocab").stringValue("http://schema.org/")), arrayBuilder -> arrayBuilder.addString("https://www.w3.org/ns/hydra/core#"), arrayBuilder -> arrayBuilder.add(builder -> builder.field("expects").fields(nestedBuilder -> nestedBuilder.field("@type").stringValue("@id"), nestedBuilder -> nestedBuilder.field("@id").stringValue("hydra:expects")), builder -> builder.field("returns").fields(nestedBuilder -> nestedBuilder.field("@id").stringValue("hydra:returns"), nestedBuilder -> nestedBuilder.field("@type").stringValue("@id"))));
        jsonObjectBuilder.field("@id").stringValue("/doc");
        jsonObjectBuilder.field("@type").stringValue("ApiDocumentation");
    }

    @Override
    public void onFinishOperation(JSONObjectBuilder documentationJsonObjectBuilder, JSONObjectBuilder operationJsonObjectBuilder, Operation operation) {
        documentationJsonObjectBuilder.field("supportedOperation").arrayValue().add(operationJsonObjectBuilder);
    }

    @Override
    public void onFinishProperty(JSONObjectBuilder documentationJsonObjectBuilder, JSONObjectBuilder propertyJsonObjectBuilder, String formField) {
        documentationJsonObjectBuilder.field("supportedProperty").arrayValue().add(propertyJsonObjectBuilder);
    }

    @Override
    public void onFinishResource(JSONObjectBuilder documentationJsonObjectBuilder, JSONObjectBuilder resourceJsonObjectBuilder, String type) {
        documentationJsonObjectBuilder.field("supportedClass").arrayValue().add(resourceJsonObjectBuilder);
    }

    private void _addDescription(JSONObjectBuilder documentationJsonObjectBuilder, String description) {
        if (description != null) {
            documentationJsonObjectBuilder.field("comment").stringValue(description);
        }
    }

    private String _getReturnValue(String type, Operation operation) {
        String value = null;
        HTTPMethod httpMethod = operation.getHttpMethod();
        value = HTTPMethod.DELETE.equals((Object)httpMethod) ? "http://www.w3.org/2002/07/owl#Nothing" : (operation.isCollection() && httpMethod.equals((Object)HTTPMethod.GET) ? "Collection" : type);
        return value;
    }
}

